/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.testng.Assert;

public final class BlockAssertions {
    public static final ConnectorSession SESSION = new ConnectorSession("user", TimeZoneKey.UTC_KEY, Locale.ENGLISH, System.currentTimeMillis(), null);

    private BlockAssertions() {
    }

    public static Object getOnlyValue(Type type, Block block) {
        Assert.assertEquals((int)block.getPositionCount(), (int)1, (String)"Block positions");
        return type.getObjectValue(SESSION, block, 0);
    }

    public static List<Object> toValues(Type type, Iterable<Block> blocks) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Block block : blocks) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                values.add(type.getObjectValue(SESSION, block, position));
            }
        }
        return Collections.unmodifiableList(values);
    }

    public static List<Object> toValues(Type type, Block block) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.add(type.getObjectValue(SESSION, block, position));
        }
        return Collections.unmodifiableList(values);
    }

    public static void assertBlockEquals(Type type, Block actual, Block expected) {
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(SESSION, actual, position), (Object)type.getObjectValue(SESSION, expected, position));
        }
    }

    public static Block createStringsBlock(String ... values) {
        Preconditions.checkNotNull((Object)values, (Object)"varargs 'values' is null");
        return BlockAssertions.createStringsBlock(Arrays.asList(values));
    }

    public static Block createStringsBlock(Iterable<String> values) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeString(builder, value);
        }
        return builder.build();
    }

    public static Block createStringSequenceBlock(int start, int end) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < end; ++i) {
            VarcharType.VARCHAR.writeString(builder, String.valueOf(i));
        }
        return builder.build();
    }

    public static Block createBooleansBlock(Boolean ... values) {
        Preconditions.checkNotNull((Object)values, (Object)"varargs 'values' is null");
        return BlockAssertions.createBooleansBlock(Arrays.asList(values));
    }

    public static Block createBooleansBlock(Boolean value, int count) {
        return BlockAssertions.createBooleansBlock(Collections.nCopies(count, value));
    }

    public static Block createBooleansBlock(Iterable<Boolean> values) {
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus());
        for (Boolean value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BooleanType.BOOLEAN.writeBoolean(builder, value.booleanValue());
        }
        return builder.build();
    }

    public static Block createLongsBlock(int ... values) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (int value : values) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.build();
    }

    public static Block createLongsBlock(Long ... values) {
        Preconditions.checkNotNull((Object)values, (Object)"varargs 'values' is null");
        return BlockAssertions.createLongsBlock(Arrays.asList(values));
    }

    public static Block createLongsBlock(Iterable<Long> values) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (Long value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(builder, value.longValue());
        }
        return builder.build();
    }

    public static Block createLongSequenceBlock(int start, int end) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < end; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createBooleanSequenceBlock(int start, int end) {
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < end; ++i) {
            BooleanType.BOOLEAN.writeBoolean(builder, i % 2 == 0);
        }
        return builder.build();
    }

    public static Block createDoublesBlock(Double ... values) {
        Preconditions.checkNotNull((Object)values, (Object)"varargs 'values' is null");
        return BlockAssertions.createDoublesBlock(Arrays.asList(values));
    }

    public static Block createDoublesBlock(Iterable<Double> values) {
        BlockBuilder builder = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus());
        for (Double value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            DoubleType.DOUBLE.writeDouble(builder, value.doubleValue());
        }
        return builder.build();
    }

    public static Block createDoubleSequenceBlock(int start, int end) {
        BlockBuilder builder = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < end; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, (double)i);
        }
        return builder.build();
    }
}

