/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressionAssertions;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.testng.annotations.Test;

public class TestInvokeDynamicByteCodeExpression {
    public static final Method TEST_BOOTSTRAP_METHOD;

    @Test
    public void testInvokeStaticMethod() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.invokeDynamic((Method)TEST_BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)"bar"), (String)"foo", String.class, (ByteCodeExpression[])new ByteCodeExpression[]{ByteCodeExpressions.constantString((String)"baz")}), "foo-bar-baz", "[bootstrap(\"bar\")]=>foo(\"baz\")");
    }

    public static CallSite bootstrap(MethodHandles.Lookup callerLookup, String name, MethodType type, String prefix) throws Exception {
        MethodHandle methodHandle = callerLookup.findVirtual(String.class, "concat", MethodType.methodType(String.class, String.class));
        methodHandle = methodHandle.bindTo(name + "-" + prefix + "-");
        return new ConstantCallSite(methodHandle);
    }

    static {
        try {
            TEST_BOOTSTRAP_METHOD = TestInvokeDynamicByteCodeExpression.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

