/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.concurrent;

import com.facebook.presto.concurrent.FairBatchExecutor;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.Threads;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFairBatchExecutor {
    @Test
    public void testSanity() throws Exception {
        FairBatchExecutor executor = new FairBatchExecutor(1, Threads.daemonThreadsNamed((String)"test-%s"));
        final CountDownLatch readyToStart = new CountDownLatch(1);
        executor.processBatch((Collection)ImmutableList.of((Object)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                readyToStart.await();
                return null;
            }
        }));
        LinkedBlockingDeque<Integer> executions = new LinkedBlockingDeque<Integer>();
        ArrayList futures = new ArrayList();
        MeetingPoint meetingPoint = new MeetingPoint();
        futures.addAll(executor.processBatch((Collection)ImmutableList.of(TestFairBatchExecutor.newTask(1, executions), TestFairBatchExecutor.newTask(2, executions), TestFairBatchExecutor.newTask(3, executions), TestFairBatchExecutor.newTask(4, executions), TestFairBatchExecutor.newTask(5, meetingPoint, executions), TestFairBatchExecutor.newTask(6, executions), TestFairBatchExecutor.newTask(7, executions), TestFairBatchExecutor.newTask(8, executions), TestFairBatchExecutor.newTask(9, executions))));
        futures.addAll(executor.processBatch((Collection)ImmutableList.of(TestFairBatchExecutor.newTask(2, executions), TestFairBatchExecutor.newTask(3, executions), TestFairBatchExecutor.newTask(4, executions), TestFairBatchExecutor.newTask(5, meetingPoint, executions), TestFairBatchExecutor.newTask(6, executions))));
        futures.addAll(executor.processBatch((Collection)ImmutableList.of(TestFairBatchExecutor.newTask(3, executions), TestFairBatchExecutor.newTask(4, executions), TestFairBatchExecutor.newTask(5, meetingPoint, executions), TestFairBatchExecutor.newTask(6, executions), TestFairBatchExecutor.newTask(7, executions), TestFairBatchExecutor.newTask(8, executions))));
        readyToStart.countDown();
        meetingPoint.waitForArrival();
        futures.addAll(executor.processBatch((Collection)ImmutableList.of(TestFairBatchExecutor.newTask(5, executions), TestFairBatchExecutor.newTask(6, executions), TestFairBatchExecutor.newTask(7, executions), TestFairBatchExecutor.newTask(8, executions), TestFairBatchExecutor.newTask(9, executions))));
        meetingPoint.notifyAdvance();
        for (Future future : futures) {
            future.get();
        }
        Assert.assertTrue((boolean)Ordering.natural().isOrdered(executions), (String)((Object)executions).toString());
        executor.shutdown();
    }

    private static Callable<Void> newTask(int group, Queue<Integer> executions) {
        return TestFairBatchExecutor.newTask(group, null, executions);
    }

    private static Callable<Void> newTask(final int group, final MeetingPoint meetingPoint, final Queue<Integer> executions) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                executions.add(group);
                if (meetingPoint != null) {
                    try {
                        meetingPoint.waitForNextPhase();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                return null;
            }
        };
    }

    private static class MeetingPoint {
        private final CountDownLatch arrived = new CountDownLatch(1);
        private final CountDownLatch readyForNextPhase = new CountDownLatch(1);

        private MeetingPoint() {
        }

        public void waitForNextPhase() throws InterruptedException {
            this.arrived.countDown();
            this.readyForNextPhase.await();
        }

        public void waitForArrival() throws InterruptedException {
            this.arrived.await();
        }

        public void notifyAdvance() {
            this.readyForNextPhase.countDown();
        }
    }
}

