/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TaskExecutorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=100)
    public void test() throws Exception {
        TaskExecutor taskExecutor = new TaskExecutor(4);
        taskExecutor.start();
        try {
            TaskExecutor.TaskHandle taskHandle = taskExecutor.addTask(new TaskId("test", "test", "test"));
            Phaser beginPhase = new Phaser();
            beginPhase.register();
            Phaser verificationComplete = new Phaser();
            verificationComplete.register();
            TestingJob driver1 = new TestingJob(beginPhase, verificationComplete, 10);
            ListenableFuture future1 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits(taskHandle, true, (List)ImmutableList.of((Object)driver1)));
            TestingJob driver2 = new TestingJob(beginPhase, verificationComplete, 10);
            ListenableFuture future2 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits(taskHandle, true, (List)ImmutableList.of((Object)driver2)));
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)0);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)0);
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)0);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)0);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)1);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)1);
            verificationComplete.arriveAndAwaitAdvance();
            TestingJob driver3 = new TestingJob(beginPhase, verificationComplete, 10);
            ListenableFuture future3 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits(taskHandle, false, (List)ImmutableList.of((Object)driver3)));
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)2);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)2);
            Assert.assertEquals((int)driver3.getCompletedPhases(), (int)0);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            for (int i = 0; i < 7; ++i) {
                verificationComplete.arriveAndAwaitAdvance();
                beginPhase.arriveAndAwaitAdvance();
                Assert.assertEquals((int)beginPhase.getPhase(), (int)(verificationComplete.getPhase() + 1));
            }
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver3.getCompletedPhases(), (int)8);
            future1.get(1L, TimeUnit.SECONDS);
            future2.get(1L, TimeUnit.SECONDS);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver3.getCompletedPhases(), (int)10);
            future3.get(1L, TimeUnit.SECONDS);
            verificationComplete.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getFirstPhase(), (int)0);
            Assert.assertEquals((int)driver2.getFirstPhase(), (int)0);
            Assert.assertEquals((int)driver3.getFirstPhase(), (int)2);
            Assert.assertEquals((int)driver1.getLastPhase(), (int)10);
            Assert.assertEquals((int)driver2.getLastPhase(), (int)10);
            Assert.assertEquals((int)driver3.getLastPhase(), (int)12);
        }
        finally {
            taskExecutor.stop();
        }
    }

    private static class TestingJob
    implements SplitRunner {
        private final Phaser awaitWorkers;
        private final Phaser awaitVerifiers;
        private final int requiredPhases;
        private final AtomicInteger completedPhases = new AtomicInteger();
        private final AtomicInteger firstPhase = new AtomicInteger(-1);
        private final AtomicInteger lastPhase = new AtomicInteger(-1);

        public TestingJob(Phaser awaitWorkers, Phaser awaitVerifiers, int requiredPhases) {
            this.awaitWorkers = awaitWorkers;
            this.awaitVerifiers = awaitVerifiers;
            this.requiredPhases = requiredPhases;
            awaitWorkers.register();
            awaitVerifiers.register();
        }

        private int getFirstPhase() {
            return this.firstPhase.get();
        }

        private int getLastPhase() {
            return this.lastPhase.get();
        }

        private int getCompletedPhases() {
            return this.completedPhases.get();
        }

        public ListenableFuture<?> processFor(Duration duration) throws Exception {
            int phase = this.awaitWorkers.arriveAndAwaitAdvance();
            this.firstPhase.compareAndSet(-1, phase - 1);
            this.lastPhase.set(phase);
            this.awaitVerifiers.arriveAndAwaitAdvance();
            this.completedPhases.getAndIncrement();
            return Futures.immediateFuture(null);
        }

        public boolean isFinished() {
            boolean isFinished;
            boolean bl = isFinished = this.completedPhases.get() >= this.requiredPhases;
            if (isFinished) {
                this.awaitVerifiers.arriveAndDeregister();
                this.awaitWorkers.arriveAndDeregister();
            }
            return isFinished;
        }

        public void close() {
        }
    }
}

