/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.TaskSource;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.Page;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.NullEventClient;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlTaskManager {
    private static final TaskId TASK_ID = new TaskId("query", "stage", "task");
    public static final TaskId OUT = new TaskId("query", "stage", "out");
    private final TaskExecutor taskExecutor = new TaskExecutor(8);

    public TestSqlTaskManager() {
        this.taskExecutor.start();
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.taskExecutor.stop();
    }

    @Test
    public void testEmptyQuery() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testSimpleQuery() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            BufferResult results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE)).get();
            Assert.assertEquals((boolean)results.isBufferClosed(), (boolean)false);
            Assert.assertEquals((int)results.getPages().size(), (int)1);
            Assert.assertEquals((int)((Page)results.getPages().get(0)).getPositionCount(), (int)1);
            results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, results.getToken() + (long)results.getPages().size(), new DataSize(1.0, DataSize.Unit.MEGABYTE)).get();
            Assert.assertEquals((boolean)results.isBufferClosed(), (boolean)true);
            Assert.assertEquals((int)results.getPages().size(), (int)0);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getState()).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testCancel() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbort() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.abortTask(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbortResults() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            sqlTaskManager.abortTaskResults(taskId, OUT);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getState()).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testRemoveOldTasks() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig().setInfoMaxAge(new Duration(5.0, TimeUnit.MILLISECONDS)));){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.CANCELED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.CANCELED);
            Thread.sleep(100L);
            sqlTaskManager.removeOldTasks();
            for (TaskInfo info : sqlTaskManager.getAllTaskInfo()) {
                Assert.assertNotEquals((Object)info.getTaskId(), (Object)taskId);
            }
        }
    }

    public SqlTaskManager createSqlTaskManager(TaskManagerConfig config) {
        return new SqlTaskManager(TaskTestUtils.createTestingPlanner(), (LocationFactory)new MockLocationFactory(), this.taskExecutor, new QueryMonitor(new ObjectMapperProvider().get(), (EventClient)new NullEventClient(), new NodeInfo("test")), config);
    }

    public static class MockLocationFactory
    implements LocationFactory {
        public URI createQueryLocation(QueryId queryId) {
            return URI.create("fake://query/" + queryId);
        }

        public URI createStageLocation(StageId stageId) {
            return URI.create("fake://stage/" + stageId);
        }

        public URI createLocalTaskLocation(TaskId taskId) {
            return URI.create("fake://task/" + taskId);
        }

        public URI createTaskLocation(Node node, TaskId taskId) {
            return URI.create("fake://task/" + node.getNodeIdentifier() + "/" + taskId);
        }
    }

    public static class MockExchangeClientSupplier
    implements Supplier<ExchangeClient> {
        public ExchangeClient get() {
            throw new UnsupportedOperationException();
        }
    }
}

