/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.StageStats;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStageStats {
    public static final StageStats EXPECTED = new StageStats(new DateTime(0L), TestStageStats.getTestDistribution(1), TestStageStats.getTestDistribution(2), TestStageStats.getTestDistribution(3), 4, 5, 6, 7, 8, 10, 11, new DataSize(12.0, DataSize.Unit.BYTE), new Duration(13.0, TimeUnit.NANOSECONDS), new Duration(14.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new DataSize(17.0, DataSize.Unit.BYTE), 18L, new DataSize(19.0, DataSize.Unit.BYTE), 20L, new DataSize(21.0, DataSize.Unit.BYTE), 22L);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(StageStats.class);
        String json = codec.toJson((Object)EXPECTED);
        StageStats actual = (StageStats)codec.fromJson(json);
        TestStageStats.assertExpectedStageStats(actual);
    }

    public static void assertExpectedStageStats(StageStats actual) {
        Assert.assertEquals((long)actual.getSchedulingComplete().getMillis(), (long)0L);
        Assert.assertEquals((Object)actual.getGetSplitDistribution().getCount(), (Object)1.0);
        Assert.assertEquals((Object)actual.getScheduleTaskDistribution().getCount(), (Object)2.0);
        Assert.assertEquals((Object)actual.getAddSplitDistribution().getCount(), (Object)3.0);
        Assert.assertEquals((int)actual.getTotalTasks(), (int)4);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)5);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)6);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)10);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)11);
        Assert.assertEquals((Object)actual.getTotalMemoryReservation(), (Object)new DataSize(12.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(13.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(14.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalUserTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(17.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)18L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(19.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)20L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(21.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)22L);
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

