/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.DiscoveryNodeManager;
import com.facebook.presto.metadata.NodeVersion;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.server.NoOpFailureDetector;
import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.testing.StaticServiceSelector;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import io.airlift.testing.Assertions;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDiscoveryNodeManager {
    private final NodeInfo nodeInfo = new NodeInfo("test");
    private NodeVersion expectedVersion;
    private List<PrestoNode> activeNodes;
    private List<PrestoNode> inactiveNodes;
    private ServiceSelector selector;

    @BeforeMethod
    public void setup() {
        this.expectedVersion = new NodeVersion("1");
        this.activeNodes = ImmutableList.of((Object)new PrestoNode(this.nodeInfo.getNodeId(), URI.create("http://192.0.1.1"), this.expectedVersion), (Object)new PrestoNode(UUID.randomUUID().toString(), URI.create("http://192.0.2.1:8080"), this.expectedVersion), (Object)new PrestoNode(UUID.randomUUID().toString(), URI.create("http://192.0.2.3"), this.expectedVersion), (Object)new PrestoNode(UUID.randomUUID().toString(), URI.create("https://192.0.2.8"), this.expectedVersion));
        this.inactiveNodes = ImmutableList.of((Object)new PrestoNode(UUID.randomUUID().toString(), URI.create("https://192.0.3.9"), NodeVersion.UNKNOWN), (Object)new PrestoNode(UUID.randomUUID().toString(), URI.create("https://192.0.4.9"), new NodeVersion("2")));
        ArrayList<ServiceDescriptor> descriptors = new ArrayList<ServiceDescriptor>();
        for (PrestoNode node : Iterables.concat(this.activeNodes, this.inactiveNodes)) {
            descriptors.add(ServiceDescriptor.serviceDescriptor((String)"presto").setNodeId(node.getNodeIdentifier()).addProperty("http", node.getHttpUri().toString()).addProperty("node_version", node.getNodeVersion().toString()).build());
        }
        this.selector = new StaticServiceSelector(descriptors);
    }

    @Test
    public void testGetAllNodes() throws Exception {
        DiscoveryNodeManager manager = new DiscoveryNodeManager(this.selector, this.nodeInfo, (FailureDetector)new NoOpFailureDetector(), this.expectedVersion);
        AllNodes allNodes = manager.getAllNodes();
        Set activeNodes = allNodes.getActiveNodes();
        Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, this.activeNodes);
        for (Node actual : activeNodes) {
            for (Node node : this.activeNodes) {
                Assert.assertNotSame((Object)actual, (Object)node);
            }
        }
        Set inactiveNodes = allNodes.getInactiveNodes();
        Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, this.inactiveNodes);
        for (Node actual : inactiveNodes) {
            for (Node node : this.inactiveNodes) {
                Assert.assertNotSame((Object)actual, (Object)node);
            }
        }
    }

    @Test
    public void testGetCurrentNode() {
        Node expected = (Node)this.activeNodes.get(0);
        NodeInfo nodeInfo = new NodeInfo(new NodeConfig().setEnvironment("test").setNodeId(expected.getNodeIdentifier()));
        DiscoveryNodeManager manager = new DiscoveryNodeManager(this.selector, nodeInfo, (FailureDetector)new NoOpFailureDetector(), this.expectedVersion);
        Assert.assertEquals((Object)manager.getCurrentNode(), (Object)expected);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp=".* current node not returned .*")
    public void testGetCurrentNodeRequired() {
        new DiscoveryNodeManager(this.selector, new NodeInfo("test"), (FailureDetector)new NoOpFailureDetector(), this.expectedVersion);
    }
}

