/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestingMetadata
implements ConnectorMetadata {
    private final ConcurrentMap<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();
    private final ConcurrentMap<SchemaTableName, String> views = new ConcurrentHashMap<SchemaTableName, String>();

    public List<String> listSchemaNames(ConnectorSession session) {
        HashSet<String> schemaNames = new HashSet<String>();
        for (SchemaTableName schemaTableName : this.tables.keySet()) {
            schemaNames.add(schemaTableName.getSchemaName());
        }
        return ImmutableList.copyOf(schemaNames);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return new InMemoryTableHandle(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ConnectorTableMetadata tableMetadata = (ConnectorTableMetadata)this.tables.get(tableName);
        Preconditions.checkArgument((tableMetadata != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        return tableMetadata;
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new InMemoryColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return null;
    }

    public boolean canCreateSampledTables(ConnectorSession session) {
        return false;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchemaName())) {
            int position = 1;
            ImmutableList.Builder columns = ImmutableList.builder();
            for (ColumnMetadata column : ((ConnectorTableMetadata)this.tables.get(tableName)).getColumns()) {
                columns.add((Object)new ColumnMetadata(column.getName(), column.getType(), position, false));
                ++position;
            }
            tableColumns.put((Object)tableName, (Object)columns.build());
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        int columnIndex = ((InMemoryColumnHandle)Types.checkType((Object)columnHandle, InMemoryColumnHandle.class, (String)"columnHandle")).getOrdinalPosition();
        return (ColumnMetadata)((ConnectorTableMetadata)this.tables.get(tableName)).getColumns().get(columnIndex);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tables.keySet()) {
            if (schemaNameOrNull != null && !schemaNameOrNull.equals(tableName.getSchemaName())) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public void renameTable(ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        ConnectorTableMetadata table = this.getTableMetadata(tableHandle);
        if (this.tables.putIfAbsent(newTableName, table) != null) {
            throw new IllegalArgumentException("Target table already exists: " + newTableName);
        }
        this.tables.remove(table.getTable(), table);
    }

    public ConnectorTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        ConnectorTableMetadata existingTable = this.tables.putIfAbsent(tableMetadata.getTable(), tableMetadata);
        Preconditions.checkArgument((existingTable == null ? 1 : 0) != 0, (String)"Table %s already exists", (Object[])new Object[]{tableMetadata.getTable()});
        return new InMemoryTableHandle(tableMetadata.getTable());
    }

    public void dropTable(ConnectorTableHandle tableHandle) {
        this.tables.remove(TestingMetadata.getTableName(tableHandle));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void commitCreateTable(ConnectorOutputTableHandle tableHandle, Collection<String> fragments) {
        throw new UnsupportedOperationException();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    public void commitInsert(ConnectorInsertTableHandle insertHandle, Collection<String> fragments) {
        throw new UnsupportedOperationException();
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        if (replace) {
            this.views.put(viewName, viewData);
        } else if (this.views.putIfAbsent(viewName, viewData) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + viewName);
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName viewName : this.views.keySet()) {
            if (schemaNameOrNull != null && !schemaNameOrNull.equals(viewName.getSchemaName())) continue;
            builder.add((Object)viewName);
        }
        return builder.build();
    }

    public Map<SchemaTableName, String> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry entry : this.views.entrySet()) {
            if (!prefix.matches((SchemaTableName)entry.getKey())) continue;
            map.put(entry);
        }
        return map.build();
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof InMemoryTableHandle), (Object)"tableHandle is not an instance of InMemoryTableHandle");
        InMemoryTableHandle inMemoryTableHandle = (InMemoryTableHandle)tableHandle;
        return inMemoryTableHandle.getTableName();
    }

    public static class InMemoryColumnHandle
    implements ConnectorColumnHandle {
        private final String name;
        private final int ordinalPosition;
        private final Type type;

        public InMemoryColumnHandle(String name, int ordinalPosition, Type type) {
            this.name = name;
            this.ordinalPosition = ordinalPosition;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static class InMemoryTableHandle
    implements ConnectorTableHandle {
        private final SchemaTableName tableName;

        public InMemoryTableHandle(SchemaTableName schemaTableName) {
            this.tableName = schemaTableName;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }
    }
}

