/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGroupByHash {
    private static final int MAX_GROUP_ID = 500;

    @Test
    public void testGetGroupIds() throws Exception {
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}, Optional.of(1), 100);
        for (int tries = 0; tries < 2; ++tries) {
            for (int value = 0; value < 500; ++value) {
                Block block = BlockAssertions.createLongsBlock(value);
                Block hashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)BigintType.BIGINT), (Block[])new Block[]{block});
                Page page = new Page(new Block[]{block, hashBlock});
                for (int addValuesTries = 0; addValuesTries < 10; ++addValuesTries) {
                    GroupByIdBlock groupIds = groupByHash.getGroupIds(page);
                    Assert.assertEquals((long)groupIds.getGroupCount(), (long)(tries == 0 ? (long)(value + 1) : 500L));
                    Assert.assertEquals((int)groupIds.getPositionCount(), (int)1);
                    long groupId = groupIds.getGroupId(0);
                    Assert.assertEquals((long)groupId, (long)value);
                }
            }
        }
    }

    @Test
    public void testTypes() throws Exception {
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)VarcharType.VARCHAR), new int[]{0}, Optional.of(1), 100);
        Assert.assertEquals((Collection)groupByHash.getTypes(), (Collection)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
    }

    @Test
    public void testAppendTo() throws Exception {
        Block valuesBlock = BlockAssertions.createStringSequenceBlock(0, 100);
        Block hashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Block[])new Block[]{valuesBlock});
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)VarcharType.VARCHAR), new int[]{0}, Optional.of(1), 100);
        GroupByIdBlock groupIds = groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock}));
        for (int i = 0; i < groupIds.getPositionCount(); ++i) {
            Assert.assertEquals((long)groupIds.getGroupId(i), (long)i);
        }
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)100);
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int i = 0; i < groupByHash.getGroupCount(); ++i) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(i, pageBuilder, 0);
        }
        Page page = pageBuilder.build();
        for (int i = 0; i < groupByHash.getTypes().size(); ++i) {
            Assert.assertEquals((int)page.getBlock(i).getPositionCount(), (int)100);
        }
        Assert.assertEquals((int)page.getPositionCount(), (int)100);
        BlockAssertions.assertBlockEquals((Type)VarcharType.VARCHAR, page.getBlock(0), valuesBlock);
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, page.getBlock(1), hashBlock);
    }

    @Test
    public void testAppendToMultipleTuplesPerGroup() throws Exception {
        ArrayList<Long> values = new ArrayList<Long>();
        for (long i = 0L; i < 100L; ++i) {
            values.add(i % 50L);
        }
        Block valuesBlock = BlockAssertions.createLongsBlock(values);
        Block hashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)BigintType.BIGINT), (Block[])new Block[]{valuesBlock});
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}, Optional.of(1), 100);
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock}));
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)50);
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int i = 0; i < groupByHash.getGroupCount(); ++i) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(i, pageBuilder, 0);
        }
        Page outputPage = pageBuilder.build();
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)50);
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, outputPage.getBlock(1), BlockAssertions.createLongSequenceBlock(0, 50));
    }

    @Test
    public void testContains() throws Exception {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(0, 10);
        Block hashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)DoubleType.DOUBLE), (Block[])new Block[]{valuesBlock});
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)DoubleType.DOUBLE), new int[]{0}, Optional.of(1), 100);
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock}));
        Block testBlock = BlockAssertions.createDoublesBlock(3.0);
        Block testHashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)DoubleType.DOUBLE), (Block[])new Block[]{testBlock});
        Assert.assertTrue((boolean)groupByHash.contains(0, new Page(new Block[]{testBlock, testHashBlock})));
        testBlock = BlockAssertions.createDoublesBlock(11.0);
        testHashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)DoubleType.DOUBLE), (Block[])new Block[]{testBlock});
        Assert.assertFalse((boolean)groupByHash.contains(0, new Page(new Block[]{testBlock, testHashBlock})));
    }

    @Test
    public void testContainsMultipleColumns() throws Exception {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(0, 10);
        Block stringValuesBlock = BlockAssertions.createStringSequenceBlock(0, 10);
        Block hashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR), (Block[])new Block[]{valuesBlock, stringValuesBlock});
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR), new int[]{0, 1}, Optional.of(2), 100);
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, stringValuesBlock, hashBlock}));
        Block testValuesBlock = BlockAssertions.createDoublesBlock(3.0);
        Block testStringValuesBlock = BlockAssertions.createStringsBlock("3");
        Block testHashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR), (Block[])new Block[]{testValuesBlock, testStringValuesBlock});
        Assert.assertTrue((boolean)groupByHash.contains(0, new Page(new Block[]{testValuesBlock, testStringValuesBlock, testHashBlock})));
    }

    @Test
    public void testForceRehash() throws Exception {
        Block valuesBlock = BlockAssertions.createStringSequenceBlock(0, 100);
        Block hashBlock = TypeUtils.getHashBlock((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Block[])new Block[]{valuesBlock});
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)VarcharType.VARCHAR), new int[]{0}, Optional.of(1), 4);
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock}));
        for (int i = 0; i < valuesBlock.getPositionCount(); ++i) {
            Assert.assertTrue((boolean)groupByHash.contains(i, new Page(new Block[]{valuesBlock, hashBlock})));
        }
    }
}

