/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashJoinOperator {
    private ExecutorService executor;
    private TaskContext taskContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.taskContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION);
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testInnerJoin(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.addSequencePage(10, 20, 30, 40).build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(1000, 0, 1000, 2000).build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.innerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"20", 1020, 2020, "20", 30, 40}).row(new Object[]{"21", 1021, 2021, "21", 31, 41}).row(new Object[]{"22", 1022, 2022, "22", 32, 42}).row(new Object[]{"23", 1023, 2023, "23", 33, 43}).row(new Object[]{"24", 1024, 2024, "24", 34, 44}).row(new Object[]{"25", 1025, 2025, "25", 35, 45}).row(new Object[]{"26", 1026, 2026, "26", 36, 46}).row(new Object[]{"27", 1027, 2027, "27", 37, 47}).row(new Object[]{"28", 1028, 2028, "28", 38, 48}).row(new Object[]{"29", 1029, 2029, "29", 39, 49}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)buildTypes.size(), (Object)(buildTypes.size() + probeTypes.size() + 1)));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testInnerJoinWithNullProbe(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row("a").row("b").row("c").build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.innerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)(buildTypes.size() + probeTypes.size())));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testInnerJoinWithNullBuild(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.innerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)buildTypes.size(), (Object)(buildTypes.size() + probeTypes.size() + 1)));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testInnerJoinWithNullOnBothSides(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.innerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)(buildTypes.size() + probeTypes.size())));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testProbeOuterJoin(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.addSequencePage(10, 20, 30, 40).build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator hashBuilderOperator = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{hashBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.outerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"20", 1020, 2020, "20", 30, 40}).row(new Object[]{"21", 1021, 2021, "21", 31, 41}).row(new Object[]{"22", 1022, 2022, "22", 32, 42}).row(new Object[]{"23", 1023, 2023, "23", 33, 43}).row(new Object[]{"24", 1024, 2024, "24", 34, 44}).row(new Object[]{"25", 1025, 2025, "25", 35, 45}).row(new Object[]{"26", 1026, 2026, "26", 36, 46}).row(new Object[]{"27", 1027, 2027, "27", 37, 47}).row(new Object[]{"28", 1028, 2028, "28", 38, 48}).row(new Object[]{"29", 1029, 2029, "29", 39, 49}).row(new Object[]{"30", 1030, 2030, null, null, null}).row(new Object[]{"31", 1031, 2031, null, null, null}).row(new Object[]{"32", 1032, 2032, null, null, null}).row(new Object[]{"33", 1033, 2033, null, null, null}).row(new Object[]{"34", 1034, 2034, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)buildTypes.size(), (Object)(buildTypes.size() + probeTypes.size() + 1)));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testOuterJoinWithNullProbe(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row("a").row("b").row("c").build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.outerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)(buildTypes.size() + probeTypes.size())));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testOuterJoinWithNullBuild(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.outerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)(buildTypes.size() + probeTypes.size())));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testOuterJoinWithNullOnBothSides(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build());
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 100);
        Operator sourceHashProvider = hashBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{sourceHashProvider});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = LookupJoinOperators.outerJoin((int)0, (LookupSourceSupplier)hashBuilderOperatorFactory.getLookupSourceSupplier(), rowPagesBuilderProbe.getTypes(), (List)Ints.asList((int[])new int[]{0}), rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(this.taskContext.addPipelineContext(true, true).addDriverContext());
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)(buildTypes.size() + probeTypes.size())));
    }

    @Test(expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Task exceeded max memory size.*", dataProvider="hashEnabledValues")
    public void testMemoryLimit(boolean hashEnabled) throws Exception {
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(100.0, DataSize.Unit.BYTE)).addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.addSequencePage(10, 20, 30, 40).build());
        Operator hashBuilderOperator = new HashBuilderOperator.HashBuilderOperatorFactory(1, rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), rowPagesBuilder.getHashChannel(), 1500000).createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{hashBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
    }
}

