/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.UnnestOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestUnnestOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testUnnest() throws Exception {
        MetadataManager metadata = new MetadataManager();
        Type arrayType = metadata.getType(TypeSignature.parseTypeSignature((String)"array<bigint>"));
        Type mapType = metadata.getType(TypeSignature.parseTypeSignature((String)"map<bigint,bigint>"));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1, "[2, 3]", "{\"4\": 5}").row(2, "[99]", null).row(3, null, null).pageBreak().row(6, "[7, 8]", "{\"9\": 10, \"11\": 12}").build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 2, 4, 5}).row(new Object[]{1, 3, null, null}).row(new Object[]{2, 99, null, null}).row(new Object[]{6, 7, 9, 10}).row(new Object[]{6, 8, 11, 12}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testUnnestNonNumericDoubles() throws Exception {
        MetadataManager metadata = new MetadataManager();
        Type arrayType = metadata.getType(TypeSignature.parseTypeSignature((String)"array<double>"));
        Type mapType = metadata.getType(TypeSignature.parseTypeSignature((String)"map<bigint,double>"));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1, "[\"-Infinity\", \"Infinity\", \"NaN\"]", "{\"1\": \"-Infinity\", \"2\": \"Infinity\", \"3\": \"NaN\"}").build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1, Double.NEGATIVE_INFINITY, 1, Double.NEGATIVE_INFINITY}).row(new Object[]{1, Double.POSITIVE_INFINITY, 2, Double.POSITIVE_INFINITY}).row(new Object[]{1, Double.NaN, 3, Double.NaN}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }
}

