/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestApproximateAggregationFunction;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import java.util.List;

public class TestDoubleApproximateAverageAggregation
extends AbstractTestApproximateAggregationFunction {
    @Override
    protected Type getType() {
        return DoubleType.DOUBLE;
    }

    @Override
    protected Double getExpectedValue(List<Number> values) {
        int length = 0;
        double sum = 0.0;
        for (Number value : values) {
            if (value == null) continue;
            ++length;
            sum += value.doubleValue();
        }
        if (length == 0) {
            return null;
        }
        return sum / (double)length;
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }
}

