/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestLongMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block getSequenceBlock(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return blockBuilder.build();
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return (long)start + (long)length - 1L;
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"bigint");
    }
}

