/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.TestingRowConstructor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestMapAggAggregation {
    private static final MetadataManager metadata = new MetadataManager();

    @Test
    public void testDuplicateKeysValues() throws Exception {
        MapType mapType = new MapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", "varchar"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)"a"), new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), BlockAssertions.createStringsBlock("a", "b", "c")}));
        mapType = new MapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT);
        aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", "bigint"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)99L, (Object)2.0, (Object)99L, (Object)3.0, (Object)99L), new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createLongsBlock(99L, 99L, 99L)}));
    }

    @Test
    public void testSimpleMaps() throws Exception {
        MapType mapType = new MapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", "varchar"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)"a", (Object)2.0, (Object)"b", (Object)3.0, (Object)"c"), new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringsBlock("a", "b", "c")}));
        mapType = new MapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT);
        aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", "bigint"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)3L, (Object)2.0, (Object)2L, (Object)3.0, (Object)1L), new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createLongsBlock(3L, 2L, 1L)}));
        mapType = new MapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN);
        aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", "boolean"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)true, (Object)2.0, (Object)false, (Object)3.0, (Object)false), new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createBooleansBlock(true, false, false)}));
    }

    @Test
    public void testNull() throws Exception {
        InternalAggregationFunction doubleDouble = metadata.getExactFunction(new Signature("map_agg", new MapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE).getTypeSignature().toString(), new String[]{"double", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)2.0), new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0)}));
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, null, new Page(new Block[]{BlockAssertions.createDoublesBlock(null, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0)}));
        LinkedHashMap<Double, Object> expected = new LinkedHashMap<Double, Object>();
        expected.put(1.0, null);
        expected.put(2.0, null);
        expected.put(3.0, null);
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, expected, new Page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(null, null, null)}));
    }

    @Test
    public void testDoubleArrayMap() throws Exception {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        MapType mapType = new MapType((Type)DoubleType.DOUBLE, (Type)arrayType);
        InternalAggregationFunction aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", arrayType.getTypeSignature().toString()})).getAggregationFunction();
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)arrayType));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 1.0);
        arrayType.writeSlice(builder.getBlockBuilder(1), ArrayType.toStackRepresentation((List)ImmutableList.of((Object)"a", (Object)"b")));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 2.0);
        arrayType.writeSlice(builder.getBlockBuilder(1), ArrayType.toStackRepresentation((List)ImmutableList.of((Object)"c", (Object)"d")));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 3.0);
        arrayType.writeSlice(builder.getBlockBuilder(1), ArrayType.toStackRepresentation((List)ImmutableList.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f")), builder.build());
    }

    @Test
    public void testDoubleMapMap() throws Exception {
        MapType innerMapType = new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        MapType mapType = new MapType((Type)DoubleType.DOUBLE, (Type)innerMapType);
        InternalAggregationFunction aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", innerMapType.getTypeSignature().toString()})).getAggregationFunction();
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)innerMapType));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 1.0);
        innerMapType.writeSlice(builder.getBlockBuilder(1), MapType.toStackRepresentation((Map)ImmutableMap.of((Object)"a", (Object)"b")));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 2.0);
        innerMapType.writeSlice(builder.getBlockBuilder(1), MapType.toStackRepresentation((Map)ImmutableMap.of((Object)"c", (Object)"d")));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 3.0);
        innerMapType.writeSlice(builder.getBlockBuilder(1), MapType.toStackRepresentation((Map)ImmutableMap.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")), builder.build());
    }

    @Test
    public void testDoubleRowMap() throws Exception {
        RowType innerRowType = new RowType((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Optional.of(ImmutableList.of((Object)"f1", (Object)"f2")));
        MapType mapType = new MapType((Type)DoubleType.DOUBLE, (Type)innerRowType);
        InternalAggregationFunction aggFunc = metadata.getExactFunction(new Signature("map_agg", mapType.getTypeSignature().toString(), new String[]{"double", innerRowType.getTypeSignature().toString()})).getAggregationFunction();
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)innerRowType));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 1.0);
        innerRowType.writeSlice(builder.getBlockBuilder(1), TestingRowConstructor.testRowBigintBigint((Long)1L, (Double)1.0));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 2.0);
        innerRowType.writeSlice(builder.getBlockBuilder(1), TestingRowConstructor.testRowBigintBigint((Long)2L, (Double)2.0));
        builder.declarePosition();
        DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(0), 3.0);
        innerRowType.writeSlice(builder.getBlockBuilder(1), TestingRowConstructor.testRowBigintBigint((Long)3L, (Double)3.0));
        AggregationTestUtils.assertAggregation(aggFunc, 1.0, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)2.0, (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)3.0, (Object)ImmutableList.of((Object)3L, (Object)3.0)), builder.build());
    }
}

