/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractFixedWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMinByAggregation {
    private static final MetadataManager metadata = new MetadataManager();

    @BeforeClass
    public void setup() {
        ((TypeRegistry)metadata.getTypeManager()).addType((Type)CustomDoubleType.CUSTOM_DOUBLE);
    }

    @Test
    public void testAllRegistered() {
        Set orderableTypes = (Set)metadata.getTypeManager().getTypes().stream().filter(Type::isOrderable).collect(ImmutableCollectors.toImmutableSet());
        for (Type keyType : orderableTypes) {
            for (Type valueType : metadata.getTypeManager().getTypes()) {
                Assert.assertNotNull((Object)metadata.getExactFunction(new Signature("min_by", valueType.getTypeSignature(), new TypeSignature[]{valueType.getTypeSignature(), keyType.getTypeSignature()})));
            }
        }
    }

    @Test
    public void testNull() throws Exception {
        InternalAggregationFunction doubleDouble = metadata.getExactFunction(new Signature("min_by", "double", new String[]{"double", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, (Object)1.0, TestMinByAggregation.createPage(new Double[]{1.0, null}, new Double[]{1.0, 2.0}));
    }

    @Test
    public void testDoubleDouble() throws Exception {
        InternalAggregationFunction doubleDouble = metadata.getExactFunction(new Signature("min_by", "double", new String[]{"double", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, null, TestMinByAggregation.createPage(new Double[]{null}, new Double[]{null}), TestMinByAggregation.createPage(new Double[]{null}, new Double[]{null}));
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, (Object)3.0, TestMinByAggregation.createPage(new Double[]{3.0, 2.0}, new Double[]{1.0, 1.5}), TestMinByAggregation.createPage(new Double[]{5.0, 3.0}, new Double[]{2.0, 4.0}));
    }

    @Test
    public void testDoubleVarchar() throws Exception {
        InternalAggregationFunction doubleVarchar = metadata.getExactFunction(new Signature("min_by", "varchar", new String[]{"varchar", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleVarchar, 1.0, (Object)"z", TestMinByAggregation.createPage(new String[]{"z", "a"}, new Double[]{1.0, 2.0}), TestMinByAggregation.createPage(new String[]{"x", "b"}, new Double[]{2.0, 3.0}));
        AggregationTestUtils.assertAggregation(doubleVarchar, 1.0, (Object)"a", TestMinByAggregation.createPage(new String[]{"zz", "hi"}, new Double[]{0.0, 1.0}), TestMinByAggregation.createPage(new String[]{"bb", "a"}, new Double[]{2.0, -1.0}));
    }

    private static Page createPage(Double[] values, Double[] keys) {
        return new Page(new Block[]{BlockAssertions.createDoublesBlock(values), BlockAssertions.createDoublesBlock(keys)});
    }

    private static Page createPage(String[] values, Double[] keys) {
        return new Page(new Block[]{BlockAssertions.createStringsBlock(values), BlockAssertions.createDoublesBlock(keys)});
    }

    private static class CustomDoubleType
    extends AbstractFixedWidthType {
        public static final CustomDoubleType CUSTOM_DOUBLE = new CustomDoubleType();
        public static final String NAME = "custom_double";

        private CustomDoubleType() {
            super(TypeSignature.parseTypeSignature((String)NAME), Double.TYPE, 8);
        }

        public boolean isComparable() {
            return true;
        }

        public boolean isOrderable() {
            return true;
        }

        public Object getObjectValue(ConnectorSession session, Block block, int position) {
            if (block.isNull(position)) {
                return null;
            }
            return block.getDouble(position, 0);
        }

        public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
            long rightValue;
            long leftValue = leftBlock.getLong(leftPosition, 0);
            return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
        }

        public int hash(Block block, int position) {
            long value = block.getLong(position, 0);
            return (int)(value ^ value >>> 32);
        }

        public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
            double leftValue = leftBlock.getDouble(leftPosition, 0);
            double rightValue = rightBlock.getDouble(rightPosition, 0);
            return Double.compare(leftValue, rightValue);
        }

        public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
            if (block.isNull(position)) {
                blockBuilder.appendNull();
            } else {
                blockBuilder.writeDouble(block.getDouble(position, 0)).closeEntry();
            }
        }

        public double getDouble(Block block, int position) {
            return block.getDouble(position, 0);
        }

        public void writeDouble(BlockBuilder blockBuilder, double value) {
            blockBuilder.writeDouble(value).closeEntry();
        }
    }
}

