/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class TestVarBinaryMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block getSequenceBlock(int start, int length) {
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(new BlockBuilderStatus());
        for (int i = 0; i < length; ++i) {
            VarbinaryType.VARBINARY.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])Ints.toByteArray((int)i)));
        }
        return blockBuilder.build();
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        Slice max = null;
        for (int i = 0; i < length; ++i) {
            Slice slice = Slices.wrappedBuffer((byte[])Ints.toByteArray((int)i));
            max = max == null ? slice : (Slice)Ordering.natural().max((Object)max, (Object)slice);
        }
        return max.toString(StandardCharsets.UTF_8);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"varchar");
    }
}

