/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.GenericPageProcessor;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.InterpretedFilterFunction;
import com.facebook.presto.sql.planner.InterpretedProjectionFunction;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.testing.Assertions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public final class FunctionAssertions {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Page SOURCE_PAGE = new Page(new Block[]{BlockAssertions.createLongsBlock(1234L), BlockAssertions.createStringsBlock("hello"), BlockAssertions.createDoublesBlock(12.34), BlockAssertions.createBooleansBlock(true), BlockAssertions.createLongsBlock(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis()), BlockAssertions.createStringsBlock("%el%"), BlockAssertions.createStringsBlock(new String[]{null})});
    private static final Page ZERO_CHANNEL_PAGE = new Page(1, new Block[0]);
    private static final Map<Integer, Type> INPUT_TYPES = ImmutableMap.builder().put((Object)0, (Object)BigintType.BIGINT).put((Object)1, (Object)VarcharType.VARCHAR).put((Object)2, (Object)DoubleType.DOUBLE).put((Object)3, (Object)BooleanType.BOOLEAN).put((Object)4, (Object)BigintType.BIGINT).put((Object)5, (Object)VarcharType.VARCHAR).put((Object)6, (Object)VarcharType.VARCHAR).build();
    private static final Map<Symbol, Integer> INPUT_MAPPING = ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)0).put((Object)new Symbol("bound_string"), (Object)1).put((Object)new Symbol("bound_double"), (Object)2).put((Object)new Symbol("bound_boolean"), (Object)3).put((Object)new Symbol("bound_timestamp"), (Object)4).put((Object)new Symbol("bound_pattern"), (Object)5).put((Object)new Symbol("bound_null_string"), (Object)6).build();
    private static final Map<Symbol, Type> SYMBOL_TYPES = ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_double"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bound_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("bound_timestamp"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_pattern"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_null_string"), (Object)VarcharType.VARCHAR).build();
    private static final PageSourceProvider PAGE_SOURCE_PROVIDER = new TestPageSourceProvider();
    private static final PlanNodeId SOURCE_ID = new PlanNodeId("scan");
    private final Session session;
    private final LocalQueryRunner runner;
    private final Metadata metadata;
    private final ExpressionCompiler compiler;

    public FunctionAssertions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    public FunctionAssertions(Session session) {
        this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.runner = new LocalQueryRunner(session);
        this.metadata = this.runner.getMetadata();
        this.compiler = new ExpressionCompiler(this.metadata);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public FunctionAssertions addFunctions(List<ParametricFunction> functionInfos) {
        this.metadata.addFunctions(functionInfos);
        return this;
    }

    public FunctionAssertions addScalarFunctions(Class<?> clazz) {
        this.metadata.addFunctions(new FunctionListBuilder(this.metadata.getTypeManager()).scalar(clazz).getFunctions());
        return this;
    }

    public void assertFunction(String projection, Object expected) {
        if (expected instanceof Integer) {
            expected = ((Integer)expected).longValue();
        } else if (expected instanceof Slice) {
            expected = ((Slice)expected).toString(StandardCharsets.UTF_8);
        }
        Object actual = this.selectSingleValue(projection, this.compiler);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void assertFunctionNull(String projection) {
        Assert.assertNull((Object)this.selectSingleValue(projection, this.compiler));
    }

    public void tryEvaluate(String expression) {
        this.tryEvaluate(expression, this.session);
    }

    public void tryEvaluate(String expression, Session session) {
        this.selectUniqueValue(expression, session, this.compiler);
    }

    public void tryEvaluateWithAll(String expression, Session session) {
        this.executeProjectionWithAll(expression, session, this.compiler);
    }

    private Object selectSingleValue(String projection, ExpressionCompiler compiler) {
        return this.selectUniqueValue(projection, this.session, compiler);
    }

    private Object selectUniqueValue(String projection, Session session, ExpressionCompiler compiler) {
        List<Object> results = this.executeProjectionWithAll(projection, session, compiler);
        HashSet<Object> resultSet = new HashSet<Object>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only one result unique result, but got " + resultSet));
        return Iterables.getOnlyElement(resultSet);
    }

    public List<Object> executeProjectionWithAll(String projection, Session session, ExpressionCompiler compiler) {
        Preconditions.checkNotNull((Object)projection, (Object)"projection is null");
        Expression projectionExpression = FunctionAssertions.createExpression(projection, this.metadata, SYMBOL_TYPES);
        ArrayList<Object> results = new ArrayList<Object>();
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        OperatorFactory operatorFactory = this.compileFilterProject((Expression)BooleanLiteral.TRUE_LITERAL, projectionExpression, compiler);
        Object directOperatorValue = this.selectSingleValue(operatorFactory, session);
        results.add(directOperatorValue);
        Object interpretedValue = this.selectSingleValue(this.interpretedFilterProject((Expression)BooleanLiteral.TRUE_LITERAL, projectionExpression, session));
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = this.compileScanFilterProject((Expression)BooleanLiteral.TRUE_LITERAL, projectionExpression, compiler);
        Object scanOperatorValue = this.selectSingleValue(scanProjectOperatorFactory, TestSplit.createNormalSplit(), session);
        results.add(scanOperatorValue);
        Object recordValue = this.selectSingleValue(scanProjectOperatorFactory, TestSplit.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        return results;
    }

    private Object selectSingleValue(OperatorFactory operatorFactory, Session session) {
        Operator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        return this.selectSingleValue(operator);
    }

    private Object selectSingleValue(SourceOperatorFactory operatorFactory, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return this.selectSingleValue((Operator)operator);
    }

    private Object selectSingleValue(Operator operator) {
        Page output = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((int)output.getPositionCount(), (int)1);
        Assert.assertEquals((int)output.getChannelCount(), (int)1);
        Type type = (Type)operator.getTypes().get(0);
        Block block = output.getBlock(0);
        Assert.assertEquals((int)block.getPositionCount(), (int)1);
        return type.getObjectValue(this.session.toConnectorSession(), block, 0);
    }

    public void assertFilter(String filter, boolean expected, boolean withNoInputColumns) {
        this.assertFilter(filter, expected, withNoInputColumns, this.compiler);
    }

    private void assertFilter(String filter, boolean expected, boolean withNoInputColumns, ExpressionCompiler compiler) {
        List<Boolean> results = this.executeFilterWithAll(filter, SessionTestUtils.TEST_SESSION, withNoInputColumns, compiler);
        HashSet<Boolean> resultSet = new HashSet<Boolean>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only [" + expected + "] result unique result, but got " + resultSet));
        Assert.assertEquals((boolean)((Boolean)Iterables.getOnlyElement(resultSet)), (boolean)expected);
    }

    private List<Boolean> executeFilterWithAll(String filter, Session session, boolean executeWithNoInputColumns, ExpressionCompiler compiler) {
        Preconditions.checkNotNull((Object)filter, (Object)"filter is null");
        Expression filterExpression = FunctionAssertions.createExpression(filter, this.metadata, SYMBOL_TYPES);
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        OperatorFactory operatorFactory = this.compileFilterProject(filterExpression, (Expression)BooleanLiteral.TRUE_LITERAL, compiler);
        results.add(FunctionAssertions.executeFilter(operatorFactory, session));
        if (executeWithNoInputColumns) {
            operatorFactory = this.compileFilterWithNoInputColumns(filterExpression, compiler);
            results.add(FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory, session));
        }
        boolean interpretedValue = FunctionAssertions.executeFilter(this.interpretedFilterProject(filterExpression, (Expression)BooleanLiteral.TRUE_LITERAL, session));
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = this.compileScanFilterProject(filterExpression, (Expression)BooleanLiteral.TRUE_LITERAL, compiler);
        boolean scanOperatorValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, TestSplit.createNormalSplit(), session);
        results.add(scanOperatorValue);
        boolean recordValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, TestSplit.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(filterExpression)) {
            Boolean queryResult;
            MaterializedResult result = this.runner.execute("SELECT TRUE WHERE " + filter);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            if (result.getMaterializedRows().isEmpty()) {
                queryResult = false;
            } else {
                Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
                queryResult = (Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            }
            results.add(queryResult);
        }
        return results;
    }

    public static Expression createExpression(String expression, Metadata metadata, Map<Symbol, Type> symbolTypes) {
        Expression parsedExpression = SQL_PARSER.createExpression(expression);
        final ExpressionAnalysis analysis = ExpressionAnalyzer.analyzeExpressionsWithSymbols((Session)SessionTestUtils.TEST_SESSION, (Metadata)metadata, (SqlParser)SQL_PARSER, symbolTypes, (Iterable)ImmutableList.of((Object)parsedExpression));
        Expression rewrittenExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                Type coercion = analysis.getCoercion(node);
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coercion.getTypeSignature().toString());
                }
                return rewrittenExpression;
            }
        }, (Expression)parsedExpression);
        return CanonicalizeExpressions.canonicalizeExpression((Expression)rewrittenExpression);
    }

    private static boolean executeFilterWithNoInputColumns(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilter(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(SourceOperatorFactory operatorFactory, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return FunctionAssertions.executeFilter((Operator)operator);
    }

    private static boolean executeFilter(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)1);
            Assert.assertTrue((boolean)((Type)operator.getTypes().get(0)).getBoolean(page.getBlock(0), 0));
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean executeFilterWithNoInputColumns(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, ZERO_CHANNEL_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)0);
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean needsBoundValue(Expression projectionExpression) {
        final AtomicBoolean hasQualifiedNameReference = new AtomicBoolean();
        projectionExpression.accept((AstVisitor)new DefaultTraversalVisitor<Void, Void>(){

            protected Void visitQualifiedNameReference(QualifiedNameReference node, Void context) {
                hasQualifiedNameReference.set(true);
                return null;
            }
        }, null);
        return hasQualifiedNameReference.get();
    }

    private Operator interpretedFilterProject(Expression filter, Expression projection, Session session) {
        InterpretedFilterFunction filterFunction = new InterpretedFilterFunction(filter, SYMBOL_TYPES, INPUT_MAPPING, this.metadata, SQL_PARSER, session);
        InterpretedProjectionFunction projectionFunction = new InterpretedProjectionFunction(projection, SYMBOL_TYPES, INPUT_MAPPING, this.metadata, SQL_PARSER, session);
        FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, (PageProcessor)new GenericPageProcessor((FilterFunction)filterFunction, (Iterable)ImmutableList.of((Object)projectionFunction)), LocalExecutionPlanner.toTypes((List)ImmutableList.of((Object)projectionFunction)));
        return operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
    }

    private OperatorFactory compileFilterWithNoInputColumns(Expression filter, ExpressionCompiler compiler) {
        filter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter((Map)ImmutableMap.of()), (Expression)filter);
        IdentityHashMap expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput((Session)SessionTestUtils.TEST_SESSION, (Metadata)this.metadata, (SqlParser)SQL_PARSER, INPUT_TYPES, (Iterable)ImmutableList.of((Object)filter));
        try {
            PageProcessor processor = compiler.compilePageProcessor(SqlToRowExpressionTranslator.translate((Expression)filter, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false), (List)ImmutableList.of());
            return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, processor, (List)ImmutableList.of());
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + filter + ": " + e.getMessage(), e);
        }
    }

    private OperatorFactory compileFilterProject(Expression filter, Expression projection, ExpressionCompiler compiler) {
        filter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(INPUT_MAPPING), (Expression)filter);
        projection = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(INPUT_MAPPING), (Expression)projection);
        IdentityHashMap expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput((Session)SessionTestUtils.TEST_SESSION, (Metadata)this.metadata, (SqlParser)SQL_PARSER, INPUT_TYPES, (Iterable)ImmutableList.of((Object)filter, (Object)projection));
        try {
            ImmutableList projections = ImmutableList.of((Object)SqlToRowExpressionTranslator.translate((Expression)projection, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false));
            PageProcessor processor = compiler.compilePageProcessor(SqlToRowExpressionTranslator.translate((Expression)filter, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false), (List)projections);
            return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, processor, (List)ImmutableList.of(expressionTypes.get(projection)));
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + projection + ": " + e.getMessage(), e);
        }
    }

    private SourceOperatorFactory compileScanFilterProject(Expression filter, Expression projection, ExpressionCompiler compiler) {
        filter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(INPUT_MAPPING), (Expression)filter);
        projection = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(INPUT_MAPPING), (Expression)projection);
        IdentityHashMap expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput((Session)SessionTestUtils.TEST_SESSION, (Metadata)this.metadata, (SqlParser)SQL_PARSER, INPUT_TYPES, (Iterable)ImmutableList.of((Object)filter, (Object)projection));
        try {
            CursorProcessor cursorProcessor = compiler.compileCursorProcessor(SqlToRowExpressionTranslator.translate((Expression)filter, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false), (List)ImmutableList.of((Object)SqlToRowExpressionTranslator.translate((Expression)projection, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false)), (Object)SOURCE_ID);
            PageProcessor pageProcessor = compiler.compilePageProcessor(SqlToRowExpressionTranslator.translate((Expression)filter, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false), (List)ImmutableList.of((Object)SqlToRowExpressionTranslator.translate((Expression)projection, (IdentityHashMap)expressionTypes, (Metadata)this.metadata, (Session)this.session, (boolean)false)));
            return new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, SOURCE_ID, PAGE_SOURCE_PROVIDER, cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of(expressionTypes.get(projection)));
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + projection + ": " + e.getMessage(), e);
        }
    }

    private static Page getAtMostOnePage(Operator operator, Page sourcePage) {
        if (operator.needsInput()) {
            operator.addInput(sourcePage);
        }
        Page result = operator.getOutput();
        operator.finish();
        while (!operator.isFinished()) {
            Assert.assertTrue((boolean)operator.isBlocked().isDone());
            Page output = operator.getOutput();
            if (output == null) continue;
            Assert.assertNull((Object)result);
            result = output;
        }
        return result;
    }

    private static DriverContext createDriverContext(Session session) {
        return new TaskContext(new TaskId("query", "stage", "task"), (Executor)EXECUTOR, session).addPipelineContext(true, true).addDriverContext();
    }

    static class TestSplit
    implements ConnectorSplit {
        private final boolean recordSet;

        static Split createRecordSetSplit() {
            return new Split("test", (ConnectorSplit)new TestSplit(true));
        }

        static Split createNormalSplit() {
            return new Split("test", (ConnectorSplit)new TestSplit(false));
        }

        private TestSplit(boolean recordSet) {
            this.recordSet = recordSet;
        }

        private boolean isRecordSet() {
            return this.recordSet;
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class TestPageSourceProvider
    implements PageSourceProvider {
        private TestPageSourceProvider() {
        }

        public ConnectorPageSource createPageSource(Split split, List<ColumnHandle> columns) {
            Assertions.assertInstanceOf((Object)split.getConnectorSplit(), TestSplit.class);
            TestSplit testSplit = (TestSplit)split.getConnectorSplit();
            if (testSplit.isRecordSet()) {
                InMemoryRecordSet records = InMemoryRecordSet.builder((Collection)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).addRow(new Object[]{1234L, "hello", 12.34, true, new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis(), "%el%", null}).build();
                return new RecordPageSource((RecordSet)records);
            }
            return new FixedPageSource((Iterable)ImmutableList.of((Object)SOURCE_PAGE));
        }
    }
}

