/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConditions {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testLike() {
        this.assertFunction("'_monkey_' like 'X_monkeyX_' escape 'X'", true);
        this.assertFunction("'monkey' like 'monkey'", true);
        this.assertFunction("'monkey' like 'mon%'", true);
        this.assertFunction("'monkey' like 'mon_ey'", true);
        this.assertFunction("'monkey' like 'm____y'", true);
        this.assertFunction("'monkey' like 'dain'", false);
        this.assertFunction("'monkey' like 'key'", false);
        this.assertFunction("'_monkey_' like '\\_monkey\\_'", false);
        this.assertFunction("'_monkey_' like 'X_monkeyX_' escape 'X'", true);
        this.assertFunction("'_monkey_' like '_monkey_' escape ''", true);
        this.assertFunction("'*?.(){}+|^$,\\' like '*?.(){}+|^$,\\' escape ''", true);
        this.assertFunction("null like 'monkey'", null);
        this.assertFunction("'monkey' like null", null);
        this.assertFunction("'monkey' like 'monkey' escape null", null);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*escape must be empty or a single character.*")
    public void testLikeInvalidEscape() {
        this.evaluate("'monkey' like 'monkey' escape 'foo'");
    }

    @Test
    public void testBetween() {
        this.assertFunction("3 between 2 and 4", true);
        this.assertFunction("3 between 3 and 3", true);
        this.assertFunction("3 between 2 and 3", true);
        this.assertFunction("3 between 3 and 4", true);
        this.assertFunction("3 between 4 and 2", false);
        this.assertFunction("2 between 3 and 4", false);
        this.assertFunction("5 between 3 and 4", false);
        this.assertFunction("null between 2 and 4", null);
        this.assertFunction("3 between null and 4", null);
        this.assertFunction("3 between 2 and null", null);
        this.assertFunction("'c' between 'b' and 'd'", true);
        this.assertFunction("'c' between 'c' and 'c'", true);
        this.assertFunction("'c' between 'b' and 'c'", true);
        this.assertFunction("'c' between 'c' and 'd'", true);
        this.assertFunction("'c' between 'd' and 'b'", false);
        this.assertFunction("'b' between 'c' and 'd'", false);
        this.assertFunction("'e' between 'c' and 'd'", false);
        this.assertFunction("null between 'b' and 'd'", null);
        this.assertFunction("'c' between null and 'd'", null);
        this.assertFunction("'c' between 'b' and null", null);
    }

    @Test
    public void testIn() {
        this.assertFunction("3 in (2, 4, 3, 5)", true);
        this.assertFunction("3 not in (2, 4, 3, 5)", false);
        this.assertFunction("3 in (2, 4, 9, 5)", false);
        this.assertFunction("3 in (2, null, 3, 5)", true);
        this.assertFunction("'foo' in ('bar', 'baz', 'foo', 'blah')", true);
        this.assertFunction("'foo' in ('bar', 'baz', 'buz', 'blah')", false);
        this.assertFunction("'foo' in ('bar', null, 'foo', 'blah')", true);
        this.assertFunction("(null in (2, null, 3, 5)) is null", true);
        this.assertFunction("(3 in (2, null)) is null", true);
        this.assertFunction("(null not in (2, null, 3, 5)) is null", true);
        this.assertFunction("(3 not in (2, null)) is null", true);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testInDoesNotShortCircuit() {
        this.evaluate("3 in (2, 4, 3, 5 / 0)");
    }

    @Test
    public void testSearchCase() {
        this.assertFunction("case when true then 33 end", 33L);
        this.assertFunction("case when false then 1 else 33 end", 33L);
        this.assertFunction("case when false then 1 when false then 1 when true then 33 else 1 end", 33L);
        this.assertFunction("case when false then 1 end", null);
        this.assertFunction("case when true then null else 'foo' end", null);
        this.assertFunction("case when null then 1 when true then 33 end", 33L);
        this.assertFunction("case when false then 1.0 when true then 33 end", 33.0);
    }

    @Test
    public void testSimpleCase() {
        this.assertFunction("case true when true then cast(null as varchar) else 'foo' end", null);
        this.assertFunction("case true when true then 33 end", 33L);
        this.assertFunction("case true when false then 1 else 33 end", 33L);
        this.assertFunction("case true when false then 1 when false then 1 when true then 33 else 1 end", 33L);
        this.assertFunction("case true when false then 1 end", null);
        this.assertFunction("case true when true then null else 'foo' end", null);
        this.assertFunction("case true when null then 1 when true then 33 end", 33L);
        this.assertFunction("case null when true then 1 else 33 end", 33);
        this.assertFunction("case true when false then 1.0 when true then 33 end", 33.0);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private void evaluate(String projection) {
        this.functionAssertions.tryEvaluate(projection);
    }
}

