/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJsonFunctions {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testJsonArrayLength() {
        this.assertFunction("JSON_ARRAY_LENGTH('[]')", 0);
        this.assertFunction("JSON_ARRAY_LENGTH('[1]')", 1);
        this.assertFunction("JSON_ARRAY_LENGTH('[1, \"foo\", null]')", 3);
        this.assertFunction("JSON_ARRAY_LENGTH('[2, 4, {\"a\": [8, 9]}, [], [5], 4]')", 6);
        this.assertFunction("JSON_ARRAY_LENGTH(CAST('[]' AS JSON))", 0);
        this.assertFunction("JSON_ARRAY_LENGTH(CAST('[1]' AS JSON))", 1);
        this.assertFunction("JSON_ARRAY_LENGTH(CAST('[1, \"foo\", null]' AS JSON))", 3);
        this.assertFunction("JSON_ARRAY_LENGTH(CAST('[2, 4, {\"a\": [8, 9]}, [], [5], 4]' AS JSON))", 6);
    }

    @Test
    public void testJsonArrayContainsBoolean() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[true]', true)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[false]', false)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[true, false]', false)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[false, true]', true)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1]', true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[[true]]', true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null, \"true\"]', true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], false]', false)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[]' AS JSON), true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[true]' AS JSON), true)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[false]' AS JSON), false)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[true, false]' AS JSON), false)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[false, true]' AS JSON), true)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1]' AS JSON), true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[[true]]' AS JSON), true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1, \"foo\", null, \"true\"]' AS JSON), true)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[2, 4, {\"a\": [8, 9]}, [], [5], false]' AS JSON), false)", true);
    }

    @Test
    public void testJsonArrayContainsLong() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', 1)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[3]', 3)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[-4]', -4)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1.0]', 1)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[[2]]', 2)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null, \"8\"]', 8)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], 6]', 6)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[92233720368547758071]', -9)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[]' AS JSON), 1)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[3]' AS JSON), 3)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[-4]' AS JSON), -4)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1.0]' AS JSON), 1)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[[2]]' AS JSON), 2)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1, \"foo\", null, \"8\"]' AS JSON), 8)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[2, 4, {\"a\": [8, 9]}, [], [5], 6]' AS JSON), 6)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[92233720368547758071]' AS JSON), -9)", false);
    }

    @Test
    public void testJsonArrayContainsDouble() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', 1)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1.5]', 1.5)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[-9.5]', -9.5)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1]', 1.0)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[[2.5]]', 2.5)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null, \"8.2\"]', 8.2)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], 6.1]', 6.1)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[9.6E400]', 4.2)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[]' AS JSON), 1)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1.5]' AS JSON), 1.5)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[-9.5]' AS JSON), -9.5)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1]' AS JSON), 1.0)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[[2.5]]' AS JSON), 2.5)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1, \"foo\", null, \"8.2\"]' AS JSON), 8.2)", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[2, 4, {\"a\": [8, 9]}, [], [5], 6.1]' AS JSON), 6.1)", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[9.6E400]' AS JSON), 4.2)", false);
    }

    @Test
    public void testJsonArrayContainsString() {
        this.assertFunction("JSON_ARRAY_CONTAINS('[]', 'x')", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"foo\"]', 'foo')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"foo\", null]', cast(null as varchar))", null);
        this.assertFunction("JSON_ARRAY_CONTAINS('[\"8\"]', '8')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, \"foo\", null]', 'foo')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS('[1, 5]', '5')", false);
        this.assertFunction("JSON_ARRAY_CONTAINS('[2, 4, {\"a\": [8, 9]}, [], [5], \"6\"]', '6')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[]' AS JSON), 'x')", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[\"foo\"]' AS JSON), 'foo')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[\"foo\", null]' AS JSON), cast(null as varchar))", null);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[\"8\"]' AS JSON), '8')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1, \"foo\", null]' AS JSON), 'foo')", true);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[1, 5]' AS JSON), '5')", false);
        this.assertFunction("JSON_ARRAY_CONTAINS(CAST('[2, 4, {\"a\": [8, 9]}, [], [5], \"6\"]' AS JSON), '6')", true);
    }

    @Test
    public void testJsonArrayGetLong() {
        this.assertFunction("JSON_ARRAY_GET('[1]', 0)", Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4]', 1)", Slices.utf8Slice((String)String.valueOf(7)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', 6)", Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET('[]', 0)", null);
        this.assertFunction("JSON_ARRAY_GET('[1, 3, 2]', 3)", null);
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -1)", Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -2)", Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -7)", Slices.utf8Slice((String)String.valueOf(2)));
        this.assertFunction("JSON_ARRAY_GET('[2, 7, 4, 6, 8, 1, 0]', -8)", null);
        this.assertFunction("JSON_ARRAY_GET(CAST('[1]' AS JSON), 0)", Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[2, 7, 4]' AS JSON), 1)", Slices.utf8Slice((String)String.valueOf(7)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[2, 7, 4, 6, 8, 1, 0]' AS JSON), 6)", Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[]' AS JSON), 0)", null);
        this.assertFunction("JSON_ARRAY_GET(CAST('[1, 3, 2]' AS JSON), 3)", null);
        this.assertFunction("JSON_ARRAY_GET(CAST('[2, 7, 4, 6, 8, 1, 0]' AS JSON), -1)", Slices.utf8Slice((String)String.valueOf(0)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[2, 7, 4, 6, 8, 1, 0]' AS JSON), -2)", Slices.utf8Slice((String)String.valueOf(1)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[2, 7, 4, 6, 8, 1, 0]' AS JSON), -7)", Slices.utf8Slice((String)String.valueOf(2)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[2, 7, 4, 6, 8, 1, 0]' AS JSON), -8)", null);
    }

    @Test
    public void testJsonArrayGetString() {
        this.assertFunction("JSON_ARRAY_GET('[\"jhfa\"]', 0)", "jhfa");
        this.assertFunction("JSON_ARRAY_GET('[\"jhfa\", null]', 1)", null);
        this.assertFunction("JSON_ARRAY_GET('[\"as\", \"fgs\", \"tehgf\"]', 1)", "fgs");
        this.assertFunction("JSON_ARRAY_GET('[\"as\", \"fgs\", \"tehgf\", \"gjyj\", \"jut\"]', 4)", "jut");
        this.assertFunction("JSON_ARRAY_GET(CAST('[\"jhfa\"]' AS JSON), 0)", "jhfa");
        this.assertFunction("JSON_ARRAY_GET(CAST('[\"jhfa\", null]' AS JSON), 1)", null);
        this.assertFunction("JSON_ARRAY_GET(CAST('[\"as\", \"fgs\", \"tehgf\"]' AS JSON), 1)", "fgs");
        this.assertFunction("JSON_ARRAY_GET(CAST('[\"as\", \"fgs\", \"tehgf\", \"gjyj\", \"jut\"]' AS JSON), 4)", "jut");
    }

    @Test
    public void testJsonArrayGetDouble() {
        this.assertFunction("JSON_ARRAY_GET('[3.14]', 0)", Slices.utf8Slice((String)String.valueOf(3.14)));
        this.assertFunction("JSON_ARRAY_GET('[3.14, null]', 1)", null);
        this.assertFunction("JSON_ARRAY_GET('[1.12, 3.54, 2.89]', 1)", Slices.utf8Slice((String)String.valueOf(3.54)));
        this.assertFunction("JSON_ARRAY_GET('[0.58, 9.7, 7.6, 11.2, 5.02]', 4)", Slices.utf8Slice((String)String.valueOf(5.02)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[3.14]' AS JSON), 0)", Slices.utf8Slice((String)String.valueOf(3.14)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[3.14, null]' AS JSON), 1)", null);
        this.assertFunction("JSON_ARRAY_GET(CAST('[1.12, 3.54, 2.89]' AS JSON), 1)", Slices.utf8Slice((String)String.valueOf(3.54)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[0.58, 9.7, 7.6, 11.2, 5.02]' AS JSON), 4)", Slices.utf8Slice((String)String.valueOf(5.02)));
    }

    @Test
    public void testJsonArrayGetBoolean() {
        this.assertFunction("JSON_ARRAY_GET('[true]', 0)", Slices.utf8Slice((String)String.valueOf(true)));
        this.assertFunction("JSON_ARRAY_GET('[true, null]', 1)", null);
        this.assertFunction("JSON_ARRAY_GET('[false, false, true]', 1)", Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET('[true, false, false, true, true, false]', 5)", Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[true]' AS JSON), 0)", Slices.utf8Slice((String)String.valueOf(true)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[true, null]' AS JSON), 1)", null);
        this.assertFunction("JSON_ARRAY_GET(CAST('[false, false, true]' AS JSON), 1)", Slices.utf8Slice((String)String.valueOf(false)));
        this.assertFunction("JSON_ARRAY_GET(CAST('[true, false, false, true, true, false]' AS JSON), 5)", Slices.utf8Slice((String)String.valueOf(false)));
    }

    @Test
    public void testJsonArrayGetNonScalar() {
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}]', 0)", Slices.utf8Slice((String)String.valueOf("{\"hello\":\"world\"}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, [1,2,3]]', 1)", Slices.utf8Slice((String)String.valueOf("[1,2,3]")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, [1,2, {\"x\" : 2} ]]', 1)", Slices.utf8Slice((String)String.valueOf("[1,2,{\"x\":2}]")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, {\"a\":[{\"x\":99}]}]', 1)", Slices.utf8Slice((String)String.valueOf("{\"a\":[{\"x\":99}]}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\":\"world\"}, {\"a\":[{\"x\":99}]}]', -1)", Slices.utf8Slice((String)String.valueOf("{\"a\":[{\"x\":99}]}")));
        this.assertFunction("JSON_ARRAY_GET('[{\"hello\": null}]', 0)", Slices.utf8Slice((String)String.valueOf("{\"hello\":null}")));
    }

    @Test
    public void testJsonArrayContainsInvalid() {
        for (String value : new String[]{"'x'", "2.5", "8", "true", "cast(null as varchar)"}) {
            for (String array : new String[]{"", "123", "[", "[1,0,]", "[1,,0]"}) {
                this.assertFunction(String.format("JSON_ARRAY_CONTAINS('%s', %s)", array, value), null);
            }
        }
    }

    @Test
    public void testInvalidJsonCast() {
        try {
            this.assertFunction("CAST('INVALID' AS JSON)", null);
            Assert.fail();
        }
        catch (PrestoException prestoException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonSize() {
        this.assertFunction(String.format("JSON_SIZE('%s', '%s')", "{\"x\": {\"a\" : 1, \"b\" : 2} }", "$"), 1);
        this.assertFunction(String.format("JSON_SIZE('%s', '%s')", "{\"x\": {\"a\" : 1, \"b\" : 2} }", "$.x"), 2);
        this.assertFunction(String.format("JSON_SIZE('%s', '%s')", "{\"x\": {\"a\" : 1, \"b\" : [1,2,3], \"c\" : {\"w\":9}} }", "$.x"), 3);
        this.assertFunction(String.format("JSON_SIZE('%s', '%s')", "{\"x\": {\"a\" : 1, \"b\" : 2} }", "$.x.a"), 0);
        this.assertFunction(String.format("JSON_SIZE('%s', '%s')", "[1,2,3]", "$"), 3);
        this.assertFunction(String.format("JSON_SIZE(null, '%s')", "$"), null);
        this.assertFunction(String.format("JSON_SIZE('%s', '%s')", "INVALID_JSON", "$"), null);
        this.assertFunction(String.format("JSON_SIZE('%s', null)", "[1,2,3]"), null);
        this.assertFunction(String.format("JSON_SIZE(CAST('%s' AS JSON), '%s')", "{\"x\": {\"a\" : 1, \"b\" : 2} }", "$"), 1);
        this.assertFunction(String.format("JSON_SIZE(CAST('%s' AS JSON), '%s')", "{\"x\": {\"a\" : 1, \"b\" : 2} }", "$.x"), 2);
        this.assertFunction(String.format("JSON_SIZE(CAST('%s' AS JSON), '%s')", "{\"x\": {\"a\" : 1, \"b\" : [1,2,3], \"c\" : {\"w\":9}} }", "$.x"), 3);
        this.assertFunction(String.format("JSON_SIZE(CAST('%s' AS JSON), '%s')", "{\"x\": {\"a\" : 1, \"b\" : 2} }", "$.x.a"), 0);
        this.assertFunction(String.format("JSON_SIZE(CAST('%s' AS JSON), '%s')", "[1,2,3]", "$"), 3);
        this.assertFunction(String.format("JSON_SIZE(null, '%s')", "$"), null);
        this.assertFunction(String.format("JSON_SIZE(CAST('%s' AS JSON), null)", "[1,2,3]"), null);
    }

    @Test
    public void testJsonEquality() {
        this.assertFunction("CAST('[1,2,3]' AS JSON) = CAST('[1,2,3]' AS JSON)", true);
        this.assertFunction("CAST('{\"a\":1, \"b\":2}' AS JSON) = CAST('{\"b\":2, \"a\":1}' AS JSON)", true);
        this.assertFunction("CAST('{\"a\":1, \"b\":2}' AS JSON) = CAST(MAP(ARRAY['b','a'], ARRAY[2,1]) AS JSON)", true);
        this.assertFunction("CAST('null' AS JSON) = CAST('null' AS JSON)", true);
        this.assertFunction("CAST('true' AS JSON) = CAST('true' AS JSON)", true);
        this.assertFunction("CAST('{\"x\":\"y\"}' AS JSON) = CAST('{\"x\":\"y\"}' AS JSON)", true);
        this.assertFunction("CAST('[1,2,3]' AS JSON) = CAST('[2,3,1]' AS JSON)", false);
        this.assertFunction("CAST('{\"p_1\": 1, \"p_2\":\"v_2\", \"p_3\":null, \"p_4\":true, \"p_5\": {\"p_1\":1}}' AS JSON) = CAST('{\"p_2\":\"v_2\", \"p_4\":true, \"p_1\": 1, \"p_3\":null, \"p_5\": {\"p_1\":1}}' AS JSON)", true);
        this.assertFunction("CAST('[1,2,3]' AS JSON) != CAST('[1,2,3]' AS JSON)", false);
        this.assertFunction("CAST('{\"a\":1, \"b\":2}' AS JSON) != CAST('{\"b\":2, \"a\":1}' AS JSON)", false);
        this.assertFunction("CAST('null' AS JSON) != CAST('null' AS JSON)", false);
        this.assertFunction("CAST('true' AS JSON) != CAST('true' AS JSON)", false);
        this.assertFunction("CAST('{\"x\":\"y\"}' AS JSON) != CAST('{\"x\":\"y\"}' AS JSON)", false);
        this.assertFunction("CAST('[1,2,3]' AS JSON) != CAST('[2,3,1]' AS JSON)", true);
        this.assertFunction("CAST('{\"p_1\": 1, \"p_2\":\"v_2\", \"p_3\":null, \"p_4\":true, \"p_5\": {\"p_1\":1}}' AS JSON) != CAST('{\"p_2\":\"v_2\", \"p_4\":true, \"p_1\": 1, \"p_3\":null, \"p_5\": {\"p_1\":1}}' AS JSON)", false);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }
}

