/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestUrlFunctions {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testUrlExtract() {
        this.validateUrlExtract("http://example.com/path1/p.php?k1=v1&k2=v2#Ref1", "http", "example.com", null, "/path1/p.php", "k1=v1&k2=v2", "Ref1");
        this.validateUrlExtract("http://example.com/path1/p.php?", "http", "example.com", null, "/path1/p.php", "", "");
        this.validateUrlExtract("http://example.com/path1/p.php", "http", "example.com", null, "/path1/p.php", "", "");
        this.validateUrlExtract("http://example.com:8080/path1/p.php?k1=v1&k2=v2#Ref1", "http", "example.com", 8080L, "/path1/p.php", "k1=v1&k2=v2", "Ref1");
        this.validateUrlExtract("https://username@example.com", "https", "example.com", null, "", "", "");
        this.validateUrlExtract("https://username:password@example.com", "https", "example.com", null, "", "", "");
        this.validateUrlExtract("mailto:test@example.com", "mailto", "", null, "", "", "");
        this.validateUrlExtract("foo", "", "", null, "foo", "", "");
        this.validateUrlExtract("http://example.com/^", null, null, null, null, null, null);
    }

    @Test
    public void testUrlExtractParameter() {
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k1')", "v1");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k2')", "v2");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k3')", "");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k4')", "");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k5')", null);
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k1=v2&k1&k1#Ref1', 'k1')", "v1");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k1&k1=v1&k1&k1#Ref1', 'k1')", "");
        this.assertFunction("url_extract_parameter('http://example.com/path1/p.php?k=a=b=c&x=y#Ref1', 'k')", "a=b=c");
        this.assertFunction("url_extract_parameter('foo', 'k1')", null);
    }

    private void validateUrlExtract(String url, String protocol, String host, Long port, String path, String query, String fragment) {
        this.assertFunction("url_extract_protocol('" + url + "')", protocol);
        this.assertFunction("url_extract_host('" + url + "')", host);
        if (port == null) {
            this.assertFunctionNull("url_extract_port('" + url + "')");
        } else {
            this.assertFunction("url_extract_port('" + url + "')", port);
        }
        this.assertFunction("url_extract_path('" + url + "')", path);
        this.assertFunction("url_extract_query('" + url + "')", query);
        this.assertFunction("url_extract_fragment('" + url + "')", fragment);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private void assertFunctionNull(String projection) {
        this.functionAssertions.assertFunctionNull(projection);
    }
}

