/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVarbinaryFunctions {
    private static final byte[] ALL_BYTES = new byte[256];
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLength() throws Exception {
        this.assertFunction("length(CAST('' AS VARBINARY))", 0);
        this.assertFunction("length(CAST('a' AS VARBINARY))", 1);
        this.assertFunction("length(CAST('abc' AS VARBINARY))", 3);
    }

    @Test
    public void testToBase64() throws Exception {
        this.assertFunction("to_base64(CAST('' AS VARBINARY))", TestVarbinaryFunctions.encodeBase64(""));
        this.assertFunction("to_base64(CAST('a' AS VARBINARY))", TestVarbinaryFunctions.encodeBase64("a"));
        this.assertFunction("to_base64(CAST('abc' AS VARBINARY))", TestVarbinaryFunctions.encodeBase64("abc"));
        this.assertFunction("to_base64(CAST('hello world' AS VARBINARY))", "aGVsbG8gd29ybGQ=");
    }

    @Test
    public void testFromBase64() throws Exception {
        this.assertFunction("from_base64(to_base64(CAST('' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary(""));
        this.assertFunction("from_base64(to_base64(CAST('a' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary("a"));
        this.assertFunction("from_base64(to_base64(CAST('abc' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary("abc"));
        this.assertFunction("from_base64(CAST(to_base64(CAST('' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary(""));
        this.assertFunction("from_base64(CAST(to_base64(CAST('a' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary("a"));
        this.assertFunction("from_base64(CAST(to_base64(CAST('abc' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary("abc"));
        this.assertFunction(String.format("to_base64(from_base64('%s'))", BaseEncoding.base64().encode(ALL_BYTES)), BaseEncoding.base64().encode(ALL_BYTES));
    }

    @Test
    public void testToBase64Url() throws Exception {
        this.assertFunction("to_base64url(CAST('' AS VARBINARY))", TestVarbinaryFunctions.encodeBase64Url(""));
        this.assertFunction("to_base64url(CAST('a' AS VARBINARY))", TestVarbinaryFunctions.encodeBase64Url("a"));
        this.assertFunction("to_base64url(CAST('abc' AS VARBINARY))", TestVarbinaryFunctions.encodeBase64Url("abc"));
        this.assertFunction("to_base64url(CAST('hello world' AS VARBINARY))", "aGVsbG8gd29ybGQ=");
    }

    @Test
    public void testFromBase64Url() throws Exception {
        this.assertFunction("from_base64url(to_base64url(CAST('' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary(""));
        this.assertFunction("from_base64url(to_base64url(CAST('a' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary("a"));
        this.assertFunction("from_base64url(to_base64url(CAST('abc' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary("abc"));
        this.assertFunction("from_base64url(CAST(to_base64url(CAST('' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary(""));
        this.assertFunction("from_base64url(CAST(to_base64url(CAST('a' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary("a"));
        this.assertFunction("from_base64url(CAST(to_base64url(CAST('abc' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary("abc"));
        this.assertFunction(String.format("to_base64url(from_base64url('%s'))", BaseEncoding.base64Url().encode(ALL_BYTES)), BaseEncoding.base64Url().encode(ALL_BYTES));
    }

    @Test
    public void testToHex() throws Exception {
        this.assertFunction("to_hex(CAST('' AS VARBINARY))", TestVarbinaryFunctions.encodeHex(""));
        this.assertFunction("to_hex(CAST('a' AS VARBINARY))", TestVarbinaryFunctions.encodeHex("a"));
        this.assertFunction("to_hex(CAST('abc' AS VARBINARY))", TestVarbinaryFunctions.encodeHex("abc"));
        this.assertFunction("to_hex(CAST('hello world' AS VARBINARY))", "68656C6C6F20776F726C64");
    }

    @Test
    public void testFromHex() throws Exception {
        this.assertFunction("from_hex(to_hex(CAST('' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary(""));
        this.assertFunction("from_hex(to_hex(CAST('a' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary("a"));
        this.assertFunction("from_hex(to_hex(CAST('abc' AS VARBINARY)))", TestVarbinaryFunctions.sqlVarbinary("abc"));
        this.assertFunction("from_hex(CAST(to_hex(CAST('' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary(""));
        this.assertFunction("from_hex(CAST(to_hex(CAST('a' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary("a"));
        this.assertFunction("from_hex(CAST(to_hex(CAST('abc' AS VARBINARY)) AS VARBINARY))", TestVarbinaryFunctions.sqlVarbinary("abc"));
        this.assertFunction(String.format("to_hex(from_hex('%s'))", BaseEncoding.base16().encode(ALL_BYTES)), BaseEncoding.base16().encode(ALL_BYTES));
    }

    private static String encodeBase64(String value) {
        return BaseEncoding.base64().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase64Url(String value) {
        return BaseEncoding.base64Url().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeHex(String value) {
        return BaseEncoding.base16().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    private static SqlVarbinary sqlVarbinary(String value) {
        return new SqlVarbinary(value.getBytes(StandardCharsets.UTF_8));
    }

    static {
        for (int i = 0; i < ALL_BYTES.length; ++i) {
            TestVarbinaryFunctions.ALL_BYTES[i] = (byte)i;
        }
    }
}

