/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.window.WindowAssertions;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.base.Preconditions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.AfterClass;

public abstract class AbstractTestWindowFunction {
    protected final LocalQueryRunner queryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);

    protected AbstractTestWindowFunction() {
    }

    @AfterClass
    public void tearDown() {
        this.queryRunner.close();
    }

    protected void assertWindowQuery(@Language(value="SQL") String sql, MaterializedResult expected) {
        WindowAssertions.assertWindowQuery(sql, expected, this.queryRunner);
    }

    protected void assertUnboundedWindowQuery(@Language(value="SQL") String sql, MaterializedResult expected) {
        this.assertWindowQuery(AbstractTestWindowFunction.unbounded(sql), expected);
    }

    protected void assertWindowQueryWithNulls(@Language(value="SQL") String sql, MaterializedResult expected) {
        WindowAssertions.assertWindowQueryWithNulls(sql, expected, this.queryRunner);
    }

    protected void assertUnboundedWindowQueryWithNulls(@Language(value="SQL") String sql, MaterializedResult expected) {
        this.assertWindowQueryWithNulls(AbstractTestWindowFunction.unbounded(sql), expected);
    }

    @Language(value="SQL")
    private static String unbounded(@Language(value="SQL") String sql) {
        Preconditions.checkArgument((boolean)sql.endsWith(")"), (Object)"SQL does not end with ')'");
        return sql.substring(0, sql.length() - 1) + " ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING)";
    }
}

