/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.window.AbstractTestWindowFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import org.testng.annotations.Test;

public class TestAggregateWindowFunction
extends AbstractTestWindowFunction {
    @Test
    public void testCountRowsOrdered() {
        this.assertWindowQuery("count(*) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 2}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 4}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 3}).row(new Object[]{7, "O", 4}).row(new Object[]{32, "O", 5}).row(new Object[]{34, "O", 6}).build());
        this.assertWindowQueryWithNulls("count(*) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 2}).row(new Object[]{null, "F", 4}).row(new Object[]{null, "F", 4}).row(new Object[]{34, "O", 1}).row(new Object[]{null, "O", 2}).row(new Object[]{1, null, 1}).row(new Object[]{7, null, 2}).row(new Object[]{null, null, 4}).row(new Object[]{null, null, 4}).build());
    }

    @Test
    public void testCountRowsUnordered() {
        this.assertWindowQuery("count(*) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 4}).row(new Object[]{5, "F", 4}).row(new Object[]{6, "F", 4}).row(new Object[]{33, "F", 4}).row(new Object[]{1, "O", 6}).row(new Object[]{2, "O", 6}).row(new Object[]{4, "O", 6}).row(new Object[]{7, "O", 6}).row(new Object[]{32, "O", 6}).row(new Object[]{34, "O", 6}).build());
        this.assertWindowQueryWithNulls("count(*) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 4}).row(new Object[]{5, "F", 4}).row(new Object[]{null, "F", 4}).row(new Object[]{null, "F", 4}).row(new Object[]{34, "O", 2}).row(new Object[]{null, "O", 2}).row(new Object[]{1, null, 4}).row(new Object[]{7, null, 4}).row(new Object[]{null, null, 4}).row(new Object[]{null, null, 4}).build());
    }

    @Test
    public void testCountValuesOrdered() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 2}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 4}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 3}).row(new Object[]{7, "O", 4}).row(new Object[]{32, "O", 5}).row(new Object[]{34, "O", 6}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 2}).row(new Object[]{null, "F", 2}).row(new Object[]{null, "F", 2}).row(new Object[]{34, "O", 1}).row(new Object[]{null, "O", 1}).row(new Object[]{1, null, 1}).row(new Object[]{7, null, 2}).row(new Object[]{null, null, 2}).row(new Object[]{null, null, 2}).build());
    }

    @Test
    public void testCountValuesUnordered() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 4}).row(new Object[]{5, "F", 4}).row(new Object[]{6, "F", 4}).row(new Object[]{33, "F", 4}).row(new Object[]{1, "O", 6}).row(new Object[]{2, "O", 6}).row(new Object[]{4, "O", 6}).row(new Object[]{7, "O", 6}).row(new Object[]{32, "O", 6}).row(new Object[]{34, "O", 6}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 2}).row(new Object[]{5, "F", 2}).row(new Object[]{null, "F", 2}).row(new Object[]{null, "F", 2}).row(new Object[]{34, "O", 1}).row(new Object[]{null, "O", 1}).row(new Object[]{1, null, 2}).row(new Object[]{7, null, 2}).row(new Object[]{null, null, 2}).row(new Object[]{null, null, 2}).build());
    }

    @Test
    public void testSumOrdered() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 8}).row(new Object[]{6, "F", 14}).row(new Object[]{33, "F", 47}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 3}).row(new Object[]{4, "O", 7}).row(new Object[]{7, "O", 14}).row(new Object[]{32, "O", 46}).row(new Object[]{34, "O", 80}).build();
        MaterializedResult expectedNulls = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 8}).row(new Object[]{null, "F", 8}).row(new Object[]{null, "F", 8}).row(new Object[]{34, "O", 34}).row(new Object[]{null, "O", 34}).row(new Object[]{1, null, 1}).row(new Object[]{7, null, 8}).row(new Object[]{null, null, 8}).row(new Object[]{null, null, 8}).build();
        String sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE UNBOUNDED PRECEDING)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS UNBOUNDED PRECEDING)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
    }

    @Test
    public void testSumRolling() {
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS 2 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 8}).row(new Object[]{6, "F", 14}).row(new Object[]{33, "F", 44}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 3}).row(new Object[]{4, "O", 7}).row(new Object[]{7, "O", 13}).row(new Object[]{32, "O", 43}).row(new Object[]{34, "O", 73}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 PRECEDING AND 2 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 8}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", 1}).row(new Object[]{7, "O", 3}).row(new Object[]{32, "O", 7}).row(new Object[]{34, "O", 13}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 3 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47}).row(new Object[]{5, "F", 47}).row(new Object[]{6, "F", 47}).row(new Object[]{33, "F", 44}).row(new Object[]{1, "O", 14}).row(new Object[]{2, "O", 46}).row(new Object[]{4, "O", 80}).row(new Object[]{7, "O", 79}).row(new Object[]{32, "O", 77}).row(new Object[]{34, "O", 73}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 14}).row(new Object[]{5, "F", 44}).row(new Object[]{6, "F", 39}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 7}).row(new Object[]{2, "O", 13}).row(new Object[]{4, "O", 43}).row(new Object[]{7, "O", 73}).row(new Object[]{32, "O", 66}).row(new Object[]{34, "O", 34}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 FOLLOWING AND 4 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 39}).row(new Object[]{5, "F", 33}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", 43}).row(new Object[]{2, "O", 73}).row(new Object[]{4, "O", 66}).row(new Object[]{7, "O", 34}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47}).row(new Object[]{5, "F", 44}).row(new Object[]{6, "F", 39}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 80}).row(new Object[]{2, "O", 79}).row(new Object[]{4, "O", 77}).row(new Object[]{7, "O", 73}).row(new Object[]{32, "O", 66}).row(new Object[]{34, "O", 34}).build());
    }

    @Test
    public void testSumCurrentRow() throws Exception {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 5}).row(new Object[]{6, "F", 6}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 4}).row(new Object[]{7, "O", 7}).row(new Object[]{32, "O", 32}).row(new Object[]{34, "O", 34}).build();
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS CURRENT ROW)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND CURRENT ROW)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE CURRENT ROW)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE BETWEEN CURRENT ROW AND CURRENT ROW)", expected);
    }

    @Test
    public void testSumEmptyWindow() throws Exception {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build();
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 3 PRECEDING)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 FOLLOWING AND 3 FOLLOWING)", expected);
    }

    @Test
    public void testSumUnordered() {
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47}).row(new Object[]{5, "F", 47}).row(new Object[]{6, "F", 47}).row(new Object[]{33, "F", 47}).row(new Object[]{1, "O", 80}).row(new Object[]{2, "O", 80}).row(new Object[]{4, "O", 80}).row(new Object[]{7, "O", 80}).row(new Object[]{32, "O", 80}).row(new Object[]{34, "O", 80}).build());
        this.assertWindowQueryWithNulls("sum(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 8}).row(new Object[]{5, "F", 8}).row(new Object[]{null, "F", 8}).row(new Object[]{null, "F", 8}).row(new Object[]{34, "O", 34}).row(new Object[]{null, "O", 34}).row(new Object[]{1, null, 8}).row(new Object[]{7, null, 8}).row(new Object[]{null, null, 8}).row(new Object[]{null, null, 8}).build());
    }

    @Test
    public void testSumAllNulls() {
        this.assertWindowQueryWithNulls("sum(orderkey) OVER (PARTITION BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, null, 1}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 5}).row(new Object[]{7, null, 7}).row(new Object[]{34, "O", 34}).row(new Object[]{null, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{null, "O", null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }
}

