/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.SystemTablesMetadata;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TestingMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAnalyzer {
    public static final Session SESSION = Session.builder().setUser("user").setSource("test").setCatalog("default").setSchema("default").setTimeZoneKey(TimeZoneKey.UTC_KEY).setLocale(Locale.ENGLISH).build();
    private static final SqlParser SQL_PARSER = new SqlParser();
    private Analyzer analyzer;
    private Analyzer approximateDisabledAnalyzer;

    @Test
    public void testDuplicateRelation() throws Exception {
        this.assertFails(SemanticErrorCode.DUPLICATE_RELATION, "SELECT * FROM t1 JOIN t1 USING (a)");
        this.assertFails(SemanticErrorCode.DUPLICATE_RELATION, "SELECT * FROM t1 x JOIN t2 x USING (a)");
    }

    @Test
    public void testNonComparableGroupBy() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM (SELECT approx_set(1)) GROUP BY 1");
    }

    @Test
    public void testNonComparableWindowPartition() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT row_number() OVER (PARTITION BY t.x) FROM (VALUES(null)) AS t(x)");
    }

    @Test
    public void testNonComparableWindowOrder() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT row_number() OVER (ORDER BY t.x) FROM (VALUES(null)) AS t(x)");
    }

    @Test
    public void testNonComparableDistinctAggregation() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT count(DISTINCT x) FROM (SELECT approx_set(1) x)");
    }

    @Test
    public void testNonComparableDistinct() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT DISTINCT * FROM (SELECT approx_set(1) x)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT DISTINCT x FROM (SELECT approx_set(1) x)");
    }

    @Test
    public void testInSubqueryTypes() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM (VALUES ('a')) t(y) WHERE y IN (VALUES (1))");
    }

    @Test
    public void testScalarSubQueryException() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT 'a', (VALUES (1)) GROUP BY 1");
    }

    @Test
    public void testHavingReferencesOutputAlias() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT sum(a) x FROM t1 HAVING x > 5");
    }

    @Test
    public void testWildcardWithInvalidPrefix() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_TABLE, "SELECT foo.* FROM t1");
    }

    @Test
    public void testGroupByWithWildcard() throws Exception {
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT * FROM t1 GROUP BY 1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT u1.*, u2.* FROM (select a, b + 1 from t1) u1 JOIN (select a, b + 2 from t1) u2 USING (a) GROUP BY u1.a, u2.a, 3");
    }

    @Test
    public void testGroupByInvalidOrdinal() throws Exception {
        this.assertFails(SemanticErrorCode.INVALID_ORDINAL, "SELECT * FROM t1 GROUP BY 10");
        this.assertFails(SemanticErrorCode.INVALID_ORDINAL, "SELECT * FROM t1 GROUP BY 0");
    }

    @Test
    public void testOrderByInvalidOrdinal() throws Exception {
        this.assertFails(SemanticErrorCode.INVALID_ORDINAL, "SELECT * FROM t1 ORDER BY 10");
        this.assertFails(SemanticErrorCode.INVALID_ORDINAL, "SELECT * FROM t1 ORDER BY 0");
    }

    @Test
    public void testOrderByNonComparable() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT x FROM (SELECT approx_set(1) x) ORDER BY 1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM (SELECT approx_set(1) x) ORDER BY 1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT x FROM (SELECT approx_set(1) x) ORDER BY x");
    }

    @Test
    public void testNestedAggregation() throws Exception {
        this.assertFails(SemanticErrorCode.NESTED_AGGREGATION, "SELECT sum(count(*)) FROM t1");
    }

    @Test
    public void testAggregationsNotAllowed() throws Exception {
        this.assertFails(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, "SELECT * FROM t1 WHERE sum(a) > 1");
        this.assertFails(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, "SELECT * FROM t1 GROUP BY sum(a)");
        this.assertFails(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, "SELECT * FROM t1 JOIN t2 ON sum(t1.a) = t2.a");
    }

    @Test
    public void testWindowsNotAllowed() throws Exception {
        this.assertFails(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, "SELECT * FROM t1 WHERE foo() over () > 1");
        this.assertFails(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, "SELECT * FROM t1 GROUP BY rank() over ()");
        this.assertFails(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, "SELECT * FROM t1 JOIN t2 ON sum(t1.a) over () = t2.a");
    }

    @Test
    public void testInvalidTable() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_CATALOG, "SELECT * FROM foo.default.t");
        this.assertFails(SemanticErrorCode.MISSING_SCHEMA, "SELECT * FROM foo.t");
        this.assertFails(SemanticErrorCode.MISSING_TABLE, "SELECT * FROM foo");
    }

    @Test
    public void testNonAggregate() throws Exception {
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT 'a', array[b][1] FROM t1 GROUP BY 1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT a, sum(b) FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT sum(b) / a FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT sum(b) / a FROM t1 GROUP BY c");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT sum(b) FROM t1 ORDER BY a + 1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT a, sum(b) FROM t1 GROUP BY a HAVING c > 5");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT count(*) over (PARTITION BY a) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT count(*) over (ORDER BY a) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT count(*) over (ORDER BY count(*) ROWS a PRECEDING) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT count(*) over (ORDER BY count(*) ROWS BETWEEN b PRECEDING AND a PRECEDING) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT count(*) over (ORDER BY count(*) ROWS BETWEEN a PRECEDING AND UNBOUNDED PRECEDING) FROM t1 GROUP BY b");
    }

    @Test
    public void testInvalidAttribute() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT f FROM t1");
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT * FROM t1 ORDER BY f");
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT count(*) FROM t1 GROUP BY f");
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT * FROM t1 WHERE f > 1");
    }

    @Test
    public void testOrderByMustAppearInSelectWithDistinct() throws Exception {
        this.assertFails(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, "SELECT DISTINCT a FROM t1 ORDER BY b");
    }

    @Test
    public void testNonBooleanWhereClause() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM t1 WHERE a");
    }

    @Test
    public void testApproximateNotEnabled() throws Exception {
        block2: {
            try {
                Statement statement = SQL_PARSER.createStatement("SELECT AVG(a) FROM t1 APPROXIMATE AT 99.0 CONFIDENCE");
                this.approximateDisabledAnalyzer.analyze(statement);
                Assert.fail((String)String.format("Expected error %s, but analysis succeeded", SemanticErrorCode.NOT_SUPPORTED));
            }
            catch (SemanticException e) {
                if (e.getCode() == SemanticErrorCode.NOT_SUPPORTED) break block2;
                Assert.fail((String)String.format("Expected error %s, but found %s: %s", SemanticErrorCode.NOT_SUPPORTED, e.getCode(), e.getMessage()), (Throwable)e);
            }
        }
    }

    @Test
    public void testApproximateQuery() throws Exception {
        this.analyze("SELECT AVG(a) FROM t1 APPROXIMATE AT 99.0 CONFIDENCE");
    }

    @Test
    public void testDistinctAggregations() throws Exception {
        this.analyze("SELECT COUNT(DISTINCT a), SUM(a) FROM t1");
    }

    @Test
    public void testMultipleDistinctAggregations() throws Exception {
        this.analyze("SELECT COUNT(DISTINCT a), COUNT(DISTINCT b) FROM t1");
    }

    @Test
    public void testOrderByExpressionOnOutputColumn() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT a x FROM t1 ORDER BY x + 1");
    }

    @Test
    public void testOrderByExpressionOnOutputColumn2() throws Exception {
        this.analyze("SELECT a x FROM t1 ORDER BY a + 1");
    }

    @Test
    public void testOrderByWithWildcard() throws Exception {
        this.analyze("SELECT a, t1.* FROM t1 ORDER BY a");
    }

    @Test
    public void testMismatchedColumnAliasCount() throws Exception {
        this.assertFails(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, "SELECT * FROM t1 u (x, y)");
    }

    @Test
    public void testJoinOnConstantExpression() throws Exception {
        this.analyze("SELECT * FROM t1 JOIN t2 ON 1 = 1");
    }

    @Test
    public void testJoinOnNonBooleanExpression() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM t1 JOIN t2 ON 5");
    }

    @Test
    public void testJoinOnAmbiguousName() throws Exception {
        this.assertFails(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, "SELECT * FROM t1 JOIN t2 ON a = a");
    }

    @Test
    public void testNonEquiJoin() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT * FROM t1 JOIN t2 ON t1.a + t2.a = 1");
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT * FROM t1 JOIN t2 ON t1.a = t2.a OR t1.b = t2.b");
    }

    @Test
    public void testNonBooleanHaving() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT sum(a) FROM t1 HAVING sum(a)");
    }

    @Test
    public void testAmbiguousReferenceInOrderBy() throws Exception {
        this.assertFails(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, "SELECT a x, b x FROM t1 ORDER BY x");
    }

    @Test
    public void testImplicitCrossJoin() {
        this.analyze("SELECT * FROM t1, t2");
    }

    @Test
    public void testNaturalJoinNotSupported() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT * FROM t1 NATURAL JOIN t2");
    }

    @Test
    public void testNestedWindowFunctions() throws Exception {
        this.assertFails(SemanticErrorCode.NESTED_WINDOW, "SELECT avg(sum(a) OVER ()) FROM t1");
        this.assertFails(SemanticErrorCode.NESTED_WINDOW, "SELECT sum(sum(a) OVER ()) OVER () FROM t1");
        this.assertFails(SemanticErrorCode.NESTED_WINDOW, "SELECT avg(a) OVER (PARTITION BY sum(b) OVER ()) FROM t1");
        this.assertFails(SemanticErrorCode.NESTED_WINDOW, "SELECT avg(a) OVER (ORDER BY sum(b) OVER ()) FROM t1");
    }

    @Test
    public void testWindowFunctionWithoutOverClause() {
        this.assertFails(SemanticErrorCode.WINDOW_REQUIRES_OVER, "SELECT row_number()");
    }

    @Test
    public void testInvalidWindowFrame() throws Exception {
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS UNBOUNDED FOLLOWING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS 2 FOLLOWING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS BETWEEN UNBOUNDED FOLLOWING AND CURRENT ROW)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND 5 PRECEDING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS BETWEEN 2 FOLLOWING AND 5 PRECEDING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (ROWS BETWEEN 2 FOLLOWING AND CURRENT ROW)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (RANGE 2 PRECEDING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (RANGE BETWEEN 2 PRECEDING AND CURRENT ROW)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (RANGE BETWEEN CURRENT ROW AND 5 FOLLOWING)");
        this.assertFails(SemanticErrorCode.INVALID_WINDOW_FRAME, "SELECT rank() OVER (RANGE BETWEEN 2 PRECEDING AND 5 FOLLOWING)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT rank() OVER (ROWS 0.5 PRECEDING)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT rank() OVER (ROWS 'foo' PRECEDING)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND 0.5 FOLLOWING)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND 'foo' FOLLOWING)");
    }

    @Test
    public void testDistinctInWindowFunctionParameter() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT a, count(DISTINCT b) OVER () FROM t1");
    }

    @Test
    public void testGroupByOrdinalsWithWildcard() throws Exception {
        this.analyze("SELECT t1.*, a FROM t1 GROUP BY 1,2,c,d");
    }

    @Test
    public void testGroupByWithQualifiedName() throws Exception {
        this.analyze("SELECT a FROM t1 GROUP BY t1.a");
    }

    @Test
    public void testGroupByWithQualifiedName2() throws Exception {
        this.analyze("SELECT t1.a FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupByWithQualifiedName3() throws Exception {
        this.analyze("SELECT * FROM t1 GROUP BY t1.a, t1.b, t1.c, t1.d");
    }

    @Test
    public void testHaving() throws Exception {
        this.analyze("SELECT sum(a) FROM t1 HAVING avg(a) - avg(b) > 10");
    }

    @Test
    public void testWithCaseInsensitiveResolution() throws Exception {
        this.analyze("WITH AB AS (SELECT * FROM t1) SELECT * FROM ab");
    }

    @Test
    public void testDuplicateWithQuery() throws Exception {
        this.assertFails(SemanticErrorCode.DUPLICATE_RELATION, "WITH a AS (SELECT * FROM t1),     a AS (SELECT * FROM t1)SELECT * FROM a");
    }

    @Test
    public void testCaseInsensitiveDuplicateWithQuery() throws Exception {
        this.assertFails(SemanticErrorCode.DUPLICATE_RELATION, "WITH a AS (SELECT * FROM t1),     A AS (SELECT * FROM t1)SELECT * FROM a");
    }

    @Test
    public void testWithForwardReference() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_TABLE, "WITH a AS (SELECT * FROM b),     b AS (SELECT * FROM t1)SELECT * FROM a");
    }

    @Test
    public void testExpressions() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT NOT 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 AND TRUE FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT TRUE AND 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 OR TRUE FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT TRUE OR 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 = 'a' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT NULLIF(1, 'a') FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT CASE WHEN TRUE THEN 'a' ELSE 1 END FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT CASE WHEN '1' THEN 1 ELSE 2 END FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT CASE 1 WHEN 'a' THEN 2 END FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT CASE 1 WHEN 1 THEN 2 ELSE 'a' END FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT COALESCE(1, 'a') FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT CAST(date '2014-01-01' AS bigint)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT TRY_CAST(date '2014-01-01' AS bigint)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT CAST(null AS UNKNOWN)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT -'a' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT +'a' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 'a' + 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 + 'a'  FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 'a' - 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 - 'a' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 LIKE 'a' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 'a' LIKE 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 'a' LIKE 'b' ESCAPE 1 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT EXTRACT(DAY FROM 'a') FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 BETWEEN 'a' AND 2 FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 BETWEEN 0 AND 'b' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 BETWEEN 'a' AND 'b' FROM t1");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM t1 WHERE 1 IN ('a')");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM t1 WHERE 'a' IN (1)");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT * FROM t1 WHERE 'a' IN (1, 'b')");
    }

    @Test(enabled=false)
    public void testInWithNumericTypes() throws Exception {
        this.analyze("SELECT * FROM t1 WHERE 1 IN (1, 2, 3.5)");
    }

    @Test
    public void testWildcardWithoutFrom() throws Exception {
        this.assertFails(SemanticErrorCode.WILDCARD_WITHOUT_FROM, "SELECT *");
    }

    @Test
    public void testReferenceWithoutFrom() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "SELECT dummy");
    }

    @Test
    public void testGroupBy() throws Exception {
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY a");
    }

    @Test
    public void testAggregateWithWildcard() throws Exception {
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT * FROM (SELECT a + 1, b FROM t1) t GROUP BY b ORDER BY 1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT * FROM (SELECT a, b FROM t1) t GROUP BY b ORDER BY 1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT * FROM (SELECT a, b FROM t1) GROUP BY b ORDER BY 1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT * FROM (SELECT a + 1, b FROM t1) GROUP BY b ORDER BY 1");
    }

    @Test
    public void testGroupByCase() throws Exception {
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT CASE a WHEN 1 THEN 'a' ELSE 'b' END, count(*) FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT CASE 1 WHEN 2 THEN a ELSE 0 END, count(*) FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT CASE 1 WHEN 2 THEN 0 ELSE a END, count(*) FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT CASE WHEN a = 1 THEN 'a' ELSE 'b' END, count(*) FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT CASE WHEN true THEN a ELSE 0 END, count(*) FROM t1");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT CASE WHEN true THEN 0 ELSE a END, count(*) FROM t1");
    }

    @Test
    public void testMismatchedUnionQueries() throws Exception {
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT 1 UNION SELECT 'a'");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "SELECT a FROM t1 UNION SELECT 'a'");
        this.assertFails(SemanticErrorCode.TYPE_MISMATCH, "(SELECT 1) UNION SELECT 'a'");
        this.assertFails(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, "SELECT 1, 2 UNION SELECT 1");
        this.assertFails(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, "SELECT 'a' UNION SELECT 'b', 'c'");
        this.assertFails(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, "TABLE t2 UNION SELECT 'a'");
    }

    @Test
    public void testUnionUnmatchedOrderByAttribute() throws Exception {
        this.assertFails(SemanticErrorCode.MISSING_ATTRIBUTE, "TABLE t2 UNION ALL SELECT c, d FROM t1 ORDER BY c");
    }

    @Test
    public void testGroupByComplexExpressions() throws Exception {
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT IF(a IS NULL, 1, 0) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT IF(a IS NOT NULL, 1, 0) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT IF(CAST(a AS VARCHAR) LIKE 'a', 1, 0) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT a IN (1, 2, 3) FROM t1 GROUP BY b");
        this.assertFails(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, "SELECT 1 IN (a, 2, 3) FROM t1 GROUP BY b");
    }

    @Test
    public void testNonNumericTableSamplePercentage() throws Exception {
        this.assertFails(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, "SELECT * FROM t1 TABLESAMPLE BERNOULLI ('a')");
        this.assertFails(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, "SELECT * FROM t1 TABLESAMPLE BERNOULLI (a + 1)");
    }

    @Test
    public void testTableSampleOutOfRange() throws Exception {
        this.assertFails(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, "SELECT * FROM t1 TABLESAMPLE BERNOULLI (-1)");
        this.assertFails(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, "SELECT * FROM t1 TABLESAMPLE BERNOULLI (-101)");
    }

    @Test
    public void testCreateViewColumns() throws Exception {
        this.assertFails(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, "CREATE VIEW test AS SELECT 123");
        this.assertFails(SemanticErrorCode.DUPLICATE_COLUMN_NAME, "CREATE VIEW test AS SELECT 1 a, 2 a");
    }

    @Test
    public void testStaleView() throws Exception {
        this.assertFails(SemanticErrorCode.VIEW_IS_STALE, "SELECT * FROM v2");
    }

    @Test
    public void testStoredViewAnalysisScoping() throws Exception {
        this.analyze("WITH t1 AS (SELECT 123 x) SELECT * FROM v1");
    }

    @Test
    public void testStoredViewResolution() throws Exception {
        this.analyze("SELECT * FROM c3.s3.v3");
    }

    @Test
    public void testUse() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "USE default");
    }

    @Test
    public void testNotNullInJoinClause() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT * FROM (VALUES (1)) a (x) JOIN (VALUES (2)) b ON a.x IS NOT NULL");
    }

    @Test
    public void testIfInJoinClause() throws Exception {
        this.assertFails(SemanticErrorCode.NOT_SUPPORTED, "SELECT * FROM (VALUES (1)) a (x) JOIN (VALUES (2)) b ON IF(a.x = 1, true, false)");
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        MetadataManager metadata = new MetadataManager(new FeaturesConfig().setExperimentalSyntaxEnabled(true), (TypeManager)new TypeRegistry(), new SystemTablesMetadata());
        metadata.addConnectorMetadata("tpch", "tpch", (ConnectorMetadata)new TestingMetadata());
        metadata.addConnectorMetadata("c2", "c2", (ConnectorMetadata)new TestingMetadata());
        metadata.addConnectorMetadata("c3", "c3", (ConnectorMetadata)new TestingMetadata());
        SchemaTableName table1 = new SchemaTableName("default", "t1");
        metadata.createTable(SESSION, "tpch", new TableMetadata("tpch", new ConnectorTableMetadata(table1, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT, 0, false), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT, 1, false), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT, 2, false), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT, 3, false)))));
        SchemaTableName table2 = new SchemaTableName("default", "t2");
        metadata.createTable(SESSION, "tpch", new TableMetadata("tpch", new ConnectorTableMetadata(table2, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT, 0, false), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT, 1, false)))));
        SchemaTableName table3 = new SchemaTableName("default", "t3");
        metadata.createTable(SESSION, "tpch", new TableMetadata("tpch", new ConnectorTableMetadata(table3, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT, 0, false), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT, 1, false)))));
        SchemaTableName table4 = new SchemaTableName("s2", "t4");
        metadata.createTable(SESSION, "c2", new TableMetadata("tpch", new ConnectorTableMetadata(table4, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT, 0, false)))));
        String viewData1 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select a from t1", "tpch", "default", (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)BigintType.BIGINT))));
        metadata.createView(SESSION, new QualifiedTableName("tpch", "default", "v1"), viewData1, false);
        String viewData2 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select a from t1", "tpch", "default", (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)VarcharType.VARCHAR))));
        metadata.createView(SESSION, new QualifiedTableName("tpch", "default", "v2"), viewData2, false);
        String viewData3 = JsonCodec.jsonCodec(ViewDefinition.class).toJson((Object)new ViewDefinition("select a from t4", "c2", "s2", (List)ImmutableList.of((Object)new ViewDefinition.ViewColumn("a", (Type)BigintType.BIGINT))));
        metadata.createView(SESSION, new QualifiedTableName("c3", "s3", "v3"), viewData3, false);
        this.analyzer = new Analyzer(Session.builder().setUser("user").setSource("test").setCatalog("tpch").setSchema("default").setTimeZoneKey(TimeZoneKey.UTC_KEY).setLocale(Locale.ENGLISH).build(), (Metadata)metadata, SQL_PARSER, Optional.empty(), true);
        this.approximateDisabledAnalyzer = new Analyzer(Session.builder().setUser("user").setSource("test").setCatalog("tpch").setSchema("default").setTimeZoneKey(TimeZoneKey.UTC_KEY).setLocale(Locale.ENGLISH).build(), (Metadata)metadata, SQL_PARSER, Optional.empty(), false);
    }

    private void analyze(@Language(value="SQL") String query) {
        Statement statement = SQL_PARSER.createStatement(query);
        this.analyzer.analyze(statement);
    }

    private void assertFails(SemanticErrorCode error, @Language(value="SQL") String query) {
        block2: {
            try {
                Statement statement = SQL_PARSER.createStatement(query);
                this.analyzer.analyze(statement);
                Assert.fail((String)String.format("Expected error %s, but analysis succeeded", error));
            }
            catch (SemanticException e) {
                if (e.getCode() == error) break block2;
                Assert.fail((String)String.format("Expected error %s, but found %s: %s", error, e.getCode(), e.getMessage()), (Throwable)e);
            }
        }
    }
}

