/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.SimplePagesHashStrategy;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestJoinCompiler {
    private static final JoinCompiler joinCompiler = new JoinCompiler();

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testSingleChannel(boolean hashEnabled) throws Exception {
        ImmutableList joinTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        List joinChannels = Ints.asList((int[])new int[]{0});
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)joinTypes, joinChannels);
        ImmutableList channel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        Optional<Object> hashChannel = Optional.empty();
        ImmutableList channels = ImmutableList.of((Object)channel);
        if (hashEnabled) {
            ImmutableList.Builder hashChannelBuilder = ImmutableList.builder();
            for (Block block : channel) {
                hashChannelBuilder.add((Object)TypeUtils.getHashBlock((List)joinTypes, (Block[])new Block[]{block}));
            }
            hashChannel = Optional.of(1);
            channels = ImmutableList.of((Object)channel, (Object)hashChannelBuilder.build());
        }
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels, hashChannel);
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)1);
        for (int leftBlockIndex = 0; leftBlockIndex < channel.size(); ++leftBlockIndex) {
            Block leftBlock = (Block)channel.get(leftBlockIndex);
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
            for (int leftBlockPosition = 0; leftBlockPosition < leftBlock.getPositionCount(); ++leftBlockPosition) {
                Assert.assertEquals((int)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (int)TypeUtils.hashPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (int rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                    Block rightBlock = (Block)channel.get(rightBlockIndex);
                    for (int rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)TypeUtils.positionEqualsPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition, (Block)rightBlock, (int)rightBlockPosition));
                    }
                }
                for (Block rightBlock : channel) {
                    for (int position = 0; position < rightBlock.getPositionCount(); ++position) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, position, new Block[]{rightBlock}), (boolean)TypeUtils.positionEqualsPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition, (Block)rightBlock, (int)position));
                    }
                }
                pageBuilder.declarePosition();
                hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
            }
            BlockAssertions.assertBlockEquals((Type)VarcharType.VARCHAR, pageBuilder.build().getBlock(0), leftBlock);
        }
    }

    @Test(dataProvider="hashEnabledValues")
    public void testMultiChannel(boolean hashEnabled) throws Exception {
        JoinCompiler joinCompiler = new JoinCompiler();
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN);
        ImmutableList joinTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN);
        List joinChannels = Ints.asList((int[])new int[]{1, 2, 3, 4});
        ImmutableList extraChannel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        ImmutableList varcharChannel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        ImmutableList longChannel = ImmutableList.of((Object)BlockAssertions.createLongSequenceBlock(10, 20), (Object)BlockAssertions.createLongSequenceBlock(20, 30), (Object)BlockAssertions.createLongSequenceBlock(15, 25));
        ImmutableList doubleChannel = ImmutableList.of((Object)BlockAssertions.createDoubleSequenceBlock(10, 20), (Object)BlockAssertions.createDoubleSequenceBlock(20, 30), (Object)BlockAssertions.createDoubleSequenceBlock(15, 25));
        ImmutableList booleanChannel = ImmutableList.of((Object)BlockAssertions.createBooleanSequenceBlock(10, 20), (Object)BlockAssertions.createBooleanSequenceBlock(20, 30), (Object)BlockAssertions.createBooleanSequenceBlock(15, 25));
        Optional<Object> hashChannel = Optional.empty();
        ImmutableList channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel);
        ImmutableList precomputedHash = ImmutableList.of();
        if (hashEnabled) {
            ImmutableList.Builder hashChannelBuilder = ImmutableList.builder();
            for (int i = 0; i < 3; ++i) {
                hashChannelBuilder.add((Object)TypeUtils.getHashBlock((List)joinTypes, (Block[])new Block[]{(Block)varcharChannel.get(i), (Block)longChannel.get(i), (Block)doubleChannel.get(i), (Block)booleanChannel.get(i)}));
            }
            hashChannel = Optional.of(5);
            precomputedHash = hashChannelBuilder.build();
            channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel, (Object)precomputedHash);
            types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT);
        }
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)types, joinChannels);
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels, hashChannel);
        SimplePagesHashStrategy expectedHashStrategy = new SimplePagesHashStrategy((List)types, (List)channels, joinChannels, hashChannel);
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)types.size());
        for (int leftBlockIndex = 0; leftBlockIndex < varcharChannel.size(); ++leftBlockIndex) {
            PageBuilder pageBuilder = new PageBuilder((List)types);
            int leftPositionCount = ((Block)varcharChannel.get(leftBlockIndex)).getPositionCount();
            for (int leftBlockPosition = 0; leftBlockPosition < leftPositionCount; ++leftBlockPosition) {
                int rightBlockIndex;
                Assert.assertEquals((int)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (int)expectedHashStrategy.hashPosition(leftBlockIndex, leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                    Block rightBlock = (Block)varcharChannel.get(rightBlockIndex);
                    for (int rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                    }
                }
                for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                    Block[] rightBlocks = new Block[]{(Block)varcharChannel.get(rightBlockIndex), (Block)longChannel.get(rightBlockIndex), (Block)doubleChannel.get(rightBlockIndex), (Block)booleanChannel.get(rightBlockIndex)};
                    int rightPositionCount = ((Block)varcharChannel.get(rightBlockIndex)).getPositionCount();
                    for (int rightPosition = 0; rightPosition < rightPositionCount; ++rightPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, rightBlocks), (boolean)expectedHashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, rightBlocks));
                    }
                }
                pageBuilder.declarePosition();
                hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
            }
            Page page = pageBuilder.build();
            if (hashEnabled) {
                PageAssertions.assertPageEquals((List<? extends Type>)types, page, new Page(new Block[]{(Block)extraChannel.get(leftBlockIndex), (Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex), (Block)precomputedHash.get(leftBlockIndex)}));
                continue;
            }
            PageAssertions.assertPageEquals((List<? extends Type>)types, page, new Page(new Block[]{(Block)extraChannel.get(leftBlockIndex), (Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex)}));
        }
    }
}

