/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.InterpretedFilterFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInterpretedFilterFunction {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = new MetadataManager();

    @Test
    public void testNullLiteral() {
        TestInterpretedFilterFunction.assertFilter("null", false);
    }

    @Test
    public void testBooleanLiteral() {
        TestInterpretedFilterFunction.assertFilter("true", true);
        TestInterpretedFilterFunction.assertFilter("false", false);
    }

    @Test
    public void testNotExpression() {
        TestInterpretedFilterFunction.assertFilter("not true", false);
        TestInterpretedFilterFunction.assertFilter("not false", true);
        TestInterpretedFilterFunction.assertFilter("not null", false);
    }

    @Test
    public void testAndExpression() {
        TestInterpretedFilterFunction.assertFilter("true and true", true);
        TestInterpretedFilterFunction.assertFilter("true and false", false);
        TestInterpretedFilterFunction.assertFilter("true and null", false);
        TestInterpretedFilterFunction.assertFilter("false and true", false);
        TestInterpretedFilterFunction.assertFilter("false and false", false);
        TestInterpretedFilterFunction.assertFilter("false and null", false);
        TestInterpretedFilterFunction.assertFilter("null and true", false);
        TestInterpretedFilterFunction.assertFilter("null and false", false);
        TestInterpretedFilterFunction.assertFilter("null and null", false);
    }

    @Test
    public void testORExpression() {
        TestInterpretedFilterFunction.assertFilter("true or true", true);
        TestInterpretedFilterFunction.assertFilter("true or false", true);
        TestInterpretedFilterFunction.assertFilter("true or null", true);
        TestInterpretedFilterFunction.assertFilter("false or true", true);
        TestInterpretedFilterFunction.assertFilter("false or false", false);
        TestInterpretedFilterFunction.assertFilter("false or null", false);
        TestInterpretedFilterFunction.assertFilter("null or true", true);
        TestInterpretedFilterFunction.assertFilter("null or false", false);
        TestInterpretedFilterFunction.assertFilter("null or null", false);
    }

    @Test
    public void testIsNullExpression() {
        TestInterpretedFilterFunction.assertFilter("null is null", true);
        TestInterpretedFilterFunction.assertFilter("42 is null", false);
    }

    @Test
    public void testIsNotNullExpression() {
        TestInterpretedFilterFunction.assertFilter("42 is not null", true);
        TestInterpretedFilterFunction.assertFilter("null is not null", false);
    }

    @Test
    public void testComparisonExpression() {
        TestInterpretedFilterFunction.assertFilter("42 = 42", true);
        TestInterpretedFilterFunction.assertFilter("42 = 42.0", true);
        TestInterpretedFilterFunction.assertFilter("42.42 = 42.42", true);
        TestInterpretedFilterFunction.assertFilter("'foo' = 'foo'", true);
        TestInterpretedFilterFunction.assertFilter("42 = 87", false);
        TestInterpretedFilterFunction.assertFilter("42 = 22.2", false);
        TestInterpretedFilterFunction.assertFilter("42.42 = 22.2", false);
        TestInterpretedFilterFunction.assertFilter("'foo' = 'bar'", false);
        TestInterpretedFilterFunction.assertFilter("42 != 87", true);
        TestInterpretedFilterFunction.assertFilter("42 != 22.2", true);
        TestInterpretedFilterFunction.assertFilter("42.42 != 22.22", true);
        TestInterpretedFilterFunction.assertFilter("'foo' != 'bar'", true);
        TestInterpretedFilterFunction.assertFilter("42 != 42", false);
        TestInterpretedFilterFunction.assertFilter("42 != 42.0", false);
        TestInterpretedFilterFunction.assertFilter("42.42 != 42.42", false);
        TestInterpretedFilterFunction.assertFilter("'foo' != 'foo'", false);
        TestInterpretedFilterFunction.assertFilter("42 < 88", true);
        TestInterpretedFilterFunction.assertFilter("42 < 88.8", true);
        TestInterpretedFilterFunction.assertFilter("42.42 < 88.8", true);
        TestInterpretedFilterFunction.assertFilter("'bar' < 'foo'", true);
        TestInterpretedFilterFunction.assertFilter("88 < 42", false);
        TestInterpretedFilterFunction.assertFilter("88 < 42.42", false);
        TestInterpretedFilterFunction.assertFilter("88.8 < 42.42", false);
        TestInterpretedFilterFunction.assertFilter("'foo' < 'bar'", false);
        TestInterpretedFilterFunction.assertFilter("42 <= 88", true);
        TestInterpretedFilterFunction.assertFilter("42 <= 88.8", true);
        TestInterpretedFilterFunction.assertFilter("42.42 <= 88.8", true);
        TestInterpretedFilterFunction.assertFilter("'bar' <= 'foo'", true);
        TestInterpretedFilterFunction.assertFilter("42 <= 42", true);
        TestInterpretedFilterFunction.assertFilter("42 <= 42.0", true);
        TestInterpretedFilterFunction.assertFilter("42.42 <= 42.42", true);
        TestInterpretedFilterFunction.assertFilter("'foo' <= 'foo'", true);
        TestInterpretedFilterFunction.assertFilter("88 <= 42", false);
        TestInterpretedFilterFunction.assertFilter("88 <= 42.42", false);
        TestInterpretedFilterFunction.assertFilter("88.8 <= 42.42", false);
        TestInterpretedFilterFunction.assertFilter("'foo' <= 'bar'", false);
        TestInterpretedFilterFunction.assertFilter("88 >= 42", true);
        TestInterpretedFilterFunction.assertFilter("88.8 >= 42.0", true);
        TestInterpretedFilterFunction.assertFilter("88.8 >= 42.42", true);
        TestInterpretedFilterFunction.assertFilter("'foo' >= 'bar'", true);
        TestInterpretedFilterFunction.assertFilter("42 >= 88", false);
        TestInterpretedFilterFunction.assertFilter("42.42 >= 88.0", false);
        TestInterpretedFilterFunction.assertFilter("42.42 >= 88.88", false);
        TestInterpretedFilterFunction.assertFilter("'bar' >= 'foo'", false);
        TestInterpretedFilterFunction.assertFilter("88 >= 42", true);
        TestInterpretedFilterFunction.assertFilter("88.8 >= 42.0", true);
        TestInterpretedFilterFunction.assertFilter("88.8 >= 42.42", true);
        TestInterpretedFilterFunction.assertFilter("'foo' >= 'bar'", true);
        TestInterpretedFilterFunction.assertFilter("42 >= 42", true);
        TestInterpretedFilterFunction.assertFilter("42 >= 42.0", true);
        TestInterpretedFilterFunction.assertFilter("42.42 >= 42.42", true);
        TestInterpretedFilterFunction.assertFilter("'foo' >= 'foo'", true);
        TestInterpretedFilterFunction.assertFilter("42 >= 88", false);
        TestInterpretedFilterFunction.assertFilter("42.42 >= 88.0", false);
        TestInterpretedFilterFunction.assertFilter("42.42 >= 88.88", false);
        TestInterpretedFilterFunction.assertFilter("'bar' >= 'foo'", false);
    }

    @Test
    public void testComparisonExpressionWithNulls() {
        for (ComparisonExpression.Type type : ComparisonExpression.Type.values()) {
            if (type == ComparisonExpression.Type.IS_DISTINCT_FROM) continue;
            TestInterpretedFilterFunction.assertFilter(String.format("NULL %s NULL", type.getValue()), false);
            TestInterpretedFilterFunction.assertFilter(String.format("42 %s NULL", type.getValue()), false);
            TestInterpretedFilterFunction.assertFilter(String.format("NULL %s 42", type.getValue()), false);
            TestInterpretedFilterFunction.assertFilter(String.format("11.1 %s NULL", type.getValue()), false);
            TestInterpretedFilterFunction.assertFilter(String.format("NULL %s 11.1", type.getValue()), false);
        }
    }

    public static void assertFilter(String expression, boolean expectedValue) {
        Expression parsed = FunctionAssertions.createExpression(expression, METADATA, (Map<Symbol, Type>)ImmutableMap.of());
        InterpretedFilterFunction filterFunction = new InterpretedFilterFunction(parsed, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), METADATA, SQL_PARSER, SessionTestUtils.TEST_SESSION);
        boolean result = filterFunction.filter(0, new Block[0]);
        Assert.assertEquals((boolean)result, (boolean)expectedValue);
    }
}

