/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestType {
    public static final ConnectorSession SESSION = new ConnectorSession("user", TimeZoneKey.UTC_KEY, Locale.ENGLISH, System.currentTimeMillis(), null);
    private final Class<?> objectValueType;
    private final Block testBlock;
    private final Type type;
    private final SortedMap<Integer, Object> expectedStackValues;
    private final SortedMap<Integer, Object> expectedObjectValues;
    private final Block testBlockWithNulls;

    protected AbstractTestType(Type type, Class<?> objectValueType, Block testBlock) {
        this(type, objectValueType, testBlock, testBlock);
    }

    protected AbstractTestType(Type type, Class<?> objectValueType, Block testBlock, Block expectedValues) {
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.objectValueType = (Class)Preconditions.checkNotNull(objectValueType, (Object)"objectValueType is null");
        this.testBlock = (Block)Preconditions.checkNotNull((Object)testBlock, (Object)"testBlock is null");
        Preconditions.checkNotNull((Object)expectedValues, (Object)"expectedValues is null");
        this.expectedStackValues = AbstractTestType.indexStackValues(type, expectedValues);
        this.expectedObjectValues = AbstractTestType.indexObjectValues(type, expectedValues);
        this.testBlockWithNulls = this.createAlternatingNullsBlock(testBlock);
    }

    private Block createAlternatingNullsBlock(Block testBlock) {
        BlockBuilder nullsBlockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
        for (int position = 0; position < testBlock.getPositionCount(); ++position) {
            if (this.type.getJavaType() == Void.TYPE) {
                nullsBlockBuilder.appendNull();
            } else if (this.type.getJavaType() == Boolean.TYPE) {
                this.type.writeBoolean(nullsBlockBuilder, this.type.getBoolean(testBlock, position));
            } else if (this.type.getJavaType() == Long.TYPE) {
                this.type.writeLong(nullsBlockBuilder, this.type.getLong(testBlock, position));
            } else if (this.type.getJavaType() == Double.TYPE) {
                this.type.writeDouble(nullsBlockBuilder, this.type.getDouble(testBlock, position));
            } else if (this.type.getJavaType() == Slice.class) {
                Slice slice = this.type.getSlice(testBlock, position);
                this.type.writeSlice(nullsBlockBuilder, slice, 0, slice.length());
            } else {
                throw new RuntimeException("Unsupported Java type " + this.type.getJavaType());
            }
            nullsBlockBuilder.appendNull();
        }
        return nullsBlockBuilder.build();
    }

    @Test
    public void testBlock() {
        for (Map.Entry<Integer, Object> entry : this.expectedStackValues.entrySet()) {
            this.assertPositionEquals(this.testBlock, entry.getKey(), entry.getValue(), this.expectedObjectValues.get(entry.getKey()));
        }
        for (Map.Entry<Integer, Object> entry : this.expectedStackValues.entrySet()) {
            this.assertPositionEquals(this.testBlockWithNulls, entry.getKey() * 2, entry.getValue(), this.expectedObjectValues.get(entry.getKey()));
            this.assertPositionEquals(this.testBlockWithNulls, entry.getKey() * 2 + 1, null, null);
        }
    }

    protected void assertPositionEquals(Block block, int position, Object expectedStackValue, Object expectedObjectValue) {
        int hash = 0;
        if (this.type.isComparable()) {
            hash = TypeUtils.hashPosition((Type)this.type, (Block)block, (int)position);
        }
        this.assertPositionValue(block, position, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getSingleValueBlock(position), 0, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(position, 1), 0, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(0, position + 1), position, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedStackValue, hash, expectedObjectValue);
        BlockBuilder blockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
        this.type.appendTo(block, position, blockBuilder);
        this.assertPositionValue(blockBuilder.build(), 0, expectedStackValue, hash, expectedObjectValue);
    }

    private void assertPositionValue(Block block, int position, Object expectedStackValue, int expectedHash, Object expectedObjectValue) {
        Object objectValue = this.type.getObjectValue(SESSION, block, position);
        Assert.assertEquals((Object)objectValue, (Object)expectedObjectValue);
        if (objectValue != null) {
            Assertions.assertInstanceOf((Object)objectValue, this.objectValueType);
        }
        if (this.type.isComparable()) {
            Assert.assertEquals((int)TypeUtils.hashPosition((Type)this.type, (Block)block, (int)position), (int)expectedHash);
        } else {
            try {
                this.type.hash(block, position);
                Assert.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
        }
        Block expectedBlock = AbstractTestType.createBlock(this.type, expectedStackValue);
        if (this.type.isComparable()) {
            Assert.assertTrue((boolean)TypeUtils.positionEqualsPosition((Type)this.type, (Block)block, (int)position, (Block)block, (int)position));
            Assert.assertTrue((boolean)TypeUtils.positionEqualsPosition((Type)this.type, (Block)block, (int)position, (Block)expectedBlock, (int)0));
            Assert.assertTrue((boolean)TypeUtils.positionEqualsPosition((Type)this.type, (Block)expectedBlock, (int)0, (Block)block, (int)position));
        }
        Assert.assertEquals((boolean)block.isNull(position), (expectedStackValue == null ? 1 : 0) != 0);
        if (this.type.isOrderable()) {
            Assert.assertTrue((SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.ASC_NULLS_LAST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.DESC_NULLS_FIRST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.DESC_NULLS_LAST.compareBlockValue(this.type, block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
        } else {
            try {
                this.type.compareTo(block, position, expectedBlock, 0);
                Assert.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
        }
        this.verifyInvalidPositionHandling(block);
        if (block.isNull(position)) {
            if (this.type.isOrderable()) {
                Block nonNullValue = this.toBlock(this.getNonNullValue());
                Assert.assertTrue((SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, position, nonNullValue, 0) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((SortOrder.ASC_NULLS_LAST.compareBlockValue(this.type, block, position, nonNullValue, 0) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((SortOrder.DESC_NULLS_FIRST.compareBlockValue(this.type, block, position, nonNullValue, 0) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((SortOrder.DESC_NULLS_LAST.compareBlockValue(this.type, block, position, nonNullValue, 0) > 0 ? 1 : 0) != 0);
            }
            return;
        }
        if (this.type.isOrderable() && expectedStackValue != Boolean.TRUE) {
            Block greaterValue = this.toBlock(this.getGreaterValue(expectedStackValue));
            Assert.assertTrue((SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, position, greaterValue, 0) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.ASC_NULLS_LAST.compareBlockValue(this.type, block, position, greaterValue, 0) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.DESC_NULLS_FIRST.compareBlockValue(this.type, block, position, greaterValue, 0) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((SortOrder.DESC_NULLS_LAST.compareBlockValue(this.type, block, position, greaterValue, 0) > 0 ? 1 : 0) != 0);
        }
        if (this.type.getJavaType() == Boolean.TYPE) {
            Assert.assertEquals((Object)this.type.getBoolean(block, position), (Object)expectedStackValue);
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {}
        } else if (this.type.getJavaType() == Long.TYPE) {
            Assert.assertEquals((Object)this.type.getLong(block, position), (Object)expectedStackValue);
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {}
        } else if (this.type.getJavaType() == Double.TYPE) {
            Assert.assertEquals((Object)this.type.getDouble(block, position), (Object)expectedStackValue);
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {
                // empty catch block
            }
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {}
        } else if (this.type.getJavaType() == Slice.class) {
            Assert.assertEquals((Object)this.type.getSlice(block, position), (Object)expectedStackValue);
            try {
                this.type.getBoolean(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {
                // empty catch block
            }
            try {
                this.type.getLong(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, position);
                Assert.fail((String)"Expected IllegalStateException or UnsupportedOperationException");
            }
            catch (IllegalStateException | UnsupportedOperationException expected) {
                // empty catch block
            }
        }
    }

    private void verifyInvalidPositionHandling(Block block) {
        Block other;
        try {
            this.type.getObjectValue(SESSION, block, -1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        try {
            this.type.getObjectValue(SESSION, block, block.getPositionCount());
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        try {
            this.type.hash(block, -1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        try {
            this.type.hash(block, block.getPositionCount());
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        if (this.type.isComparable()) {
            other = this.toBlock(this.getNonNullValue());
            try {
                this.type.equalTo(block, -1, other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
            try {
                this.type.equalTo(block, block.getPositionCount(), other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
        }
        if (this.type.isOrderable()) {
            other = this.toBlock(this.getNonNullValue());
            try {
                SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, -1, other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
            try {
                SortOrder.ASC_NULLS_FIRST.compareBlockValue(this.type, block, block.getPositionCount(), other, 0);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.type.getJavaType() == Boolean.TYPE) {
            try {
                this.type.getBoolean(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
            try {
                this.type.getBoolean(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {}
        } else if (this.type.getJavaType() == Long.TYPE) {
            try {
                this.type.getLong(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
            try {
                this.type.getLong(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {}
        } else if (this.type.getJavaType() == Double.TYPE) {
            try {
                this.type.getDouble(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
            try {
                this.type.getDouble(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {}
        } else if (this.type.getJavaType() == Slice.class) {
            try {
                this.type.getSlice(block, -1);
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
            try {
                this.type.getSlice(block, block.getPositionCount());
                Assert.fail((String)"expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private static Block createBlock(Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        Class javaType = type.getJavaType();
        if (value == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            throw new UnsupportedOperationException("not yet implemented: " + javaType);
        }
        return blockBuilder.build();
    }

    protected abstract Object getGreaterValue(Object var1);

    protected Object getNonNullValue() {
        if (this.type.getJavaType() == Boolean.TYPE) {
            return true;
        }
        if (this.type.getJavaType() == Long.TYPE) {
            return 1L;
        }
        if (this.type.getJavaType() == Double.TYPE) {
            return 1.0;
        }
        if (this.type.getJavaType() == Slice.class) {
            return Slices.utf8Slice((String)"_");
        }
        throw new IllegalStateException("Unsupported Java type " + this.type.getJavaType());
    }

    private Block toBlock(Object value) {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
        Class javaType = this.type.getJavaType();
        if (value == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            this.type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            this.type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            this.type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            this.type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            throw new UnsupportedOperationException("not yet implemented: " + javaType);
        }
        return blockBuilder.build();
    }

    private static SortedMap<Integer, Object> indexStackValues(Type type, Block block) {
        TreeMap<Integer, Comparable<Boolean>> values = new TreeMap<Integer, Comparable<Boolean>>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                values.put(position, null);
                continue;
            }
            if (type.getJavaType() == Boolean.TYPE) {
                values.put(position, Boolean.valueOf(type.getBoolean(block, position)));
                continue;
            }
            if (type.getJavaType() == Long.TYPE) {
                values.put(position, Long.valueOf(type.getLong(block, position)));
                continue;
            }
            if (type.getJavaType() == Double.TYPE) {
                values.put(position, Double.valueOf(type.getDouble(block, position)));
                continue;
            }
            if (type.getJavaType() == Slice.class) {
                values.put(position, (Comparable<Boolean>)type.getSlice(block, position));
                continue;
            }
            throw new RuntimeException("Unsupported value type " + type.getJavaType());
        }
        return Collections.unmodifiableSortedMap(values);
    }

    private static SortedMap<Integer, Object> indexObjectValues(Type type, Block block) {
        TreeMap<Integer, Object> values = new TreeMap<Integer, Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.put(position, type.getObjectValue(SESSION, block, position));
        }
        return Collections.unmodifiableSortedMap(values);
    }
}

