/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBigintOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("37", 37);
        this.assertFunction("17", 17);
    }

    @Test
    public void testAdd() throws Exception {
        this.assertFunction("37 + 37", 74L);
        this.assertFunction("37 + 17", 54L);
        this.assertFunction("17 + 37", 54L);
        this.assertFunction("17 + 17", 34L);
    }

    @Test
    public void testSubtract() throws Exception {
        this.assertFunction("37 - 37", 0L);
        this.assertFunction("37 - 17", 20L);
        this.assertFunction("17 - 37", -20L);
        this.assertFunction("17 - 17", 0L);
    }

    @Test
    public void testMultiply() throws Exception {
        this.assertFunction("37 * 37", 1369L);
        this.assertFunction("37 * 17", 629L);
        this.assertFunction("17 * 37", 629L);
        this.assertFunction("17 * 17", 289L);
    }

    @Test
    public void testDivide() throws Exception {
        this.assertFunction("37 / 37", 1L);
        this.assertFunction("37 / 17", 2L);
        this.assertFunction("17 / 37", 0L);
        this.assertFunction("17 / 17", 1L);
    }

    @Test
    public void testModulus() throws Exception {
        this.assertFunction("37 % 37", 0L);
        this.assertFunction("37 % 17", 3L);
        this.assertFunction("17 % 37", 17L);
        this.assertFunction("17 % 17", 0L);
    }

    @Test
    public void testNegation() throws Exception {
        this.assertFunction("-(37)", -37L);
        this.assertFunction("-(17)", -17L);
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("37 = 37", true);
        this.assertFunction("37 = 17", false);
        this.assertFunction("17 = 37", false);
        this.assertFunction("17 = 17", true);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("37 <> 37", false);
        this.assertFunction("37 <> 17", true);
        this.assertFunction("17 <> 37", true);
        this.assertFunction("17 <> 17", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("37 < 37", false);
        this.assertFunction("37 < 17", false);
        this.assertFunction("17 < 37", true);
        this.assertFunction("17 < 17", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("37 <= 37", true);
        this.assertFunction("37 <= 17", false);
        this.assertFunction("17 <= 37", true);
        this.assertFunction("17 <= 17", true);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("37 > 37", false);
        this.assertFunction("37 > 17", true);
        this.assertFunction("17 > 37", false);
        this.assertFunction("17 > 17", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("37 >= 37", true);
        this.assertFunction("37 >= 17", true);
        this.assertFunction("17 >= 37", false);
        this.assertFunction("17 >= 17", true);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("37 BETWEEN 37 AND 37", true);
        this.assertFunction("37 BETWEEN 37 AND 17", false);
        this.assertFunction("37 BETWEEN 17 AND 37", true);
        this.assertFunction("37 BETWEEN 17 AND 17", false);
        this.assertFunction("17 BETWEEN 37 AND 37", false);
        this.assertFunction("17 BETWEEN 37 AND 17", false);
        this.assertFunction("17 BETWEEN 17 AND 37", true);
        this.assertFunction("17 BETWEEN 17 AND 17", true);
    }

    @Test
    public void testCastToBigint() throws Exception {
        this.assertFunction("cast(37 as bigint)", 37L);
        this.assertFunction("cast(17 as bigint)", 17L);
    }

    @Test
    public void testCastToVarchar() throws Exception {
        this.assertFunction("cast(37 as varchar)", "37");
        this.assertFunction("cast(17 as varchar)", "17");
    }

    @Test
    public void testCastToDouble() throws Exception {
        this.assertFunction("cast(37 as double)", 37.0);
        this.assertFunction("cast(17 as double)", 17.0);
    }

    @Test
    public void testCastToBoolean() throws Exception {
        this.assertFunction("cast(37 as boolean)", true);
        this.assertFunction("cast(17 as boolean)", true);
        this.assertFunction("cast(0 as boolean)", false);
    }

    @Test
    public void testCastFromVarchar() throws Exception {
        this.assertFunction("cast('37' as bigint)", 37L);
        this.assertFunction("cast('17' as bigint)", 17L);
    }
}

