/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.operator.scalar.TestingRowConstructor;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
        this.functionAssertions.getMetadata().getFunctionRegistry().addFunctions(new FunctionListBuilder(this.functionAssertions.getMetadata().getTypeManager()).scalar(TestingRowConstructor.class).getFunctions());
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testRowTypeLookup() throws Exception {
        this.functionAssertions.getMetadata().getType(TypeSignature.parseTypeSignature((String)"row<bigint>('a')"));
        Type type = this.functionAssertions.getMetadata().getType(TypeSignature.parseTypeSignature((String)"row<bigint>('b')"));
        Assert.assertEquals((Collection)type.getTypeSignature().getLiteralParameters(), (Collection)ImmutableList.of((Object)"b"));
    }

    @Test
    public void testRowToJson() throws Exception {
        this.assertFunction("CAST(test_row(1, 2) AS JSON)", "[1,2]");
        this.assertFunction("CAST(test_row(1, CAST(NULL AS BIGINT)) AS JSON)", "[1,null]");
        this.assertFunction("CAST(test_row(1, 2.0) AS JSON)", "[1,2.0]");
        this.assertFunction("CAST(test_row(1.0, 2.5) AS JSON)", "[1.0,2.5]");
        this.assertFunction("CAST(test_row(1.0, 'kittens') AS JSON)", "[1.0,\"kittens\"]");
        this.assertFunction("CAST(test_row(TRUE, FALSE) AS JSON)", "[true,false]");
        this.assertFunction("CAST(test_row(from_unixtime(1)) AS JSON)", "[\"" + new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()).toString() + "\"]");
    }

    @Test
    public void testFieldAccessor() throws Exception {
        String mangledName1 = FunctionRegistry.mangleFieldAccessor((String)"col0");
        String mangledName2 = FunctionRegistry.mangleFieldAccessor((String)"col1");
        this.assertFunction('\"' + mangledName1 + "\"(test_row(1, 2))", 1);
        this.assertFunction('\"' + mangledName2 + "\"(test_row(1, 'kittens'))", "kittens");
    }

    @Test
    public void testRowEquality() throws Exception {
        this.assertFunction("test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10') = test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10')", true);
        this.assertFunction("test_row(1.0, test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10')) =test_row(1.0, test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10'))", true);
        this.assertFunction("test_row(1.0, 'kittens') = test_row(1.0, 'kittens')", true);
        this.assertFunction("test_row(1, 2.0) = test_row(1, 2.0)", true);
        this.assertFunction("test_row(TRUE, FALSE, TRUE, FALSE) = test_row(TRUE, FALSE, TRUE, FALSE)", true);
        this.assertFunction("test_row(TRUE, FALSE, TRUE, FALSE) = test_row(TRUE, TRUE, TRUE, FALSE)", false);
        this.assertFunction("test_row(1, 2.0, TRUE, 'kittens', from_unixtime(1)) = test_row(1, 2.0, TRUE, 'kittens', from_unixtime(1))", true);
        this.assertFunction("test_row(1.0, test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10')) !=test_row(1.0, test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:11'))", true);
        this.assertFunction("test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10') != test_row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:11')", true);
        this.assertFunction("test_row(1.0, 'kittens') != test_row(1.0, 'kittens')", false);
        this.assertFunction("test_row(1, 2.0) != test_row(1, 2.0)", false);
        this.assertFunction("test_row(TRUE, FALSE, TRUE, FALSE) != test_row(TRUE, FALSE, TRUE, FALSE)", false);
        this.assertFunction("test_row(TRUE, FALSE, TRUE, FALSE) != test_row(TRUE, TRUE, TRUE, FALSE)", true);
        this.assertFunction("test_row(1, 2.0, TRUE, 'kittens', from_unixtime(1)) != test_row(1, 2.0, TRUE, 'puppies', from_unixtime(1))", true);
        try {
            this.assertFunction("test_row(cast(cast ('' as varbinary) as hyperloglog)) = test_row(cast(cast ('' as varbinary) as hyperloglog))", true);
            Assert.fail((String)"hyperloglog is not comparable");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.assertFunction("test_row(TRUE, ARRAY [1], MAP(ARRAY[1, 3], ARRAY[2.0, 4.0])) = test_row(TRUE, ARRAY [1,2], MAP(ARRAY[1, 3], ARRAY[2.0, 4.0]))", false);
            Assert.fail((String)"map is not comparable");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.assertFunction("test_row(1, CAST(NULL AS BIGINT)) = test_row(1, 2)", false);
            Assert.fail((String)"ROW comparison not implemented for NULL values");
        }
        catch (PrestoException e) {
            Assert.assertEquals((int)e.getErrorCode().getCode(), (int)StandardErrorCode.NOT_SUPPORTED.toErrorCode().getCode());
        }
        this.assertFunction("test_row(TRUE, ARRAY [1]) = test_row(TRUE, ARRAY [1])", true);
        this.assertFunction("test_row(TRUE, ARRAY [1]) = test_row(TRUE, ARRAY [1,2])", false);
        this.assertFunction("test_row(1.0, ARRAY [1,2,3], test_row(2,2.0)) = test_row(1.0, ARRAY [1,2,3], test_row(2,2.0))", true);
        this.assertFunction("test_row(TRUE, ARRAY [1]) != test_row(TRUE, ARRAY [1])", false);
        this.assertFunction("test_row(TRUE, ARRAY [1]) != test_row(TRUE, ARRAY [1,2])", true);
        this.assertFunction("test_row(1.0, ARRAY [1,2,3], test_row(2,2.0)) != test_row(1.0, ARRAY [1,2,3], test_row(1,2.0))", true);
    }
}

