/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagesIndexPageSorter {
    private static final PagesIndexPageSorter sorter = new PagesIndexPageSorter();

    @Test
    public void testPageSorter() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        ImmutableList sortTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List sortChannels = Ints.asList((int[])new int[]{0});
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2, 1.1, "d").row(1, 2.2, "c").pageBreak().row(-2, 2.2, "b").row(-12, 2.2, "a").build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12, 2.2, "a").row(-2, 2.2, "b").pageBreak().row(1, 2.2, "c").row(2, 1.1, "d").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, (List<Type>)sortTypes, sortChannels, (List<SortOrder>)sortOrders, 100);
    }

    @Test
    public void testPageSorterMultipleChannels() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        ImmutableList sortTypes = ImmutableList.copyOf((Collection)types);
        List sortChannels = Ints.asList((int[])new int[]{0, 1, 2});
        List<SortOrder> sortOrders = Collections.nCopies(sortChannels.size(), SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2, 1.1, "d").row(1, 2.2, "c").pageBreak().row(1, 2.2, "b").row(1, 2.2, "a").pageBreak().row(1, 2.2, null).row(1, null, "z").row(1, null, null).build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1, null, null).row(1, null, "z").row(1, 2.2, null).row(1, 2.2, "a").row(1, 2.2, "b").row(1, 2.2, "c").row(2, 1.1, "d").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, (List<Type>)sortTypes, sortChannels, sortOrders, 100);
    }

    @Test
    public void testPageSorterSorted() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        ImmutableList sortTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List sortChannels = Ints.asList((int[])new int[]{0});
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12, 2.2, "a").row(-2, 2.2, "b").pageBreak().row(1, 2.2, "d").row(2, 1.1, "c").build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12, 2.2, "a").row(-2, 2.2, "b").row(1, 2.2, "d").row(2, 1.1, "c").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, (List<Type>)sortTypes, sortChannels, (List<SortOrder>)sortOrders, 100);
    }

    @Test
    public void testPageSorterForceExpansion() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        ImmutableList sortTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List sortChannels = Ints.asList((int[])new int[]{0});
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2, 1.1, "c").row(1, 2.2, "d").pageBreak().row(-2, 2.2, "b").row(-12, 2.2, "a").build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12, 2.2, "a").row(-2, 2.2, "b").pageBreak().row(1, 2.2, "d").row(2, 1.1, "c").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, (List<Type>)sortTypes, sortChannels, (List<SortOrder>)sortOrders, 2);
    }

    private static void assertSorted(List<Page> inputPages, List<Page> expectedPages, List<Type> types, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, int expectedPositions) {
        long[] sortedAddresses = sorter.sort(types, inputPages, sortTypes, sortChannels, sortOrders, expectedPositions);
        List<Page> outputPages = TestPagesIndexPageSorter.createOutputPages(types, inputPages, sortedAddresses);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, types, expectedPages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, types, outputPages);
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    private static List<Page> createOutputPages(List<Type> types, List<Page> inputPages, long[] sortedAddresses) {
        PageBuilder pageBuilder = new PageBuilder(types);
        pageBuilder.reset();
        for (long address : sortedAddresses) {
            int index = sorter.decodePageIndex(address);
            int position = sorter.decodePositionIndex(address);
            Page page = inputPages.get(index);
            for (int i = 0; i < types.size(); ++i) {
                Type type = types.get(i);
                type.appendTo(page.getBlock(i), position, pageBuilder.getBlockBuilder(i));
            }
            pageBuilder.declarePosition();
        }
        return ImmutableList.of((Object)pageBuilder.build());
    }
}

