/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressionAssertions;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import org.testng.annotations.Test;

public class TestArithmeticByteCodeExpression {
    @Test
    public void testAdd() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.add((ByteCodeExpression)ByteCodeExpressions.constantInt((int)3), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)7)), 10, "(3 + 7)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.add((ByteCodeExpression)ByteCodeExpressions.constantLong((long)3L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)7L)), 10L, "(3L + 7L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.add((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)3.1f), (ByteCodeExpression)ByteCodeExpressions.constantFloat((float)7.5f)), Float.valueOf(10.6f), "(3.1f + 7.5f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.add((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)3.1), (ByteCodeExpression)ByteCodeExpressions.constantDouble((double)7.5)), 10.6, "(3.1 + 7.5)");
    }

    @Test
    public void testSubtract() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.subtract((ByteCodeExpression)ByteCodeExpressions.constantInt((int)3), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)7)), -4, "(3 - 7)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.subtract((ByteCodeExpression)ByteCodeExpressions.constantLong((long)3L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)7L)), -4L, "(3L - 7L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.subtract((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)3.1f), (ByteCodeExpression)ByteCodeExpressions.constantFloat((float)7.5f)), Float.valueOf(-4.4f), "(3.1f - 7.5f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.subtract((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)3.1), (ByteCodeExpression)ByteCodeExpressions.constantDouble((double)7.5)), -4.4, "(3.1 - 7.5)");
    }

    @Test
    public void testMultiply() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.multiply((ByteCodeExpression)ByteCodeExpressions.constantInt((int)3), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)7)), 21, "(3 * 7)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.multiply((ByteCodeExpression)ByteCodeExpressions.constantLong((long)3L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)7L)), 21L, "(3L * 7L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.multiply((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)3.1f), (ByteCodeExpression)ByteCodeExpressions.constantFloat((float)7.5f)), Float.valueOf(23.25f), "(3.1f * 7.5f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.multiply((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)3.1), (ByteCodeExpression)ByteCodeExpressions.constantDouble((double)7.5)), 23.25, "(3.1 * 7.5)");
    }

    @Test
    public void testDivide() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.divide((ByteCodeExpression)ByteCodeExpressions.constantInt((int)7), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), 2, "(7 / 3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.divide((ByteCodeExpression)ByteCodeExpressions.constantLong((long)7L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)3L)), 2L, "(7L / 3L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.divide((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)3.1f), (ByteCodeExpression)ByteCodeExpressions.constantFloat((float)7.5f)), Float.valueOf(0.41333333f), "(3.1f / 7.5f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.divide((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)3.1), (ByteCodeExpression)ByteCodeExpressions.constantDouble((double)7.5)), 0.41333333333333333, "(3.1 / 7.5)");
    }

    @Test
    public void testRemainder() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.remainder((ByteCodeExpression)ByteCodeExpressions.constantInt((int)7), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), 1, "(7 % 3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.remainder((ByteCodeExpression)ByteCodeExpressions.constantLong((long)7L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)3L)), 1L, "(7L % 3L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.remainder((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)3.1f), (ByteCodeExpression)ByteCodeExpressions.constantFloat((float)7.5f)), Float.valueOf(3.1f), "(3.1f % 7.5f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.remainder((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)3.1), (ByteCodeExpression)ByteCodeExpressions.constantDouble((double)7.5)), 3.1, "(3.1 % 7.5)");
    }

    @Test
    public void testShiftLeft() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.shiftLeft((ByteCodeExpression)ByteCodeExpressions.constantInt((int)7), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), 56, "(7 << 3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.shiftLeft((ByteCodeExpression)ByteCodeExpressions.constantLong((long)7L), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), 56L, "(7L << 3)");
    }

    @Test
    public void testShiftRight() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.shiftRight((ByteCodeExpression)ByteCodeExpressions.constantInt((int)-7), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), -1, "(-7 >> 3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.shiftRight((ByteCodeExpression)ByteCodeExpressions.constantLong((long)-7L), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), -1L, "(-7L >> 3)");
    }

    @Test
    public void testShiftRightUnsigned() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.shiftRightUnsigned((ByteCodeExpression)ByteCodeExpressions.constantInt((int)-7), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), 0x1FFFFFFF, "(-7 >>> 3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.shiftRightUnsigned((ByteCodeExpression)ByteCodeExpressions.constantLong((long)-7L), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), 0x1FFFFFFFFFFFFFFFL, "(-7L >>> 3)");
    }

    @Test
    public void testBitwiseAnd() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.bitwiseAnd((ByteCodeExpression)ByteCodeExpressions.constantInt((int)101), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)37)), 37, "(101 & 37)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.bitwiseAnd((ByteCodeExpression)ByteCodeExpressions.constantLong((long)101L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)37L)), 37L, "(101L & 37L)");
    }

    @Test
    public void testBitwiseOr() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.bitwiseOr((ByteCodeExpression)ByteCodeExpressions.constantInt((int)101), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)37)), 101, "(101 | 37)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.bitwiseOr((ByteCodeExpression)ByteCodeExpressions.constantLong((long)101L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)37L)), 101L, "(101L | 37L)");
    }

    @Test
    public void testBitwiseXor() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.bitwiseXor((ByteCodeExpression)ByteCodeExpressions.constantInt((int)101), (ByteCodeExpression)ByteCodeExpressions.constantInt((int)37)), 64, "(101 ^ 37)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.bitwiseXor((ByteCodeExpression)ByteCodeExpressions.constantLong((long)101L), (ByteCodeExpression)ByteCodeExpressions.constantLong((long)37L)), 64L, "(101L ^ 37L)");
    }

    @Test
    public void testNegate() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantInt((int)3)), -3, "-(3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantLong((long)3L)), -3L, "-(3L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)3.1f)), Float.valueOf(-3.1f), "-(3.1f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)3.1)), -3.1, "-(3.1)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantInt((int)-3)), 3, "-(-3)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantLong((long)-3L)), 3L, "-(-3L)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantFloat((float)-3.1f)), Float.valueOf(3.1f), "-(-3.1f)");
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.negate((ByteCodeExpression)ByteCodeExpressions.constantDouble((double)-3.1)), 3.1, "-(-3.1)");
    }
}

