/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressionAssertions;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.sql.gen.Bootstrap;
import java.awt.Point;
import java.lang.reflect.Field;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSetFieldByteCodeExpression {
    public static String testField;

    @Test
    public void testSetField() throws Exception {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        Variable point = context.declareVariable(Point.class, "point");
        TestSetFieldByteCodeExpression.assertSetPoint(context, point.setField("x", ByteCodeExpressions.constantInt((int)42)));
        TestSetFieldByteCodeExpression.assertSetPoint(context, point.setField(Point.class.getField("x"), ByteCodeExpressions.constantInt((int)42)));
    }

    public static void assertSetPoint(CompilerContext context, ByteCodeExpression setX) throws Exception {
        Assert.assertEquals((String)setX.toString(), (String)"point.x = 42;");
        Block block = new Block(context).append((ByteCodeNode)context.getVariable("point").set(ByteCodeExpressions.newInstance(Point.class, (ByteCodeExpression[])new ByteCodeExpression[]{ByteCodeExpressions.constantInt((int)3), ByteCodeExpressions.constantInt((int)7)}))).append((ByteCodeNode)setX).append((ByteCodeNode)context.getVariable("point").ret());
        ByteCodeExpressionAssertions.assertByteCodeNode((ByteCodeNode)block, ParameterizedType.type(Point.class), new Point(42, 7));
    }

    @Test
    public void testSetStaticField() throws Exception {
        this.assertSetStaticField(ByteCodeExpressions.setStatic(this.getClass(), (String)"testField", (ByteCodeExpression)ByteCodeExpressions.constantString((String)"testValue")));
        this.assertSetStaticField(ByteCodeExpressions.setStatic((Field)this.getClass().getField("testField"), (ByteCodeExpression)ByteCodeExpressions.constantString((String)"testValue")));
        this.assertSetStaticField(ByteCodeExpressions.setStatic((ParameterizedType)ParameterizedType.type(this.getClass()), (String)"testField", (ByteCodeExpression)ByteCodeExpressions.constantString((String)"testValue")));
    }

    public void assertSetStaticField(ByteCodeExpression setStaticField) throws Exception {
        testField = "fail";
        ByteCodeExpressionAssertions.assertByteCodeExpression(setStaticField, null, this.getClass().getSimpleName() + ".testField = \"testValue\";");
        Assert.assertEquals((String)testField, (String)"testValue");
    }
}

