/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.PageSplitterUtil;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.testing.Assertions;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageSplitterUtil {
    @Test
    public void testSplitPage() throws Exception {
        int positionCount = 10;
        int maxPageSizeInBytes = 100;
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        Page largePage = SequencePageBuilder.createSequencePage((List<? extends Type>)types, positionCount, 0, 1, 1);
        List pages = PageSplitterUtil.splitPage((Page)largePage, (long)maxPageSizeInBytes);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(pages.size()), (Comparable)Integer.valueOf(1));
        TestPageSplitterUtil.assertPageSize(pages, maxPageSizeInBytes);
        TestPageSplitterUtil.assertPositionCount(pages, positionCount);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, pages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, (List<Page>)ImmutableList.of((Object)largePage));
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    private static void assertPageSize(List<Page> pages, long maxPageSizeInBytes) {
        for (Page page : pages) {
            Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(page.getSizeInBytes()), (Comparable)Long.valueOf(maxPageSizeInBytes));
        }
    }

    private static void assertPositionCount(List<Page> pages, int positionCount) {
        int totalPositionCount = 0;
        for (Page page : pages) {
            totalPositionCount += page.getPositionCount();
        }
        Assert.assertEquals((int)totalPositionCount, (int)positionCount);
    }
}

