/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryManagerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestQueryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((QueryManagerConfig)ConfigAssertions.recordDefaults(QueryManagerConfig.class)).setMaxQueryAge(new Duration(15.0, TimeUnit.MINUTES)).setMaxQueryHistory(100).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setScheduleSplitBatchSize(1000).setMaxConcurrentQueries(1000).setMaxQueuedQueries(5000).setMaxConcurrentBigQueries(10).setMaxQueuedBigQueries(500).setBigQueryInitialHashPartitions(null).setMaxPendingSplitsPerNode(100).setInitialHashPartitions(8).setQueryManagerExecutorPoolSize(5).setRemoteTaskMaxConsecutiveErrorCount(10).setRemoteTaskMinErrorDuration(new Duration(2.0, TimeUnit.MINUTES)).setRemoteTaskMaxCallbackThreads(1000));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.client.timeout", (Object)"10s").put((Object)"query.max-age", (Object)"30s").put((Object)"query.max-history", (Object)"10").put((Object)"query.schedule-split-batch-size", (Object)"99").put((Object)"query.max-concurrent-queries", (Object)"10").put((Object)"query.max-queued-queries", (Object)"15").put((Object)"experimental.max-concurrent-big-queries", (Object)"20").put((Object)"experimental.max-queued-big-queries", (Object)"30").put((Object)"query.max-pending-splits-per-node", (Object)"33").put((Object)"query.initial-hash-partitions", (Object)"16").put((Object)"experimental.big-query-initial-hash-partitions", (Object)"32").put((Object)"query.manager-executor-pool-size", (Object)"11").put((Object)"query.remote-task.max-consecutive-error-count", (Object)"300").put((Object)"query.remote-task.min-error-duration", (Object)"30s").put((Object)"query.remote-task.max-callback-threads", (Object)"10").build();
        QueryManagerConfig expected = new QueryManagerConfig().setMaxQueryAge(new Duration(30.0, TimeUnit.SECONDS)).setMaxQueryHistory(10).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setScheduleSplitBatchSize(99).setMaxConcurrentQueries(10).setMaxQueuedQueries(15).setMaxConcurrentBigQueries(20).setMaxQueuedBigQueries(30).setMaxPendingSplitsPerNode(33).setInitialHashPartitions(16).setBigQueryInitialHashPartitions(Integer.valueOf(32)).setQueryManagerExecutorPoolSize(11).setRemoteTaskMaxConsecutiveErrorCount(300).setRemoteTaskMinErrorDuration(new Duration(30.0, TimeUnit.SECONDS)).setRemoteTaskMaxCallbackThreads(10);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

