/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryStats;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryStats {
    public static final QueryStats EXPECTED = new QueryStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new DateTime(4L), new Duration(5.0, TimeUnit.NANOSECONDS), new Duration(6.0, TimeUnit.NANOSECONDS), new Duration(7.0, TimeUnit.NANOSECONDS), new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(100.0, TimeUnit.NANOSECONDS), 9, 10, 11, 12, 13, 15, 16, new DataSize(17.0, DataSize.Unit.BYTE), new Duration(18.0, TimeUnit.NANOSECONDS), new Duration(19.0, TimeUnit.NANOSECONDS), new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new DataSize(22.0, DataSize.Unit.BYTE), 23L, new DataSize(24.0, DataSize.Unit.BYTE), 25L, new DataSize(26.0, DataSize.Unit.BYTE), 27L);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(QueryStats.class);
        String json = codec.toJson((Object)EXPECTED);
        QueryStats actual = (QueryStats)codec.fromJson(json);
        TestQueryStats.assertExpectedQueryStats(actual);
    }

    public static void assertExpectedQueryStats(QueryStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getExecutionStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastHeartbeat(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(4L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(6.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAnalysisTime(), (Object)new Duration(7.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getDistributedPlanningTime(), (Object)new Duration(8.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalPlanningTime(), (Object)new Duration(100.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((int)actual.getTotalTasks(), (int)9);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)10);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)11);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)12);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)13);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)15);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)16);
        Assert.assertEquals((Object)actual.getTotalMemoryReservation(), (Object)new DataSize(17.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(19.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalUserTime(), (Object)new Duration(20.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(21.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)23L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)25L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(26.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)27L);
    }
}

