/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.TaskSource;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.NodeVersion;
import com.facebook.presto.spi.Page;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.NullEventClient;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlTask {
    public static final TaskId OUT = new TaskId("query", "stage", "out");
    private final TaskExecutor taskExecutor;
    private final ScheduledExecutorService taskNotificationExecutor;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicLong nextTaskId = new AtomicLong();

    public TestSqlTask() {
        this.taskExecutor = new TaskExecutor(8);
        this.taskExecutor.start();
        this.taskNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.threadsNamed((String)"task-notification-%d"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.taskNotificationExecutor, this.taskExecutor, planner, new QueryMonitor(new ObjectMapperProvider().get(), (EventClient)new NullEventClient(), new NodeInfo("test"), new NodeVersion("testVersion")), new TaskManagerConfig());
    }

    @AfterClass
    public void destroy() throws Exception {
        this.taskExecutor.stop();
        this.taskNotificationExecutor.shutdownNow();
    }

    @Test
    public void testEmptyQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withNoMoreBufferIds());
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testSimpleQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds());
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        BufferResult results = (BufferResult)sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE)).get();
        Assert.assertEquals((boolean)results.isBufferClosed(), (boolean)false);
        Assert.assertEquals((int)results.getPages().size(), (int)1);
        Assert.assertEquals((int)((Page)results.getPages().get(0)).getPositionCount(), (int)1);
        results = (BufferResult)sqlTask.getTaskResults(OUT, results.getToken() + (long)results.getPages().size(), new DataSize(1.0, DataSize.Unit.MEGABYTE)).get();
        Assert.assertEquals((boolean)results.isBufferClosed(), (boolean)true);
        Assert.assertEquals((int)results.getPages().size(), (int)0);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getState()).get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testCancel() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.cancel();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.CANCELED);
        Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.CANCELED);
        Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
    }

    @Test
    public void testAbort() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, TaskTestUtils.PLAN_FRAGMENT, (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds());
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.RUNNING);
        sqlTask.abortTaskResults(OUT);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getState()).get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testBufferCloseOnFinish() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        OutputBuffers outputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, outputBuffers);
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        TaskTestUtils.updateTask(sqlTask, (List<TaskSource>)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), outputBuffers);
        Assert.assertEquals((Object)sqlTask.getTaskInfo().getState(), (Object)TaskState.FINISHED);
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get(200L, TimeUnit.MILLISECONDS)).isBufferClosed());
        Assert.assertEquals((Object)sqlTask.getTaskInfo().getOutputBuffers().getState(), (Object)SharedBuffer.BufferState.FINISHED);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertTrue((boolean)bufferResult.isDone());
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferClosed());
    }

    @Test
    public void testBufferCloseOnCancel() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()));
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        sqlTask.cancel();
        Assert.assertEquals((Object)sqlTask.getTaskInfo().getState(), (Object)TaskState.CANCELED);
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get(200L, TimeUnit.MILLISECONDS)).isBufferClosed());
        bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertTrue((boolean)bufferResult.isDone());
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferClosed());
    }

    @Test
    public void testBufferNotCloseOnFail() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()));
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        TaskState taskState = sqlTask.getTaskInfo().getState();
        sqlTask.failed((Throwable)new Exception("test"));
        Assert.assertEquals((Object)((TaskInfo)sqlTask.getTaskInfo(taskState).get(200L, TimeUnit.MILLISECONDS)).getState(), (Object)TaskState.FAILED);
        try {
            Assert.assertTrue((boolean)((BufferResult)bufferResult.get(200L, TimeUnit.MILLISECONDS)).isBufferClosed());
            Assert.fail((String)"expected TimeoutException");
        }
        catch (TimeoutException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE)).isDone());
    }

    public SqlTask createInitialTask() {
        TaskId taskId = new TaskId("query", "stage", "task" + this.nextTaskId.incrementAndGet());
        URI location = URI.create("fake://task/" + taskId);
        return new SqlTask(taskId, location, this.sqlTaskExecutionFactory, (ExecutorService)this.taskNotificationExecutor, Functions.identity(), new DataSize(32.0, DataSize.Unit.MEGABYTE));
    }
}

