/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.TaskManagerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestTaskManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TaskManagerConfig)ConfigAssertions.recordDefaults(TaskManagerConfig.class)).setVerboseStats(false).setTaskCpuTimerEnabled(true).setMaxShardProcessorThreads(Runtime.getRuntime().availableProcessors() * 4).setInfoMaxAge(new Duration(15.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setMaxTaskMemoryUsage(new DataSize(256.0, DataSize.Unit.MEGABYTE)).setBigQueryMaxTaskMemoryUsage(null).setMaxTaskIndexMemoryUsage(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setOperatorPreAllocatedMemory(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setMaxPartialAggregationMemoryUsage(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setSinkMaxBufferSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setWriterCount(1).setHttpNotificationThreads(25));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"task.verbose-stats", (Object)"true").put((Object)"task.cpu-timer-enabled", (Object)"false").put((Object)"task.max-memory", (Object)"2GB").put((Object)"experimental.big-query-max-task-memory", (Object)"4GB").put((Object)"task.max-index-memory", (Object)"512MB").put((Object)"task.operator-pre-allocated-memory", (Object)"2MB").put((Object)"task.max-partial-aggregation-memory", (Object)"32MB").put((Object)"task.shard.max-threads", (Object)"3").put((Object)"task.info.max-age", (Object)"22m").put((Object)"task.client.timeout", (Object)"10s").put((Object)"sink.max-buffer-size", (Object)"42MB").put((Object)"task.writer-count", (Object)"3").put((Object)"task.http-notification-threads", (Object)"4").build();
        TaskManagerConfig expected = new TaskManagerConfig().setVerboseStats(true).setTaskCpuTimerEnabled(false).setMaxTaskMemoryUsage(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setBigQueryMaxTaskMemoryUsage(new DataSize(4.0, DataSize.Unit.GIGABYTE)).setMaxTaskIndexMemoryUsage(new DataSize(512.0, DataSize.Unit.MEGABYTE)).setOperatorPreAllocatedMemory(new DataSize(2.0, DataSize.Unit.MEGABYTE)).setMaxPartialAggregationMemoryUsage(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setMaxShardProcessorThreads(3).setInfoMaxAge(new Duration(22.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSinkMaxBufferSize(new DataSize(42.0, DataSize.Unit.MEGABYTE)).setWriterCount(3).setHttpNotificationThreads(4);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

