/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.failureDetector;

import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.failureDetector.HeartbeatFailureDetector;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceTypes;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import java.lang.annotation.Annotation;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHeartbeatFailureDetector {
    @Test
    public void testExcludesCurrentNode() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingJmxModule(), new TestingDiscoveryModule(), new TestingHttpServerModule(), new TraceTokenModule(), new JsonModule(), new JaxrsModule(true), new FailureDetectorModule(), new Module(){

            public void configure(Binder binder) {
                ConfigurationModule.bindConfig((Binder)binder).to(QueryManagerConfig.class);
                DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
                DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto");
                JaxrsBinder.jaxrsBinder((Binder)binder).bind(FooResource.class);
            }
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().initialize();
        ServiceSelector selector = (ServiceSelector)injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"presto")));
        Assert.assertEquals((int)selector.selectAllServices().size(), (int)1);
        HeartbeatFailureDetector detector = (HeartbeatFailureDetector)injector.getInstance(HeartbeatFailureDetector.class);
        detector.updateMonitoredServices();
        Assert.assertEquals((int)detector.getTotalCount(), (int)0);
        Assert.assertEquals((int)detector.getActiveCount(), (int)0);
        Assert.assertEquals((int)detector.getFailedCount(), (int)0);
        Assert.assertTrue((boolean)detector.getFailed().isEmpty());
    }

    @Path(value="/foo")
    public static class FooResource {
        @GET
        public String hello() {
            return "hello";
        }
    }
}

