/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.PagesSerde;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.testing.TestingBlockEncodingManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;

public class MockExchangeRequestProcessor
implements Function<Request, Response> {
    private final LoadingCache<URI, MockBuffer> buffers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<URI, MockBuffer>(){

        public MockBuffer load(URI location) {
            return new MockBuffer(location);
        }
    });
    private final DataSize expectedMaxSize;

    public MockExchangeRequestProcessor(DataSize expectedMaxSize) {
        this.expectedMaxSize = expectedMaxSize;
    }

    public void addPage(URI location, Page page) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).addPage(page);
    }

    public void setComplete(URI location) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).setCompleted();
    }

    public Response apply(Request request) {
        HttpStatus status;
        if (request.getMethod().equalsIgnoreCase("DELETE")) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assert.assertTrue((!request.getHeaders().get((Object)"X-Presto-Max-Size").isEmpty() ? 1 : 0) != 0);
        DataSize maxSize = DataSize.valueOf((String)request.getHeader("X-Presto-Max-Size"));
        Assert.assertEquals((Object)maxSize, (Object)this.expectedMaxSize);
        RequestLocation requestLocation = new RequestLocation(request.getUri());
        URI location = requestLocation.getLocation();
        BufferResult result = ((MockBuffer)this.buffers.getUnchecked((Object)location)).getPages(requestLocation.getSequenceId(), maxSize);
        List pages = result.getPages();
        byte[] bytes = new byte[]{};
        if (!pages.isEmpty()) {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(64);
            PagesSerde.writePages((BlockEncodingSerde)TestingBlockEncodingManager.createTestingBlockEncodingManager(), (SliceOutput)sliceOutput, (Iterable)pages);
            bytes = sliceOutput.slice().getBytes();
            status = HttpStatus.OK;
        } else {
            status = result.isBufferClosed() ? HttpStatus.GONE : HttpStatus.NO_CONTENT;
        }
        return new TestingResponse(status, (ListMultimap)ImmutableListMultimap.of((Object)"Content-Type", (Object)"application/X-presto-pages", (Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(result.getToken()), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(result.getNextToken())), bytes);
    }

    private static class MockBuffer {
        private final URI location;
        private final AtomicBoolean completed = new AtomicBoolean();
        private final AtomicLong token = new AtomicLong();
        private final BlockingQueue<Page> pages = new LinkedBlockingQueue<Page>();

        private MockBuffer(URI location) {
            this.location = location;
        }

        public void setCompleted() {
            this.completed.set(true);
        }

        public synchronized void addPage(Page page) {
            Preconditions.checkState((this.completed.get() != Boolean.TRUE.booleanValue() ? 1 : 0) != 0, (String)"Location %s is complete", (Object[])new Object[]{this.location});
            this.pages.add(page);
        }

        public BufferResult getPages(long sequenceId, DataSize maxSize) {
            if (this.completed.get() && this.pages.isEmpty()) {
                return BufferResult.emptyResults((long)this.token.get(), (boolean)true);
            }
            Assert.assertEquals((long)sequenceId, (long)this.token.get(), (String)"token");
            Page page = null;
            try {
                page = this.pages.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (page == null) {
                return BufferResult.emptyResults((long)this.token.get(), (boolean)false);
            }
            ArrayList<Page> responsePages = new ArrayList<Page>();
            responsePages.add(page);
            for (long responseSize = page.getSizeInBytes(); responseSize < maxSize.toBytes() && (page = (Page)this.pages.poll()) != null; responseSize += page.getSizeInBytes()) {
                responsePages.add(page);
            }
            long nextToken = this.token.get() + (long)responsePages.size();
            BufferResult bufferResult = new BufferResult(this.token.get(), nextToken, false, responsePages);
            this.token.set(nextToken);
            return bufferResult;
        }
    }

    private class RequestLocation {
        private final URI location;
        private final long sequenceId;

        public RequestLocation(URI uri) {
            String string = uri.toString();
            int index = string.lastIndexOf(47);
            this.location = URI.create(string.substring(0, index));
            this.sequenceId = Long.parseLong(string.substring(index + 1));
        }

        public URI getLocation() {
            return this.location;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

