/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMaxAggregation;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAggregationOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testAggregation() throws Exception {
        MetadataManager metadata = new MetadataManager();
        InternalAggregationFunction countVarcharColumn = metadata.resolveFunction(QualifiedName.of((String)"count", (String[])new String[0]), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"varchar")), false).getAggregationFunction();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR}).addSequencePage(100, 0, 0, 300, 500, 500, 500).build();
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty(), Optional.empty(), 1.0), (Object)LongSumAggregation.LONG_SUM.bind((List)ImmutableList.of((Object)1), Optional.empty(), Optional.empty(), 1.0), (Object)AverageAggregations.LONG_AVERAGE.bind((List)ImmutableList.of((Object)1), Optional.empty(), Optional.empty(), 1.0), (Object)VarBinaryMaxAggregation.VAR_BINARY_MAX.bind((List)ImmutableList.of((Object)2), Optional.empty(), Optional.empty(), 1.0), (Object)countVarcharColumn.bind((List)ImmutableList.of((Object)0), Optional.empty(), Optional.empty(), 1.0), (Object)LongSumAggregation.LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.empty(), Optional.empty(), 1.0), (Object)DoubleSumAggregation.DOUBLE_SUM.bind((List)ImmutableList.of((Object)4), Optional.empty(), Optional.empty(), 1.0), (Object)VarBinaryMaxAggregation.VAR_BINARY_MAX.bind((List)ImmutableList.of((Object)5), Optional.empty(), Optional.empty(), 1.0)));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{100, 4950, 49.5, "399", 100, 54950, 54950.0, "599"}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }
}

