/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TestOperatorStats;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriverStats {
    public static final DriverStats EXPECTED = new DriverStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new DataSize(6.0, DataSize.Unit.BYTE), new Duration(7.0, TimeUnit.NANOSECONDS), new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new DataSize(11.0, DataSize.Unit.BYTE), 12L, new Duration(13.0, TimeUnit.NANOSECONDS), new DataSize(13.0, DataSize.Unit.BYTE), 14L, new DataSize(15.0, DataSize.Unit.BYTE), 16L, (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DriverStats.class);
        String json = codec.toJson((Object)EXPECTED);
        DriverStats actual = (DriverStats)codec.fromJson(json);
        TestDriverStats.assertExpectedDriverStats(actual);
    }

    public static void assertExpectedDriverStats(DriverStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getMemoryReservation(), (Object)new DataSize(6.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(7.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(8.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalUserTime(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(11.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)12L);
        Assert.assertEquals((Object)actual.getRawInputReadTime(), (Object)new Duration(13.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(13.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)14L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)16L);
        Assert.assertEquals((int)actual.getOperatorStats().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorStats().get(0));
    }
}

