/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashSemiJoinOperator {
    private ExecutorService executor;
    private TaskContext taskContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.taskContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION);
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testSemiJoin(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.getTypes(), rowPagesBuilder.row(10).row(30).row(30).row(35).row(36).row(37).row(50).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, rowPagesBuilder.getHashChannel(), 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(10, 30, 0).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0, rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{30, 0, true}).row(new Object[]{31, 1, false}).row(new Object[]{32, 2, false}).row(new Object[]{33, 3, false}).row(new Object[]{34, 4, false}).row(new Object[]{35, 5, true}).row(new Object[]{36, 6, true}).row(new Object[]{37, 7, true}).row(new Object[]{38, 8, false}).row(new Object[]{39, 9, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testBuildSideNulls(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row(0).row(1).row(2).row(2).row(3).row(new Object[]{null}).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, rowPagesBuilder.getHashChannel(), 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(4, 1).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0, rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{1, true}).row(new Object[]{2, true}).row(new Object[]{3, true}).row(new Object[]{4, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testProbeSideNulls(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row(0).row(1).row(3).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, rowPagesBuilder.getHashChannel(), 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row(0).row(new Object[]{null}).row(1).row(2).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0, rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0, true}).row(new Object[]{null, null}).row(new Object[]{1, true}).row(new Object[]{2, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testProbeAndBuildNulls(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.row(0).row(1).row(new Object[]{null}).row(3).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, rowPagesBuilder.getHashChannel(), 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row(0).row(new Object[]{null}).row(1).row(2).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0, rowPagesBuilderProbe.getHashChannel());
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0, true}).row(new Object[]{null, null}).row(new Object[]{1, true}).row(new Object[]{2, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues", expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Task exceeded max memory size.*")
    public void testMemoryLimit(boolean hashEnabled) throws Exception {
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(100.0, DataSize.Unit.BYTE)).addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, rowPagesBuilder.addSequencePage(10000, 20).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, rowPagesBuilder.getHashChannel(), 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
    }
}

