/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.RecordProjectOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.util.InfiniteRecordSet;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRecordProjectOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSingleColumn() throws Exception {
        InMemoryRecordSet records = new InMemoryRecordSet((Collection)ImmutableList.of((Object)VarcharType.VARCHAR), (Collection)ImmutableList.copyOf((Object[])new List[]{ImmutableList.of((Object)"abc"), ImmutableList.of((Object)"def"), ImmutableList.of((Object)"g")}));
        OperatorContext operatorContext = this.driverContext.addOperatorContext(0, RecordProjectOperator.class.getSimpleName());
        RecordProjectOperator operator = new RecordProjectOperator(operatorContext, (RecordSet)records);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"abc"}).row(new Object[]{"def"}).row(new Object[]{"g"}).build();
        OperatorAssertion.assertOperatorEquals((Operator)operator, expected);
    }

    @Test
    public void testMultiColumn() throws Exception {
        InMemoryRecordSet records = new InMemoryRecordSet((Collection)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (Collection)ImmutableList.of((Object)ImmutableList.of((Object)"abc", (Object)1L), (Object)ImmutableList.of((Object)"def", (Object)2L), (Object)ImmutableList.of((Object)"g", (Object)0L)));
        OperatorContext operatorContext = this.driverContext.addOperatorContext(0, RecordProjectOperator.class.getSimpleName());
        RecordProjectOperator operator = new RecordProjectOperator(operatorContext, (RecordSet)records);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"abc", 1}).row(new Object[]{"def", 2}).row(new Object[]{"g", 0}).build();
        OperatorAssertion.assertOperatorEquals((Operator)operator, expected);
    }

    @Test
    public void testFinish() throws Exception {
        InfiniteRecordSet records = new InfiniteRecordSet((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (List<?>)ImmutableList.of((Object)"abc", (Object)1L));
        OperatorContext operatorContext = this.driverContext.addOperatorContext(0, RecordProjectOperator.class.getSimpleName());
        RecordProjectOperator operator = new RecordProjectOperator(operatorContext, (RecordSet)records);
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertNull((Object)operator.getOutput());
        Page page = null;
        for (int i = 0; i < 100 && (page = operator.getOutput()) == null; ++i) {
        }
        Assert.assertNotNull(page);
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        operator.finish();
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertNotNull((Object)operator.getOutput());
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)true);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertEquals((Object)operator.getOutput(), null);
    }
}

