/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TopNRowNumberOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTopNRowNumberOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testTopNRowNumberPartitioned(boolean hashEnabled) throws Exception {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
        List<Page> input = rowPagesBuilder.row(1, 0.3).row(2, 0.2).row(3, 0.1).row(3, 0.91).pageBreak().row(1, 0.4).pageBreak().row(1, 0.5).row(1, 0.6).row(2, 0.7).row(2, 0.8).pageBreak().row(2, 0.9).build();
        TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, false, Optional.empty(), 10);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.3, 1, 1}).row(new Object[]{0.4, 1, 2}).row(new Object[]{0.5, 1, 3}).row(new Object[]{0.2, 2, 1}).row(new Object[]{0.7, 2, 2}).row(new Object[]{0.8, 2, 3}).row(new Object[]{0.1, 3, 1}).row(new Object[]{0.91, 3, 2}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testTopNRowNumberUnPartitioned() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.3).row(2, 0.2).row(3, 0.1).row(3, 0.91).pageBreak().row(1, 0.4).pageBreak().row(1, 0.5).row(1, 0.6).row(2, 0.7).row(2, 0.8).pageBreak().row(2, 0.9).build();
        TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, false, Optional.empty(), 10);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.1, 3, 1}).row(new Object[]{0.2, 2, 2}).row(new Object[]{0.3, 1, 3}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }
}

