/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestApproximateAggregationFunction
extends AbstractTestAggregationFunction {
    private static final int WEIGHT = 10;

    protected abstract Type getType();

    protected abstract Double getExpectedValue(List<Number> var1);

    @Override
    public double getConfidence() {
        return 0.5;
    }

    @Override
    protected boolean isApproximate() {
        return true;
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)this.getType().getTypeSignature().toString());
    }

    @Override
    public Block getSequenceBlock(int start, int length) {
        BlockBuilder blockBuilder = this.getType().createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < start + length; ++i) {
            if (this.getType() == BigintType.BIGINT) {
                BigintType.BIGINT.writeLong(blockBuilder, (long)i);
                continue;
            }
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return blockBuilder.build();
    }

    @Override
    public Double getExpectedValue(int start, int length) {
        ArrayList<Number> values = new ArrayList<Number>();
        for (int i = 0; i < length; ++i) {
            int j;
            if (this.getType() == BigintType.BIGINT) {
                for (j = 0; j < 10; ++j) {
                    values.add((long)start + (long)i);
                }
                continue;
            }
            for (j = 0; j < 10; ++j) {
                values.add((double)start + (double)i);
            }
        }
        return this.getExpectedValue(values);
    }

    @Override
    public Double getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        int j;
        int i;
        ArrayList<Number> values = new ArrayList<Number>();
        for (i = 0; i < length; ++i) {
            if (this.getType() == BigintType.BIGINT) {
                for (j = 0; j < 10; ++j) {
                    values.add((long)start + (long)i);
                }
                continue;
            }
            for (j = 0; j < 10; ++j) {
                values.add((double)start + (double)i);
            }
        }
        for (i = length; i < lengthIncludingNulls; ++i) {
            for (j = 0; j < 10; ++j) {
                values.add(null);
            }
        }
        return this.getExpectedValue(values);
    }

    @Test
    public void testCorrectnessOnGaussianData() throws Exception {
        int originalDataSize = 10000;
        Random distribution = new Random(0L);
        ArrayList<Number> list = new ArrayList<Number>();
        for (int i = 0; i < originalDataSize; ++i) {
            list.add(distribution.nextGaussian() * 100.0);
        }
        this.testCorrectnessOfErrorFunction(list);
    }

    @Test
    public void testCorrectnessOnUniformData() throws Exception {
        int originalDataSize = 10000;
        Random distribution = new Random(0L);
        ArrayList<Number> list = new ArrayList<Number>();
        for (int i = 0; i < originalDataSize; ++i) {
            list.add(distribution.nextDouble() * 1000.0);
        }
        this.testCorrectnessOfErrorFunction(list);
    }

    private void testCorrectnessOfErrorFunction(List<Number> inputList) throws Exception {
        int inRange = 0;
        int numberOfRuns = 1000;
        double sampleRatio = 0.1;
        double actual = this.getExpectedValue(inputList);
        Random rand = new Random(1L);
        for (int i = 0; i < numberOfRuns; ++i) {
            Number x2;
            ImmutableList.Builder sampledList = ImmutableList.builder();
            for (Number x2 : inputList) {
                if (!(rand.nextDouble() < sampleRatio)) continue;
                sampledList.add((Object)x2);
            }
            BlockBuilder builder = this.getType().createBlockBuilder(new BlockBuilderStatus());
            x2 = sampledList.build().iterator();
            while (x2.hasNext()) {
                Number sample = (Number)x2.next();
                if (this.getType() == BigintType.BIGINT) {
                    BigintType.BIGINT.writeLong(builder, sample.longValue());
                    continue;
                }
                if (this.getType() == DoubleType.DOUBLE) {
                    DoubleType.DOUBLE.writeDouble(builder, sample.doubleValue());
                    continue;
                }
                throw new AssertionError((Object)"Can only handle longs and doubles");
            }
            Page page = new Page(new Block[]{builder.build()});
            page = OperatorAssertion.appendSampleWeight((List<Page>)ImmutableList.of((Object)page), 10).get(0);
            Accumulator accumulator = this.getFunction().bind((List)ImmutableList.of((Object)0), Optional.empty(), Optional.of(page.getChannelCount() - 1), this.getConfidence()).createAccumulator();
            accumulator.addInput(page);
            Block result = AggregationTestUtils.getFinalBlock(accumulator);
            String approxValue = BlockAssertions.toValues(accumulator.getFinalType(), result).get(0).toString();
            double approx = Double.parseDouble(approxValue.split(" ")[0]);
            double error = Double.parseDouble(approxValue.split(" ")[2]);
            if (!(Math.abs(approx - actual) <= error)) continue;
            ++inRange;
        }
        BinomialDistribution binomial = new BinomialDistribution(numberOfRuns, this.getConfidence());
        int lowerBound = binomial.inverseCumulativeProbability(0.01);
        int upperBound = binomial.inverseCumulativeProbability(0.99);
        Assert.assertTrue((lowerBound < inRange && inRange < upperBound ? 1 : 0) != 0, (String)String.format("%d out of %d passed. Expected [%d, %d]", inRange, numberOfRuns, lowerBound, upperBound));
    }

    @Override
    protected void testAggregation(Object expectedValue, Block block) {
        Page page = OperatorAssertion.appendSampleWeight((List<Page>)ImmutableList.of((Object)new Page(new Block[]{block})), 10).get(0);
        AggregationTestUtils.assertApproximateAggregation(this.getFunction(), page.getChannelCount() - 1, this.getConfidence(), (Double)expectedValue, page);
    }
}

