/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.AbstractFixedWidthType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import io.airlift.slice.Slices;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMaxByAggregation {
    private static final MetadataManager metadata = new MetadataManager();

    @BeforeClass
    public void setup() {
        ((TypeRegistry)metadata.getTypeManager()).addType((Type)CustomDoubleType.CUSTOM_DOUBLE);
    }

    @Test
    public void testAllRegistered() {
        Set orderableTypes = (Set)metadata.getTypeManager().getTypes().stream().filter(Type::isOrderable).collect(ImmutableCollectors.toImmutableSet());
        for (Type keyType : orderableTypes) {
            for (Type valueType : metadata.getTypeManager().getTypes()) {
                Assert.assertNotNull((Object)metadata.getExactFunction(new Signature("max_by", valueType.getTypeSignature(), new TypeSignature[]{valueType.getTypeSignature(), keyType.getTypeSignature()})));
            }
        }
    }

    @Test
    public void testNull() throws Exception {
        InternalAggregationFunction doubleDouble = metadata.getExactFunction(new Signature("max_by", "double", new String[]{"double", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, null, TestMaxByAggregation.createPage(new Double[]{1.0, null}, new Double[]{1.0, 2.0}));
    }

    @Test
    public void testDoubleDouble() throws Exception {
        InternalAggregationFunction doubleDouble = metadata.getExactFunction(new Signature("max_by", "double", new String[]{"double", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, null, TestMaxByAggregation.createPage(new Double[]{null}, new Double[]{null}), TestMaxByAggregation.createPage(new Double[]{null}, new Double[]{null}));
        AggregationTestUtils.assertAggregation(doubleDouble, 1.0, (Object)2.0, TestMaxByAggregation.createPage(new Double[]{3.0, 2.0}, new Double[]{1.0, 1.5}), TestMaxByAggregation.createPage(new Double[]{null}, new Double[]{null}));
    }

    @Test
    public void testDoubleVarchar() throws Exception {
        InternalAggregationFunction doubleVarchar = metadata.getExactFunction(new Signature("max_by", "varchar", new String[]{"varchar", "double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleVarchar, 1.0, (Object)"a", TestMaxByAggregation.createPage(new String[]{"z", "a"}, new Double[]{1.0, 2.0}), TestMaxByAggregation.createPage(new String[]{null}, new Double[]{null}));
        AggregationTestUtils.assertAggregation(doubleVarchar, 1.0, (Object)"hi", TestMaxByAggregation.createPage(new String[]{"zz", "hi"}, new Double[]{0.0, 1.0}), TestMaxByAggregation.createPage(new String[]{null, "a"}, new Double[]{null, -1.0}));
    }

    @Test
    public void testStateDeserializer() throws Exception {
        String[] keys = new String[]{"loooooong string", "short string"};
        double[] values = new double[]{3.14, 2.71};
        MaxOrMinByStateSerializer serializer = new MaxOrMinByStateSerializer();
        VariableWidthBlockBuilder builder = new VariableWidthBlockBuilder(new BlockBuilderStatus());
        for (int i = 0; i < keys.length; ++i) {
            serializer.serialize(TestMaxByAggregation.makeState(keys[i], values[i]), (BlockBuilder)builder);
        }
        Block serialized = builder.build();
        for (int i = 0; i < keys.length; ++i) {
            MaxOrMinByState deserialized = new MaxOrMinByStateFactory((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR).createSingleState();
            serializer.deserialize(serialized, i, deserialized);
            Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(deserialized.getKey(), 0), (Object)Slices.utf8Slice((String)keys[i]));
            Assert.assertEquals((Object)DoubleType.DOUBLE.getDouble(deserialized.getValue(), 0), (Object)values[i]);
        }
    }

    private static MaxOrMinByState makeState(String key, double value) {
        MaxOrMinByState result = new MaxOrMinByStateFactory((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR).createSingleState();
        result.setKey(BlockAssertions.createStringsBlock(key));
        result.setValue(BlockAssertions.createDoublesBlock(value));
        return result;
    }

    private static Page createPage(Double[] values, Double[] keys) {
        return new Page(new Block[]{BlockAssertions.createDoublesBlock(values), BlockAssertions.createDoublesBlock(keys)});
    }

    private static Page createPage(String[] values, Double[] keys) {
        return new Page(new Block[]{BlockAssertions.createStringsBlock(values), BlockAssertions.createDoublesBlock(keys)});
    }

    private static class CustomDoubleType
    extends AbstractFixedWidthType {
        public static final CustomDoubleType CUSTOM_DOUBLE = new CustomDoubleType();
        public static final String NAME = "custom_double";

        private CustomDoubleType() {
            super(TypeSignature.parseTypeSignature((String)NAME), Double.TYPE, 8);
        }

        public boolean isComparable() {
            return true;
        }

        public boolean isOrderable() {
            return true;
        }

        public Object getObjectValue(ConnectorSession session, Block block, int position) {
            if (block.isNull(position)) {
                return null;
            }
            return block.getDouble(position, 0);
        }

        public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
            long rightValue;
            long leftValue = leftBlock.getLong(leftPosition, 0);
            return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
        }

        public int hash(Block block, int position) {
            long value = block.getLong(position, 0);
            return (int)(value ^ value >>> 32);
        }

        public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
            double leftValue = leftBlock.getDouble(leftPosition, 0);
            double rightValue = rightBlock.getDouble(rightPosition, 0);
            return Double.compare(leftValue, rightValue);
        }

        public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
            if (block.isNull(position)) {
                blockBuilder.appendNull();
            } else {
                blockBuilder.writeDouble(block.getDouble(position, 0)).closeEntry();
            }
        }

        public double getDouble(Block block, int position) {
            return block.getDouble(position, 0);
        }

        public void writeDouble(BlockBuilder blockBuilder, double value) {
            blockBuilder.writeDouble(value).closeEntry();
        }
    }
}

