/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRegexpFunctions {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testRegexpLike() {
        this.assertFunction("REGEXP_LIKE('Stephen', 'Ste(v|ph)en')", true);
        this.assertFunction("REGEXP_LIKE('Stevens', 'Ste(v|ph)en')", true);
        this.assertFunction("REGEXP_LIKE('Stephen', '^Ste(v|ph)en$')", true);
        this.assertFunction("REGEXP_LIKE('Stevens', '^Ste(v|ph)en$')", false);
        this.assertFunction("REGEXP_LIKE('hello world', '[a-z]')", true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-z]+$')", false);
        this.assertFunction("REGEXP_LIKE('Hello', '^(?i)[a-z]+$')", true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-zA-Z]+$')", true);
    }

    @Test
    public void testRegexpReplace() {
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]')", " .");
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]', '*')", "*** *****.");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})')", "call  now");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})', '($1) $2-$3')", "call (555) 123-4444 now");
    }

    @Test
    public void testRegexpExtract() {
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)')", "world");
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', 1)", "orld");
        this.assertFunction("REGEXP_EXTRACT('rat cat\nbat dog', 'ra(.)|blah(.)(.)', 2)", null);
    }

    @Test
    public void testRegexpExtractAll() {
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', '.at')", ImmutableList.of((Object)"rat", (Object)"cat", (Object)"bat"));
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', '(.)at', 1)", ImmutableList.of((Object)"r", (Object)"c", (Object)"b"));
        ArrayList<Object> nullList = new ArrayList<Object>();
        nullList.add(null);
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', 'ra(.)|blah(.)(.)', 2)", nullList);
        this.assertInvalidFunction("REGEXP_EXTRACT_ALL('hello', '(.)', 2)", "Pattern has 1 groups. Cannot access group 2");
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private void assertInvalidFunction(String projection, String message) {
        try {
            this.assertFunction(projection, null);
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }
}

