/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.testing.TestingPrestoServer;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestExecuteResource {
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeMethod
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.client = new JettyHttpClient();
    }

    @AfterMethod
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testExecute() throws Exception {
        String expected = "{\"columns\":[{\"name\":\"foo\",\"type\":\"bigint\",\"typeSignature\":{\"rawType\":\"bigint\",\"typeArguments\":[],\"literalArguments\":[]}},{\"name\":\"bar\",\"type\":\"varchar\",\"typeSignature\":{\"rawType\":\"varchar\",\"typeArguments\":[],\"literalArguments\":[]}}],\"data\":[[123,\"abc\"]]}\n";
        StringResponseHandler.StringResponse response = this.executeQuery("SELECT 123 foo, 'abc' bar");
        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK.code());
        Assert.assertEquals((String)response.getHeader("Content-Type"), (String)"application/json");
        Assert.assertEquals((String)response.getBody(), (String)expected);
    }

    private StringResponseHandler.StringResponse executeQuery(String query) {
        Request request = Request.Builder.preparePost().setUri(this.server.resolve("/v1/execute")).setHeader("X-Presto-User", "test").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Time-Zone", "UTC").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8)).build();
        return (StringResponseHandler.StringResponse)this.client.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
    }
}

