/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.JsonPath;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.RegexpFunctions;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.type.LikeFunctions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joni.Regex;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestExpressionCompiler {
    private static final Boolean[] booleanValues = new Boolean[]{true, false, null};
    private static final Long[] longLefts = new Long[]{9L, 10L, 11L, -9L, -10L, -11L, 10151082135029368L, Long.MAX_VALUE, null};
    private static final Long[] longRights = new Long[]{3L, -3L, 10151082135029369L, null};
    private static final Long[] longMiddle = new Long[]{9L, -3L, 88L, null};
    private static final Double[] doubleLefts = new Double[]{9.0, 10.0, 11.0, -9.0, -10.0, -11.0, 9.1, 10.1, 11.1, -9.1, -10.1, -11.1, Double.MIN_VALUE, Double.MAX_VALUE, Double.MIN_NORMAL, null};
    private static final Double[] doubleRights = new Double[]{3.0, -3.0, 3.1, -3.1, null};
    private static final Double[] doubleMiddle = new Double[]{9.0, -3.1, 88.0, null};
    private static final String[] stringLefts = new String[]{"hello", "foo", "mellow", "fellow", "", null};
    private static final String[] stringRights = new String[]{"hello", "foo", "bar", "baz", "", null};
    private static final DateTime[] dateTimeValues = new DateTime[]{new DateTime(2001, 1, 22, 3, 4, 5, 321, DateTimeZone.UTC), new DateTime(1960, 1, 22, 3, 4, 5, 321, DateTimeZone.UTC), new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC), null};
    private static final String[] jsonValues = new String[]{"{}", "{\"fuu\": {\"bar\": 1}}", "{\"fuu\": null}", "{\"fuu\": 1}", "{\"fuu\": 1, \"bar\": \"abc\"}", null};
    private static final String[] jsonPatterns = new String[]{"$", "$.fuu", "$.fuu[0]", "$.bar", null};
    private static final Logger log = Logger.get(TestExpressionCompiler.class);
    private static final boolean PARALLEL = true;
    private long start;
    private ListeningExecutorService executor;
    private FunctionAssertions functionAssertions;
    private List<ListenableFuture<Void>> futures;

    @BeforeSuite
    public void setupClass() {
        Logging.initialize();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, Threads.daemonThreadsNamed((String)"completer-%d")));
        this.functionAssertions = new FunctionAssertions();
    }

    @AfterSuite
    public void tearDownClass() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    @BeforeMethod
    public void setUp() {
        this.start = System.nanoTime();
        this.futures = new ArrayList<ListenableFuture<Void>>();
    }

    @AfterMethod
    public void tearDown(Method method) throws Exception {
        Assert.assertTrue((boolean)Futures.allAsList(this.futures).isDone(), (String)"Expression test futures are not complete");
        log.info("FINISHED %s in %s verified %s expressions", new Object[]{method.getName(), Duration.nanosSince((long)this.start), this.futures.size()});
    }

    @Test
    public void smokedTest() throws Exception {
        this.assertExecute("cast(true as boolean)", (Object)true);
        this.assertExecute("true", (Object)true);
        this.assertExecute("false", (Object)false);
        this.assertExecute("42", (Object)42L);
        this.assertExecute("'foo'", (Object)"foo");
        this.assertExecute("4.2", (Object)4.2);
        this.assertExecute("1 + 1", (Object)2L);
        this.assertExecute("bound_long", (Object)1234L);
        this.assertExecute("bound_string", (Object)"hello");
        this.assertExecute("bound_double", (Object)12.34);
        this.assertExecute("bound_boolean", (Object)true);
        this.assertExecute("bound_timestamp", (Object)new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis());
        this.assertExecute("bound_pattern", (Object)"%el%");
        this.assertExecute("bound_null_string", null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void filterFunction() throws Exception {
        this.assertFilter("true", true);
        this.assertFilter("false", false);
        this.assertFilter("bound_long = 1234", true);
        this.assertFilter("bound_long = 5678", false);
        this.assertFilter("bound_null_string is null", true);
        this.assertFilter("bound_null_string = 'foo'", false);
        this.assertFilter("cast(null as boolean)", false);
        this.assertFilter("nullif(true, true)", false);
        this.assertFilter("true AND cast(null as boolean) AND true", false);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testUnaryOperators() throws Exception {
        this.assertExecute("cast(null as boolean) is null", (Object)true);
        for (Boolean bl : booleanValues) {
            this.assertExecute(this.generateExpression("%s", bl), bl == null ? null : Boolean.valueOf(bl != false));
            this.assertExecute(this.generateExpression("%s is null", bl), (Object)(bl == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", bl), (Object)(bl != null ? 1 : 0));
        }
        for (Comparable<Boolean> comparable : longLefts) {
            this.assertExecute(this.generateExpression("%s", (Long)comparable), comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("- (%s)", (Long)comparable), comparable == null ? null : Long.valueOf(-((Long)comparable).longValue()));
            this.assertExecute(this.generateExpression("%s is null", (Long)comparable), (Object)(comparable == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", (Long)comparable), (Object)(comparable != null ? 1 : 0));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            this.assertExecute(this.generateExpression("%s", (Double)comparable), comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("- (%s)", (Double)comparable), comparable == null ? null : Double.valueOf(-((Double)comparable).doubleValue()));
            this.assertExecute(this.generateExpression("%s is null", (Double)comparable), (Object)(comparable == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", (Double)comparable), (Object)(comparable != null ? 1 : 0));
        }
        for (String string : stringLefts) {
            this.assertExecute(this.generateExpression("%s", string), (Object)(string == null ? null : string));
            this.assertExecute(this.generateExpression("%s is null", string), (Object)(string == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", string), (Object)(string != null ? 1 : 0));
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFilterEmptyInput() throws Exception {
        this.assertFilterWithNoInputColumns("true", true);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsBoolean() throws Exception {
        this.assertExecute("nullif(cast(null as boolean), true)", null);
        for (Boolean left : booleanValues) {
            for (Boolean right : booleanValues) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), left == null || right == null ? null : Boolean.valueOf(left == right));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), left == null || right == null ? null : Boolean.valueOf(left != right));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Object)(!Objects.equals(left, right) ? 1 : 0));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsLongLong() throws Exception {
        for (Long left : longLefts) {
            for (Long right : longRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.longValue() == right.longValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.longValue() != right.longValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), left == null || right == null ? null : Boolean.valueOf(left > right));
                this.assertExecute(this.generateExpression("%s < %s", left, right), left == null || right == null ? null : Boolean.valueOf(left < right));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left >= right));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left <= right));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Object)(!Objects.equals(left, right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), left == null || right == null ? null : Long.valueOf(left + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), left == null || right == null ? null : Long.valueOf(left - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), left == null || right == null ? null : Long.valueOf(left * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), left == null || right == null ? null : Long.valueOf(left / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), left == null || right == null ? null : Long.valueOf(left % right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsLongDouble() throws Exception {
        for (Long left : longLefts) {
            for (Double right : doubleRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), left == null || right == null ? null : Boolean.valueOf((double)left.longValue() == right));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), left == null || right == null ? null : Boolean.valueOf((double)left.longValue() != right));
                this.assertExecute(this.generateExpression("%s > %s", left, right), left == null || right == null ? null : Boolean.valueOf((double)left.longValue() > right));
                this.assertExecute(this.generateExpression("%s < %s", left, right), left == null || right == null ? null : Boolean.valueOf((double)left.longValue() < right));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), left == null || right == null ? null : Boolean.valueOf((double)left.longValue() >= right));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), left == null || right == null ? null : Boolean.valueOf((double)left.longValue() <= right));
                Object expectedNullIf = TestExpressionCompiler.nullIf(left, right);
                for (String expression : this.generateExpression("nullif(%s, %s)", left, right)) {
                    this.functionAssertions.assertFunction(expression, expectedNullIf);
                }
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Object)(!Objects.equals(left == null ? null : Double.valueOf(left.doubleValue()), right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), left == null || right == null ? null : Double.valueOf((double)left.longValue() + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), left == null || right == null ? null : Double.valueOf((double)left.longValue() - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), left == null || right == null ? null : Double.valueOf((double)left.longValue() * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), left == null || right == null ? null : Double.valueOf((double)left.longValue() / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), left == null || right == null ? null : Double.valueOf((double)left.longValue() % right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDoubleLong() throws Exception {
        for (Double left : doubleLefts) {
            for (Long right : longRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), left == null || right == null ? null : Boolean.valueOf(left == (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), left == null || right == null ? null : Boolean.valueOf(left != (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), left == null || right == null ? null : Boolean.valueOf(left > (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s < %s", left, right), left == null || right == null ? null : Boolean.valueOf(left < (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left >= (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left <= (double)right.longValue()));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Object)(!Objects.equals(left, right == null ? null : Double.valueOf(right.doubleValue())) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), left == null || right == null ? null : Double.valueOf(left + (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s - %s", left, right), left == null || right == null ? null : Double.valueOf(left - (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s * %s", left, right), left == null || right == null ? null : Double.valueOf(left * (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s / %s", left, right), left == null || right == null ? null : Double.valueOf(left / (double)right.longValue()));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), left == null || right == null ? null : Double.valueOf(left % (double)right.longValue()));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDoubleDouble() throws Exception {
        for (Double left : doubleLefts) {
            for (Double right : doubleRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), left == null || right == null ? null : Boolean.valueOf(left > right));
                this.assertExecute(this.generateExpression("%s < %s", left, right), left == null || right == null ? null : Boolean.valueOf(left < right));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left >= right));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left <= right));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Object)(!Objects.equals(left, right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), left == null || right == null ? null : Double.valueOf(left + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), left == null || right == null ? null : Double.valueOf(left - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), left == null || right == null ? null : Double.valueOf(left * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), left == null || right == null ? null : Double.valueOf(left / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), left == null || right == null ? null : Double.valueOf(left % right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsString() throws Exception {
        for (String left : stringLefts) {
            for (String right : stringRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.equals(right)));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), left == null || right == null ? null : Boolean.valueOf(!left.equals(right)));
                this.assertExecute(this.generateExpression("%s > %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) > 0));
                this.assertExecute(this.generateExpression("%s < %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) < 0));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) >= 0));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) <= 0));
                this.assertExecute(this.generateExpression("%s || %s", left, right), left == null || right == null ? null : left + right);
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Object)(!Objects.equals(left, right) ? 1 : 0));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), TestExpressionCompiler.nullIf(left, right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    private static Object nullIf(Object left, Object right) {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return left;
        }
        if (left.equals(right)) {
            return null;
        }
        if ((left instanceof Double || right instanceof Double) && ((Number)left).doubleValue() == ((Number)right).doubleValue()) {
            return null;
        }
        return left;
    }

    @Test
    public void testTernaryOperatorsLongLong() throws Exception {
        for (Long first : longLefts) {
            for (Long second : longLefts) {
                for (Long third : longRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), first == null || second == null || third == null ? null : Boolean.valueOf(second <= first && first <= third));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsLongDouble() throws Exception {
        for (Long first : longLefts) {
            for (Double second : doubleLefts) {
                for (Long third : longRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), first == null || second == null || third == null ? null : Boolean.valueOf(second <= (double)first.longValue() && first <= third));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsDoubleDouble() throws Exception {
        for (Double first : doubleLefts) {
            for (Double second : doubleLefts) {
                for (Long third : longRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), first == null || second == null || third == null ? null : Boolean.valueOf(second <= first && first <= (double)third.longValue()));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsString() throws Exception {
        for (String first : stringLefts) {
            for (String second : stringLefts) {
                for (String third : stringRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), first == null || second == null || third == null ? null : Boolean.valueOf(second.compareTo(first) <= 0 && first.compareTo(third) <= 0));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testCast() throws Exception {
        for (Boolean bl : booleanValues) {
            this.assertExecute(this.generateExpression("cast(%s as boolean)", bl), bl == null ? null : Boolean.valueOf(bl != false));
            this.assertExecute(this.generateExpression("cast(%s as bigint)", bl), bl == null ? null : Long.valueOf(bl != false ? 1L : 0L));
            this.assertExecute(this.generateExpression("cast(%s as double)", bl), bl == null ? null : Double.valueOf(bl != false ? 1.0 : 0.0));
            this.assertExecute(this.generateExpression("cast(%s as varchar)", bl), bl == null ? null : (bl != false ? "true" : "false"));
        }
        for (Comparable<Boolean> comparable : longLefts) {
            this.assertExecute(this.generateExpression("cast(%s as boolean)", (Long)comparable), comparable == null ? null : Boolean.valueOf((Long)comparable != 0L));
            this.assertExecute(this.generateExpression("cast(%s as bigint)", (Long)comparable), comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("cast(%s as double)", (Long)comparable), comparable == null ? null : Double.valueOf(((Long)comparable).doubleValue()));
            this.assertExecute(this.generateExpression("cast(%s as varchar)", (Long)comparable), (Object)(comparable == null ? null : String.valueOf(comparable)));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            this.assertExecute(this.generateExpression("cast(%s as boolean)", (Double)comparable), comparable == null ? null : Boolean.valueOf((Double)comparable != 0.0));
            this.assertExecute(this.generateExpression("cast(%s as bigint)", (Double)comparable), comparable == null ? null : Long.valueOf(((Double)comparable).longValue()));
            this.assertExecute(this.generateExpression("cast(%s as double)", (Double)comparable), comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("cast(%s as varchar)", (Double)comparable), (Object)(comparable == null ? null : String.valueOf(comparable)));
        }
        this.assertExecute("cast('true' as boolean)", (Object)true);
        this.assertExecute("cast('true' as BOOLEAN)", (Object)true);
        this.assertExecute("cast('tRuE' as BOOLEAN)", (Object)true);
        this.assertExecute("cast('false' as BOOLEAN)", (Object)false);
        this.assertExecute("cast('fAlSe' as BOOLEAN)", (Object)false);
        this.assertExecute("cast('t' as BOOLEAN)", (Object)true);
        this.assertExecute("cast('T' as BOOLEAN)", (Object)true);
        this.assertExecute("cast('f' as BOOLEAN)", (Object)false);
        this.assertExecute("cast('F' as BOOLEAN)", (Object)false);
        this.assertExecute("cast('1' as BOOLEAN)", (Object)true);
        this.assertExecute("cast('0' as BOOLEAN)", (Object)false);
        for (Comparable<Boolean> comparable : longLefts) {
            if (comparable == null) continue;
            this.assertExecute(this.generateExpression("cast(%s as bigint)", String.valueOf(comparable)), comparable == null ? null : comparable);
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            if (comparable == null) continue;
            this.assertExecute(this.generateExpression("cast(%s as double)", String.valueOf(comparable)), comparable == null ? null : comparable);
        }
        for (String string : stringLefts) {
            this.assertExecute(this.generateExpression("cast(%s as varchar)", string), (Object)(string == null ? null : string));
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTryCast() throws Exception {
        this.assertExecute("try_cast(null as bigint)", null);
        this.assertExecute("try_cast('123' as bigint)", (Object)123L);
        this.assertExecute("try_cast('foo' as varchar)", (Object)"foo");
        this.assertExecute("try_cast('foo' as bigint)", null);
        this.assertExecute("try_cast(bound_string as bigint)", null);
        this.assertExecute("coalesce(try_cast('123' as bigint), 456)", (Object)123L);
        this.assertExecute("coalesce(try_cast('foo' as bigint), 456)", (Object)456L);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testAnd() throws Exception {
        this.assertExecute("true and true", (Object)true);
        this.assertExecute("true and false", (Object)false);
        this.assertExecute("false and true", (Object)false);
        this.assertExecute("false and false", (Object)false);
        this.assertExecute("true and cast(null as boolean)", null);
        this.assertExecute("false and cast(null as boolean)", (Object)false);
        this.assertExecute("cast(null as boolean) and true", null);
        this.assertExecute("cast(null as boolean) and false", (Object)false);
        this.assertExecute("cast(null as boolean) and cast(null as boolean)", null);
        this.assertExecute("true and null", null);
        this.assertExecute("false and null", (Object)false);
        this.assertExecute("null and true", null);
        this.assertExecute("null and false", (Object)false);
        this.assertExecute("null and null", null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testOr() throws Exception {
        this.assertExecute("true or true", (Object)true);
        this.assertExecute("true or false", (Object)true);
        this.assertExecute("false or true", (Object)true);
        this.assertExecute("false or false", (Object)false);
        this.assertExecute("true or cast(null as boolean)", (Object)true);
        this.assertExecute("false or cast(null as boolean)", null);
        this.assertExecute("cast(null as boolean) or true", (Object)true);
        this.assertExecute("cast(null as boolean) or false", null);
        this.assertExecute("cast(null as boolean) or cast(null as boolean)", null);
        this.assertExecute("true or null", (Object)true);
        this.assertExecute("false or null", null);
        this.assertExecute("null or true", (Object)true);
        this.assertExecute("null or false", null);
        this.assertExecute("null or null", null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testNot() throws Exception {
        this.assertExecute("not true", (Object)false);
        this.assertExecute("not false", (Object)true);
        this.assertExecute("not cast(null as boolean)", null);
        this.assertExecute("not null", null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testIf() throws Exception {
        for (Boolean condition : booleanValues) {
            for (String trueValue : stringLefts) {
                for (String falseValue : stringRights) {
                    this.assertExecute(this.generateExpression("if(%s, %s, %s)", condition, trueValue, falseValue), (Object)(condition != null && condition != false ? trueValue : falseValue));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testSimpleCase() throws Exception {
        String expected;
        for (Double d : doubleLefts) {
            for (Double d2 : doubleMiddle) {
                for (Double d3 : doubleRights) {
                    expected = d == null ? "else" : (d2 != null && d.doubleValue() == d2.doubleValue() ? "first" : (d3 != null && d.doubleValue() == d3.doubleValue() ? "second" : "else"));
                    this.assertExecute(this.generateExpression("case %s when %s then 'first' when %s then 'second' else 'else' end", d, d2, d3), (Object)expected);
                }
            }
        }
        for (Number number : longLefts) {
            for (Number number2 : longMiddle) {
                for (Number number3 : longRights) {
                    expected = number == null ? null : (number2 != null && ((Long)number2).equals(number) ? "first" : (number3 != null && ((Long)number3).equals(number) ? "second" : null));
                    this.assertExecute(this.generateExpression("case %s when %s then 'first' when %s then 'second' end", (Long)number, (Long)number2, (Long)number3), (Object)expected);
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testSearchCaseSingle() throws Exception {
        for (Double value : doubleLefts) {
            for (Long firstTest : longLefts) {
                for (Double secondTest : doubleRights) {
                    String expected = value == null ? "else" : (firstTest != null && value == (double)firstTest.longValue() ? "first" : (secondTest != null && value.doubleValue() == secondTest.doubleValue() ? "second" : "else"));
                    List<String> expressions = this.formatExpression("case when %s = %s then 'first' when %s = %s then 'second' else 'else' end", Arrays.asList(value, firstTest, value, secondTest), (List<String>)ImmutableList.of((Object)"double", (Object)"bigint", (Object)"double", (Object)"double"));
                    this.assertExecute(expressions, (Object)expected);
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testSearchCaseMultiple() throws Exception {
        for (Double value : doubleLefts) {
            for (Long firstTest : longLefts) {
                for (Double secondTest : doubleRights) {
                    String expected = value == null ? null : (firstTest != null && value == (double)firstTest.longValue() ? "first" : (secondTest != null && value.doubleValue() == secondTest.doubleValue() ? "second" : null));
                    List<String> expressions = this.formatExpression("case when %s = %s then 'first' when %s = %s then 'second' end", Arrays.asList(value, firstTest, value, secondTest), (List<String>)ImmutableList.of((Object)"double", (Object)"bigint", (Object)"double", (Object)"double"));
                    this.assertExecute(expressions, (Object)expected);
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testIn() throws Exception {
        List<Object> testValues;
        for (Boolean bl : booleanValues) {
            this.assertExecute(this.generateExpression("%s in (true)", bl), bl == null ? null : Boolean.valueOf(bl == Boolean.TRUE));
            this.assertExecute(this.generateExpression("%s in (null, true)", bl), bl == null ? null : (bl == Boolean.TRUE ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (true, null)", bl), bl == null ? null : (bl == Boolean.TRUE ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (false)", bl), bl == null ? null : Boolean.valueOf(bl == Boolean.FALSE));
            this.assertExecute(this.generateExpression("%s in (null, false)", bl), bl == null ? null : (bl == Boolean.FALSE ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (null)", bl), null);
        }
        for (Comparable<Boolean> comparable : longLefts) {
            testValues = Arrays.asList(33L, 9L, -9L, -33L);
            this.assertExecute(this.generateExpression("%s in (33, 9, -9, -33)", (Long)comparable), comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33, 9, -9, -33)", (Long)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33, null, 9, -9, -33)", (Long)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33, 9.0, -9, -33)", (Long)comparable), comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33, 9.0, -9, -33)", (Long)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0, null, 9.0, -9, -33)", (Long)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            testValues = Arrays.asList(33.0, 9.0, -9.0, -33.0);
            this.assertExecute(this.generateExpression("%s in (33.0, 9.0, -9.0, -33.0)", (Double)comparable), comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33.0, 9.0, -9.0, -33.0)", (Double)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0, null, 9.0, -9.0, -33.0)", (Double)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0, 9, -9, -33.0)", (Double)comparable), comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33.0, 9, -9, -33.0)", (Double)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0, null, 9, -9, -33.0)", (Double)comparable), comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            testValues = Arrays.asList(33.0, Math.cos(9.0), Math.cos(-9.0), -33.0);
            this.assertExecute(this.generateExpression("cos(%s) in (33.0, cos(9.0), cos(-9.0), -33.0)", (Double)comparable), comparable == null ? null : Boolean.valueOf(testValues.contains(Math.cos((Double)comparable))));
            this.assertExecute(this.generateExpression("cos(%s) in (null, 33.0, cos(9.0), cos(-9.0), -33.0)", (Double)comparable), comparable == null ? null : (testValues.contains(Math.cos((Double)comparable)) ? Boolean.valueOf(true) : null));
        }
        for (String string : stringLefts) {
            testValues = Arrays.asList("what?", "foo", "mellow", "end");
            this.assertExecute(this.generateExpression("%s in ('what?', 'foo', 'mellow', 'end')", string), string == null ? null : Boolean.valueOf(testValues.contains(string)));
            this.assertExecute(this.generateExpression("%s in (null, 'what?', 'foo', 'mellow', 'end')", string), string == null ? null : (testValues.contains(string) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in ('what?', null, 'foo', 'mellow', 'end')", string), string == null ? null : (testValues.contains(string) ? Boolean.valueOf(true) : null));
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testHugeIn() throws Exception {
        ContiguousSet longValues = ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(2000), (Comparable)Integer.valueOf(7000)), (DiscreteDomain)DiscreteDomain.integers());
        this.assertExecute("bound_long in (1234, " + Joiner.on((String)", ").join((Iterable)longValues) + ")", (Object)true);
        this.assertExecute("bound_long in (" + Joiner.on((String)", ").join((Iterable)longValues) + ")", (Object)false);
        Iterable doubleValues = Iterables.transform((Iterable)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(2000), (Comparable)Integer.valueOf(7000)), (DiscreteDomain)DiscreteDomain.integers()), i -> (double)i.intValue());
        this.assertExecute("bound_double in (12.34, " + Joiner.on((String)", ").join(doubleValues) + ")", (Object)true);
        this.assertExecute("bound_double in (" + Joiner.on((String)", ").join(doubleValues) + ")", (Object)false);
        Iterable stringValues = Iterables.transform((Iterable)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(2000), (Comparable)Integer.valueOf(7000)), (DiscreteDomain)DiscreteDomain.integers()), i -> "'" + i + "'");
        this.assertExecute("bound_string in ('hello', " + Joiner.on((String)", ").join(stringValues) + ")", (Object)true);
        this.assertExecute("bound_string in (" + Joiner.on((String)", ").join(stringValues) + ")", (Object)false);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionCall() throws Exception {
        for (Long l : longLefts) {
            for (Long l2 : longRights) {
                this.assertExecute(this.generateExpression("log(%s, %s)", l, l2), l == null || l2 == null ? null : Double.valueOf(MathFunctions.log((double)l.longValue(), (double)l2.longValue())));
            }
        }
        for (Long l : longLefts) {
            for (Number number : doubleRights) {
                this.assertExecute(this.generateExpression("log(%s, %s)", l, (Double)number), l == null || number == null ? null : Double.valueOf(MathFunctions.log((double)l.longValue(), (double)((Double)number))));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number2 : longRights) {
                this.assertExecute(this.generateExpression("log(%s, %s)", (Double)number, (Long)number2), number == null || number2 == null ? null : Double.valueOf(MathFunctions.log((double)((Double)number), (double)((Long)number2).longValue())));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number3 : doubleRights) {
                this.assertExecute(this.generateExpression("log(%s, %s)", (Double)number, (Double)number3), number == null || number3 == null ? null : Double.valueOf(MathFunctions.log((double)((Double)number), (double)((Double)number3))));
            }
        }
        for (String string : stringLefts) {
            for (Number number : longLefts) {
                for (Long length : longRights) {
                    String expected = string == null || number == null || length == null ? null : StringFunctions.substr((Slice)Slices.copiedBuffer((String)string, (Charset)StandardCharsets.UTF_8), (long)((Long)number), (long)length).toString(StandardCharsets.UTF_8);
                    this.assertExecute(this.generateExpression("substr(%s, %s, %s)", string, (Long)number, length), expected);
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionCallRegexp() throws Exception {
        for (String value : stringLefts) {
            for (String pattern : stringRights) {
                this.assertExecute(this.generateExpression("regexp_like(%s, %s)", value, pattern), value == null || pattern == null ? null : Boolean.valueOf(RegexpFunctions.regexpLike((Slice)Slices.utf8Slice((String)value), (Pattern)RegexpFunctions.castToRegexp((Slice)Slices.utf8Slice((String)pattern)))));
                this.assertExecute(this.generateExpression("regexp_replace(%s, %s)", value, pattern), value == null || pattern == null ? null : RegexpFunctions.regexpReplace((Slice)Slices.utf8Slice((String)value), (Pattern)RegexpFunctions.castToRegexp((Slice)Slices.utf8Slice((String)pattern))));
                this.assertExecute(this.generateExpression("regexp_extract(%s, %s)", value, pattern), value == null || pattern == null ? null : RegexpFunctions.regexpExtract((Slice)Slices.utf8Slice((String)value), (Pattern)RegexpFunctions.castToRegexp((Slice)Slices.utf8Slice((String)pattern))));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionCallJson() throws Exception {
        for (String value : jsonValues) {
            for (String pattern : jsonPatterns) {
                this.assertExecute(this.generateExpression("json_extract(%s, %s)", value, pattern), value == null || pattern == null ? null : JsonFunctions.jsonExtract((Slice)Slices.copiedBuffer((String)value, (Charset)StandardCharsets.UTF_8), (JsonPath)new JsonPath(pattern)));
                this.assertExecute(this.generateExpression("json_extract_scalar(%s, %s)", value, pattern), value == null || pattern == null ? null : JsonFunctions.jsonExtractScalar((Slice)Slices.copiedBuffer((String)value, (Charset)StandardCharsets.UTF_8), (JsonPath)new JsonPath(pattern)));
                this.assertExecute(this.generateExpression("json_extract(%s, %s || '')", value, pattern), value == null || pattern == null ? null : JsonFunctions.jsonExtract((Slice)Slices.copiedBuffer((String)value, (Charset)StandardCharsets.UTF_8), (JsonPath)new JsonPath(pattern)));
                this.assertExecute(this.generateExpression("json_extract_scalar(%s, %s || '')", value, pattern), value == null || pattern == null ? null : JsonFunctions.jsonExtractScalar((Slice)Slices.copiedBuffer((String)value, (Charset)StandardCharsets.UTF_8), (JsonPath)new JsonPath(pattern)));
            }
        }
        this.assertExecute("json_array_contains('[1, 2, 3]', 2)", (Object)true);
        this.assertExecute("json_array_contains('[2.5]', 2.5)", (Object)true);
        this.assertExecute("json_array_contains('[false, true]', true)", (Object)true);
        this.assertExecute("json_array_contains('[5]', 3)", (Object)false);
        this.assertExecute("json_array_contains('[', 9)", null);
        this.assertExecute("json_array_length('[')", null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionWithSessionCall() throws Exception {
        this.assertExecute("now()", (Object)new SqlTimestampWithTimeZone(SessionTestUtils.TEST_SESSION.getStartTime(), SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        this.assertExecute("current_timestamp", (Object)new SqlTimestampWithTimeZone(SessionTestUtils.TEST_SESSION.getStartTime(), SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testExtract() throws Exception {
        for (DateTime left : dateTimeValues) {
            for (Extract.Field field : Extract.Field.values()) {
                Long expected = null;
                Long millis = null;
                if (left != null) {
                    millis = left.getMillis();
                    expected = TestExpressionCompiler.callExtractFunction(SessionTestUtils.TEST_SESSION.toConnectorSession(), millis, field);
                }
                this.assertExecute(this.generateExpression("extract(" + field.toString() + " from from_unixtime(%s / 1000.0, 0, 0))", millis), (Object)expected);
            }
        }
        Futures.allAsList(this.futures).get();
    }

    private static long callExtractFunction(ConnectorSession session, long value, Extract.Field field) {
        switch (field) {
            case YEAR: {
                return DateTimeFunctions.yearFromTimestamp((ConnectorSession)session, (long)value);
            }
            case QUARTER: {
                return DateTimeFunctions.quarterFromTimestamp((ConnectorSession)session, (long)value);
            }
            case MONTH: {
                return DateTimeFunctions.monthFromTimestamp((ConnectorSession)session, (long)value);
            }
            case WEEK: {
                return DateTimeFunctions.weekFromTimestamp((ConnectorSession)session, (long)value);
            }
            case DAY: 
            case DAY_OF_MONTH: {
                return DateTimeFunctions.dayFromTimestamp((ConnectorSession)session, (long)value);
            }
            case DAY_OF_WEEK: 
            case DOW: {
                return DateTimeFunctions.dayOfWeekFromTimestamp((ConnectorSession)session, (long)value);
            }
            case YEAR_OF_WEEK: 
            case YOW: {
                return DateTimeFunctions.yearOfWeekFromTimestamp((ConnectorSession)session, (long)value);
            }
            case DAY_OF_YEAR: 
            case DOY: {
                return DateTimeFunctions.dayOfYearFromTimestamp((ConnectorSession)session, (long)value);
            }
            case HOUR: {
                return DateTimeFunctions.hourFromTimestamp((ConnectorSession)session, (long)value);
            }
            case MINUTE: {
                return DateTimeFunctions.minuteFromTimestamp((ConnectorSession)session, (long)value);
            }
            case SECOND: {
                return DateTimeFunctions.secondFromTimestamp((long)value);
            }
            case TIMEZONE_MINUTE: {
                return DateTimeFunctions.timeZoneMinuteFromTimestampWithTimeZone((long)DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey()));
            }
            case TIMEZONE_HOUR: {
                return DateTimeFunctions.timeZoneHourFromTimestampWithTimeZone((long)DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey()));
            }
        }
        throw new AssertionError((Object)("Unhandled field: " + field));
    }

    @Test
    public void testLike() throws Exception {
        for (String value : stringLefts) {
            for (String pattern : stringLefts) {
                Boolean expected = null;
                if (value != null && pattern != null) {
                    Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern), (Slice)Slices.utf8Slice((String)"\\"));
                    expected = LikeFunctions.like((Slice)Slices.copiedBuffer((String)value, (Charset)StandardCharsets.UTF_8), (Regex)regex);
                }
                this.assertExecute(this.generateExpression("%s like %s", value, pattern), expected);
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testCoalesce() throws Exception {
        this.assertExecute("coalesce(9, 1)", (Object)9L);
        this.assertExecute("coalesce(9, null)", (Object)9L);
        this.assertExecute("coalesce(9, cast(null as bigint))", (Object)9L);
        this.assertExecute("coalesce(null, 9, 1)", (Object)9L);
        this.assertExecute("coalesce(null, 9, null)", (Object)9L);
        this.assertExecute("coalesce(null, 9, cast(null as bigint))", (Object)9L);
        this.assertExecute("coalesce(cast(null as bigint), 9, 1)", (Object)9L);
        this.assertExecute("coalesce(cast(null as bigint), 9, null)", (Object)9L);
        this.assertExecute("coalesce(cast(null as bigint), 9, cast(null as bigint))", (Object)9L);
        this.assertExecute("coalesce(9.0, 1.0)", (Object)9.0);
        this.assertExecute("coalesce(9.0, 1)", (Object)9.0);
        this.assertExecute("coalesce(9.0, null)", (Object)9.0);
        this.assertExecute("coalesce(9.0, cast(null as double))", (Object)9.0);
        this.assertExecute("coalesce(null, 9.0, 1)", (Object)9.0);
        this.assertExecute("coalesce(null, 9.0, null)", (Object)9.0);
        this.assertExecute("coalesce(null, 9.0, cast(null as double))", (Object)9.0);
        this.assertExecute("coalesce(null, 9.0, cast(null as bigint))", (Object)9.0);
        this.assertExecute("coalesce(cast(null as bigint), 9.0, 1)", (Object)9.0);
        this.assertExecute("coalesce(cast(null as bigint), 9.0, null)", (Object)9.0);
        this.assertExecute("coalesce(cast(null as bigint), 9.0, cast(null as bigint))", (Object)9.0);
        this.assertExecute("coalesce(cast(null as double), 9.0, cast(null as double))", (Object)9.0);
        this.assertExecute("coalesce('foo', 'bar')", (Object)"foo");
        this.assertExecute("coalesce('foo', null)", (Object)"foo");
        this.assertExecute("coalesce('foo', cast(null as varchar))", (Object)"foo");
        this.assertExecute("coalesce(null, 'foo', 'bar')", (Object)"foo");
        this.assertExecute("coalesce(null, 'foo', null)", (Object)"foo");
        this.assertExecute("coalesce(null, 'foo', cast(null as varchar))", (Object)"foo");
        this.assertExecute("coalesce(cast(null as varchar), 'foo', 'bar')", (Object)"foo");
        this.assertExecute("coalesce(cast(null as varchar), 'foo', null)", (Object)"foo");
        this.assertExecute("coalesce(cast(null as varchar), 'foo', cast(null as varchar))", (Object)"foo");
        this.assertExecute("coalesce(cast(null as bigint), null, cast(null as bigint))", null);
        Futures.allAsList(this.futures).get();
    }

    private List<String> generateExpression(String expressionPattern, Boolean value) {
        return this.formatExpression(expressionPattern, value, "boolean");
    }

    private List<String> generateExpression(String expressionPattern, Long value) {
        return this.formatExpression(expressionPattern, value, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Double value) {
        return this.formatExpression(expressionPattern, value, "double");
    }

    private List<String> generateExpression(String expressionPattern, String value) {
        return this.formatExpression(expressionPattern, value, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, Boolean left, Boolean right) {
        return this.formatExpression(expressionPattern, left, "boolean", right, "boolean");
    }

    private List<String> generateExpression(String expressionPattern, Long left, Long right) {
        return this.formatExpression(expressionPattern, left, "bigint", right, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Long left, Double right) {
        return this.formatExpression(expressionPattern, left, "bigint", right, "double");
    }

    private List<String> generateExpression(String expressionPattern, Double left, Long right) {
        return this.formatExpression(expressionPattern, left, "double", right, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Double left, Double right) {
        return this.formatExpression(expressionPattern, left, "double", right, "double");
    }

    private List<String> generateExpression(String expressionPattern, String left, String right) {
        return this.formatExpression(expressionPattern, left, "varchar", right, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, Long first, Long second, Long third) {
        return this.formatExpression(expressionPattern, first, "bigint", second, "bigint", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Long first, Double second, Long third) {
        return this.formatExpression(expressionPattern, first, "bigint", second, "double", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Double first, Double second, Double third) {
        return this.formatExpression(expressionPattern, first, "double", second, "double", third, "double");
    }

    private List<String> generateExpression(String expressionPattern, Double first, Double second, Long third) {
        return this.formatExpression(expressionPattern, first, "double", second, "double", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Double first, Long second, Double third) {
        return this.formatExpression(expressionPattern, first, "double", second, "bigint", third, "double");
    }

    private List<String> generateExpression(String expressionPattern, String first, String second, String third) {
        return this.formatExpression(expressionPattern, first, "varchar", second, "varchar", third, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, Boolean first, String second, String third) {
        return this.formatExpression(expressionPattern, first, "boolean", second, "varchar", third, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, String first, Long second, Long third) {
        return this.formatExpression(expressionPattern, first, "varchar", second, "bigint", third, "bigint");
    }

    private List<String> formatExpression(String expressionPattern, Object value, String type) {
        return this.formatExpression(expressionPattern, Arrays.asList(value), (List<String>)ImmutableList.of((Object)type));
    }

    private List<String> formatExpression(String expressionPattern, Object left, String leftType, Object right, String rightType) {
        return this.formatExpression(expressionPattern, Arrays.asList(left, right), (List<String>)ImmutableList.of((Object)leftType, (Object)rightType));
    }

    private List<String> formatExpression(String expressionPattern, Object first, String firstType, Object second, String secondType, Object third, String thirdType) {
        return this.formatExpression(expressionPattern, Arrays.asList(first, second, third), (List<String>)ImmutableList.of((Object)firstType, (Object)secondType, (Object)thirdType));
    }

    private List<String> formatExpression(String expressionPattern, List<Object> values, List<String> types) {
        Preconditions.checkArgument((values.size() == types.size() ? 1 : 0) != 0);
        ArrayList<ImmutableSet> unrolledValues = new ArrayList<ImmutableSet>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            String type = types.get(i);
            if (value != null) {
                if (type.equals("varchar")) {
                    value = "'" + value + "'";
                }
                unrolledValues.add(ImmutableSet.of((Object)String.valueOf(value)));
                continue;
            }
            unrolledValues.add(ImmutableSet.of((Object)("cast(null as " + type + ")")));
        }
        ImmutableList.Builder expressions = ImmutableList.builder();
        Set valueLists = Sets.cartesianProduct(unrolledValues);
        for (List valueList : valueLists) {
            expressions.add((Object)String.format(expressionPattern, valueList.toArray(new Object[valueList.size()])));
        }
        return expressions.build();
    }

    private void assertExecute(String expression, Object expected) {
        this.addCallable(new AssertExecuteTask(this.functionAssertions, expression, expected));
    }

    private void addCallable(Callable<Void> callable) {
        this.futures.add((ListenableFuture<Void>)this.executor.submit(callable));
    }

    private void assertExecute(List<String> expressions, Object expected) {
        if (expected instanceof Slice) {
            expected = ((Slice)expected).toString(StandardCharsets.UTF_8);
        }
        for (String expression : expressions) {
            this.assertExecute(expression, expected);
        }
    }

    private void assertFilterWithNoInputColumns(String filter, boolean expected) {
        this.addCallable(new AssertFilterTask(this.functionAssertions, filter, expected, true));
    }

    private void assertFilter(String filter, boolean expected) {
        this.addCallable(new AssertFilterTask(this.functionAssertions, filter, expected, false));
    }

    private static class AssertFilterTask
    implements Callable<Void> {
        private final FunctionAssertions functionAssertions;
        private final String filter;
        private final boolean expected;
        private final boolean withNoInputColumns;

        public AssertFilterTask(FunctionAssertions functionAssertions, String filter, boolean expected, boolean withNoInputColumns) {
            this.functionAssertions = functionAssertions;
            this.filter = filter;
            this.expected = expected;
            this.withNoInputColumns = withNoInputColumns;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.functionAssertions.assertFilter(this.filter, this.expected, this.withNoInputColumns);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error processing " + this.filter, e);
            }
            return null;
        }
    }

    private static class AssertExecuteTask
    implements Callable<Void> {
        private final FunctionAssertions functionAssertions;
        private final String expression;
        private final Object expected;

        public AssertExecuteTask(FunctionAssertions functionAssertions, String expression, Object expected) {
            this.functionAssertions = functionAssertions;
            this.expression = expression;
            this.expected = expected;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.functionAssertions.assertFunction(this.expression, this.expected);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error processing " + this.expression, e);
            }
            return null;
        }
    }
}

