/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TestingColumnHandle;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDomainTranslator {
    private static final Metadata METADATA = new MetadataManager();
    private static final Symbol A = new Symbol("a");
    private static final ColumnHandle ACH = TestDomainTranslator.newColumnHandle("a");
    private static final Symbol B = new Symbol("b");
    private static final ColumnHandle BCH = TestDomainTranslator.newColumnHandle("b");
    private static final Symbol C = new Symbol("c");
    private static final ColumnHandle CCH = TestDomainTranslator.newColumnHandle("c");
    private static final Symbol D = new Symbol("d");
    private static final ColumnHandle DCH = TestDomainTranslator.newColumnHandle("d");
    private static final Symbol E = new Symbol("e");
    private static final ColumnHandle ECH = TestDomainTranslator.newColumnHandle("e");
    private static final Symbol F = new Symbol("f");
    private static final ColumnHandle FCH = TestDomainTranslator.newColumnHandle("f");
    private static final Symbol G = new Symbol("g");
    private static final ColumnHandle GCH = TestDomainTranslator.newColumnHandle("g");
    private static final Symbol H = new Symbol("h");
    private static final ColumnHandle HCH = TestDomainTranslator.newColumnHandle("h");
    private static final Symbol I = new Symbol("i");
    private static final ColumnHandle ICH = TestDomainTranslator.newColumnHandle("i");
    private static final Map<Symbol, Type> TYPES = ImmutableMap.builder().put((Object)A, (Object)BigintType.BIGINT).put((Object)B, (Object)DoubleType.DOUBLE).put((Object)C, (Object)VarcharType.VARCHAR).put((Object)D, (Object)BooleanType.BOOLEAN).put((Object)E, (Object)BigintType.BIGINT).put((Object)F, (Object)DoubleType.DOUBLE).put((Object)G, (Object)VarcharType.VARCHAR).put((Object)H, (Object)TimestampType.TIMESTAMP).put((Object)I, (Object)DateType.DATE).build();
    private static final BiMap<Symbol, ColumnHandle> COLUMN_HANDLES = ImmutableBiMap.builder().put((Object)A, (Object)ACH).put((Object)B, (Object)BCH).put((Object)C, (Object)CCH).put((Object)D, (Object)DCH).put((Object)E, (Object)ECH).put((Object)F, (Object)FCH).put((Object)G, (Object)GCH).put((Object)H, (Object)HCH).put((Object)I, (Object)ICH).build();
    private static final long TIMESTAMP_VALUE = new DateTime(2013, 3, 30, 1, 5, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_VALUE = new DateTime(2001, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();

    @Test
    public void testNoneRoundTrip() throws Exception {
        TupleDomain tupleDomain = TupleDomain.none();
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testAllRoundTrip() throws Exception {
        TupleDomain tupleDomain = TupleDomain.all();
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testRoundTrip() throws Exception {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)ACH, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)BCH, (Object)Domain.onlyNull(Double.class)).put((Object)CCH, (Object)Domain.notNull(Slice.class)).put((Object)DCH, (Object)Domain.singleValue((Comparable)Boolean.valueOf(true))).put((Object)ECH, (Object)Domain.singleValue((Comparable)Long.valueOf(2L))).put((Object)FCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Double.valueOf(1.1)), (Range[])new Range[]{Range.equal((Comparable)Double.valueOf(2.0)), Range.range((Comparable)Double.valueOf(3.0), (boolean)false, (Comparable)Double.valueOf(3.5), (boolean)true)}), (boolean)true)).put((Object)GCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Slices.utf8Slice((String)"2013-01-01")), (Range[])new Range[]{Range.greaterThan((Comparable)Slices.utf8Slice((String)"2013-10-01"))}), (boolean)false)).put((Object)HCH, (Object)Domain.singleValue((Comparable)Long.valueOf(TIMESTAMP_VALUE))).put((Object)ICH, (Object)Domain.singleValue((Comparable)Long.valueOf(DATE_VALUE))).build());
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testToPredicateNone() throws Exception {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)ACH, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)BCH, (Object)Domain.onlyNull(Double.class)).put((Object)CCH, (Object)Domain.notNull(Slice.class)).put((Object)DCH, (Object)Domain.none(Boolean.class)).build());
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testToPredicateAllIgnored() throws Exception {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)ACH, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)BCH, (Object)Domain.onlyNull(Double.class)).put((Object)CCH, (Object)Domain.notNull(Slice.class)).put((Object)DCH, (Object)Domain.all(Boolean.class)).build());
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)ACH, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))).put((Object)BCH, (Object)Domain.onlyNull(Double.class)).put((Object)CCH, (Object)Domain.notNull(Slice.class)).build()));
    }

    @Test
    public void testToPredicate() throws Exception {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.isNotNull(A));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.onlyNull(Long.class)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.isNull(A));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.none(Long.class)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)BooleanLiteral.FALSE_LITERAL);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.all(Long.class)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)BooleanLiteral.TRUE_LITERAL);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(0L), (boolean)false, (Comparable)Long.valueOf(1L), (boolean)true), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(0L)), TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(1L))}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.singleValue((Comparable)Long.valueOf(1L))));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)TestDomainTranslator.in(A, ImmutableList.of((Object)1L, (Object)2L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true)));
        Assert.assertEquals((Object)TestDomainTranslator.toPredicate((TupleDomain<ColumnHandle>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.isNull(A)}));
    }

    @Test
    public void testFromUnknownPredicate() throws Exception {
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(TestDomainTranslator.unprocessableExpression1(A));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.unprocessableExpression1(A));
        result = TestDomainTranslator.fromPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(A)));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(A)));
    }

    @Test
    public void testFromAndPredicate() throws Exception {
        Expression originalPredicate = ExpressionUtils.and((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)})});
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(A), TestDomainTranslator.unprocessableExpression2(A)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(1L), (boolean)false, (Comparable)Long.valueOf(5L), (boolean)false), (Range[])new Range[0]), (boolean)false))));
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)})}));
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)})), TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)}))}));
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
    }

    @Test
    public void testFromOrPredicate() throws Exception {
        Expression originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)})});
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(2L)), TestDomainTranslator.unprocessableExpression2(A)})});
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(2L)), TestDomainTranslator.unprocessableExpression1(A)})});
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.unprocessableExpression1(A));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(B, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(A)})});
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.greaterThan(B, (Expression)TestDomainTranslator.doubleLiteral(1.0)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(2L)), TestDomainTranslator.greaterThan(B, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(A)})});
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.unprocessableExpression1(A));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)false), (Object)BCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Double.valueOf(1.0)), (Range[])new Range[0]), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.randPredicate(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(2L)), TestDomainTranslator.randPredicate(A)})});
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)})}));
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)})), TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)}))}));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)})), TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(5L)), TestDomainTranslator.unprocessableExpression2(A)}))}));
        result = TestDomainTranslator.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(A), TestDomainTranslator.unprocessableExpression2(A)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(1L), (boolean)false, (Comparable)Long.valueOf(5L), (boolean)false), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromNotPredicate() throws Exception {
        NotExpression originalPredicate = TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)), TestDomainTranslator.unprocessableExpression1(A)}));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = TestDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL);
        result = TestDomainTranslator.fromPredicate((Expression)originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalPredicate = TestDomainTranslator.not((Expression)TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(1L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(1L))}), (boolean)false))));
    }

    @Test
    public void testFromUnprocessableComparison() throws Exception {
        ComparisonExpression predicate = TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(A), TestDomainTranslator.unprocessableExpression2(A));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)predicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)predicate);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        predicate = TestDomainTranslator.not((Expression)TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(A), TestDomainTranslator.unprocessableExpression2(A)));
        result = TestDomainTranslator.fromPredicate((Expression)predicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)predicate);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
    }

    @Test
    public void testFromBasicComparisons() throws Exception {
        ComparisonExpression originalExpression = TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(2L));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.longLiteral(2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.longLiteral(2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)true))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromFlippedBasicComparisons() throws Exception {
        ComparisonExpression originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.LESS_THAN, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.EQUAL, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.NOT_EQUAL, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.longLiteral(2L), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)true))));
        originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.nullLiteral(), (Expression)TestDomainTranslator.reference(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
    }

    @Test
    public void testFromBasicComparisonsWithNulls() throws Exception {
        ComparisonExpression originalExpression = TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.nullLiteral());
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.onlyNull(Long.class))));
    }

    @Test
    public void testFromComparisonsWithImplictCoercions() throws Exception {
        ComparisonExpression originalExpression = TestDomainTranslator.greaterThan(B, (Expression)TestDomainTranslator.longLiteral(2L));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Double.valueOf(2.0)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.greaterThan(C, (Expression)TestDomainTranslator.stringLiteral("test"));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)CCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(3L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(3L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.none(Long.class))));
        originalExpression = TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
        originalExpression = TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.doubleLiteral(2.0));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)true))));
        originalExpression = TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(B, (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Double.valueOf(2.0)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C, (Expression)TestDomainTranslator.stringLiteral("test")));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)CCH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(3L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)Long.valueOf(3L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThan((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(2L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.equal(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.none(Long.class))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.doubleLiteral(2.0)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(A, (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
    }

    @Test
    public void testFromUnprocessableInPredicate() throws Exception {
        InPredicate originalExpression = new InPredicate(TestDomainTranslator.unprocessableExpression1(A), (Expression)new InListExpression((List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL)));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalExpression);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalExpression = new InPredicate((Expression)TestDomainTranslator.reference(D), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(D))));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.equal(D, TestDomainTranslator.unprocessableExpression1(D)));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalExpression = new InPredicate((Expression)TestDomainTranslator.reference(D), (Expression)new InListExpression((List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)TestDomainTranslator.unprocessableExpression1(D))));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.equal(D, (Expression)BooleanLiteral.TRUE_LITERAL), TestDomainTranslator.equal(D, TestDomainTranslator.unprocessableExpression1(D))}));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalExpression = TestDomainTranslator.not((Expression)new InPredicate((Expression)TestDomainTranslator.reference(D), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(D)))));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(D, TestDomainTranslator.unprocessableExpression1(D))));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
    }

    @Test
    public void testFromInPredicate() throws Exception {
        InPredicate originalExpression = TestDomainTranslator.in(A, ImmutableList.of((Object)1L));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.singleValue((Comparable)Long.valueOf(1L)))));
        originalExpression = TestDomainTranslator.in(A, ImmutableList.of((Object)1L, (Object)2L));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.in(A, ImmutableList.of((Object)1L, (Object)2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.range((Comparable)Long.valueOf(1L), (boolean)false, (Comparable)Long.valueOf(2L), (boolean)false), Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
    }

    @Test
    public void testFromBetweenPredicate() throws Exception {
        BetweenPredicate originalExpression = TestDomainTranslator.between(A, (Expression)TestDomainTranslator.longLiteral(1L), (Expression)TestDomainTranslator.longLiteral(2L));
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(2L), (boolean)true), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.between(A, (Expression)TestDomainTranslator.longLiteral(1L), (Expression)TestDomainTranslator.doubleLiteral(2.1));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Long.valueOf(1L), (boolean)true, (Comparable)Long.valueOf(2L), (boolean)true), (Range[])new Range[0]), (boolean)false))));
        originalExpression = TestDomainTranslator.between(A, (Expression)TestDomainTranslator.longLiteral(1L), (Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.between(A, (Expression)TestDomainTranslator.longLiteral(1L), (Expression)TestDomainTranslator.longLiteral(2L)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.between(A, (Expression)TestDomainTranslator.longLiteral(1L), (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(2L))}), (boolean)false))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.between(A, (Expression)TestDomainTranslator.longLiteral(1L), (Expression)TestDomainTranslator.nullLiteral()));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromIsNullPredicate() throws Exception {
        IsNullPredicate originalExpression = TestDomainTranslator.isNull(A);
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.onlyNull(Long.class))));
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(A));
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
    }

    @Test
    public void testFromIsNotNullPredicate() throws Exception {
        Expression originalExpression = TestDomainTranslator.isNotNull(A);
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate(originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.notNull(Long.class))));
        originalExpression = TestDomainTranslator.not(TestDomainTranslator.isNotNull(A));
        result = TestDomainTranslator.fromPredicate(originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ACH, (Object)Domain.onlyNull(Long.class))));
    }

    @Test
    public void testFromBooleanLiteralPredicate() throws Exception {
        BooleanLiteral originalExpression = BooleanLiteral.TRUE_LITERAL;
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalExpression = TestDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL);
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = BooleanLiteral.FALSE_LITERAL;
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)BooleanLiteral.FALSE_LITERAL);
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
    }

    @Test
    public void testFromNullLiteralPredicate() throws Exception {
        NullLiteral originalExpression = TestDomainTranslator.nullLiteral();
        DomainTranslator.ExtractionResult result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
        originalExpression = TestDomainTranslator.not((Expression)TestDomainTranslator.nullLiteral());
        result = TestDomainTranslator.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
    }

    private static DomainTranslator.ExtractionResult fromPredicate(Expression originalPredicate) {
        return DomainTranslator.fromPredicate((Metadata)METADATA, (Session)SessionTestUtils.TEST_SESSION, (Expression)originalPredicate, TYPES, COLUMN_HANDLES);
    }

    private static Expression toPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return DomainTranslator.toPredicate(tupleDomain, (Map)COLUMN_HANDLES.inverse(), TYPES);
    }

    private static ColumnHandle newColumnHandle(String name) {
        return new ColumnHandle("test", (ConnectorColumnHandle)new TestingColumnHandle(name));
    }

    private static Expression unprocessableExpression1(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN, (Expression)TestDomainTranslator.reference(symbol), (Expression)TestDomainTranslator.reference(symbol));
    }

    private static Expression unprocessableExpression2(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.LESS_THAN, (Expression)TestDomainTranslator.reference(symbol), (Expression)TestDomainTranslator.reference(symbol));
    }

    private static Expression randPredicate(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN, (Expression)TestDomainTranslator.reference(symbol), (Expression)new FunctionCall(new QualifiedName("rand"), (List)ImmutableList.of()));
    }

    private static QualifiedNameReference reference(Symbol symbol) {
        return new QualifiedNameReference(symbol.toQualifiedName());
    }

    private static NotExpression not(Expression expression) {
        return new NotExpression(expression);
    }

    private static ComparisonExpression comparison(ComparisonExpression.Type type, Expression expression1, Expression expression2) {
        return new ComparisonExpression(type, expression1, expression2);
    }

    private static ComparisonExpression equal(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.EQUAL, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static ComparisonExpression notEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.NOT_EQUAL, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static ComparisonExpression greaterThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static ComparisonExpression greaterThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static ComparisonExpression lessThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.LESS_THAN, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static ComparisonExpression lessThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static ComparisonExpression isDistinctFrom(Symbol symbol, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.reference(symbol), expression);
    }

    private static Expression isNotNull(Symbol symbol) {
        return new NotExpression((Expression)new IsNullPredicate((Expression)TestDomainTranslator.reference(symbol)));
    }

    private static IsNullPredicate isNull(Symbol symbol) {
        return new IsNullPredicate((Expression)TestDomainTranslator.reference(symbol));
    }

    private static InPredicate in(Symbol symbol, List<?> values) {
        List<Type> types = Collections.nCopies(values.size(), TYPES.get(symbol));
        List expressions = LiteralInterpreter.toExpressions(values, types);
        return new InPredicate((Expression)TestDomainTranslator.reference(symbol), (Expression)new InListExpression(expressions));
    }

    private static BetweenPredicate between(Symbol symbol, Expression min, Expression max) {
        return new BetweenPredicate((Expression)TestDomainTranslator.reference(symbol), min, max);
    }

    private static LongLiteral longLiteral(long value) {
        return new LongLiteral(Long.toString(value));
    }

    private static DoubleLiteral doubleLiteral(double value) {
        return new DoubleLiteral(Double.toString(value));
    }

    private static StringLiteral stringLiteral(String value) {
        return new StringLiteral(value);
    }

    private static NullLiteral nullLiteral() {
        return new NullLiteral();
    }
}

